/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.openapi.models.DiscoveryV1EndpointPort;
import io.kubernetes.client.openapi.models.V1Endpoint;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="EndpointSlice represents a subset of the endpoints that implement a service. For a given service there may be multiple EndpointSlice objects, selected by labels, which must be joined to produce the full set of endpoints.")
public class V1EndpointSlice
implements KubernetesObject {
    public static final String SERIALIZED_NAME_ADDRESS_TYPE = "addressType";
    @SerializedName(value="addressType")
    private AddressTypeEnum addressType;
    public static final String SERIALIZED_NAME_API_VERSION = "apiVersion";
    @SerializedName(value="apiVersion")
    private String apiVersion;
    public static final String SERIALIZED_NAME_ENDPOINTS = "endpoints";
    @SerializedName(value="endpoints")
    private List<V1Endpoint> endpoints = new ArrayList<V1Endpoint>();
    public static final String SERIALIZED_NAME_KIND = "kind";
    @SerializedName(value="kind")
    private String kind;
    public static final String SERIALIZED_NAME_METADATA = "metadata";
    @SerializedName(value="metadata")
    private V1ObjectMeta metadata;
    public static final String SERIALIZED_NAME_PORTS = "ports";
    @SerializedName(value="ports")
    private List<DiscoveryV1EndpointPort> ports = null;

    public V1EndpointSlice addressType(AddressTypeEnum addressType) {
        this.addressType = addressType;
        return this;
    }

    @ApiModelProperty(required=true, value="addressType specifies the type of address carried by this EndpointSlice. All addresses in this slice must be the same type. This field is immutable after creation. The following address types are currently supported: * IPv4: Represents an IPv4 Address. * IPv6: Represents an IPv6 Address. * FQDN: Represents a Fully Qualified Domain Name.  Possible enum values:  - `\"FQDN\"` represents a FQDN.  - `\"IPv4\"` represents an IPv4 Address.  - `\"IPv6\"` represents an IPv6 Address.")
    public AddressTypeEnum getAddressType() {
        return this.addressType;
    }

    public void setAddressType(AddressTypeEnum addressType) {
        this.addressType = addressType;
    }

    public V1EndpointSlice apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources")
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1EndpointSlice endpoints(List<V1Endpoint> endpoints) {
        this.endpoints = endpoints;
        return this;
    }

    public V1EndpointSlice addEndpointsItem(V1Endpoint endpointsItem) {
        this.endpoints.add(endpointsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="endpoints is a list of unique endpoints in this slice. Each slice may include a maximum of 1000 endpoints.")
    public List<V1Endpoint> getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(List<V1Endpoint> endpoints) {
        this.endpoints = endpoints;
    }

    public V1EndpointSlice kind(String kind) {
        this.kind = kind;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds")
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1EndpointSlice metadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1ObjectMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public V1EndpointSlice ports(List<DiscoveryV1EndpointPort> ports) {
        this.ports = ports;
        return this;
    }

    public V1EndpointSlice addPortsItem(DiscoveryV1EndpointPort portsItem) {
        if (this.ports == null) {
            this.ports = new ArrayList<DiscoveryV1EndpointPort>();
        }
        this.ports.add(portsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ports specifies the list of network ports exposed by each endpoint in this slice. Each port must have a unique name. When ports is empty, it indicates that there are no defined ports. When a port is defined with a nil port value, it indicates \"all ports\". Each slice may include a maximum of 100 ports.")
    public List<DiscoveryV1EndpointPort> getPorts() {
        return this.ports;
    }

    public void setPorts(List<DiscoveryV1EndpointPort> ports) {
        this.ports = ports;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1EndpointSlice v1EndpointSlice = (V1EndpointSlice)o;
        return Objects.equals((Object)this.addressType, (Object)v1EndpointSlice.addressType) && Objects.equals(this.apiVersion, v1EndpointSlice.apiVersion) && Objects.equals(this.endpoints, v1EndpointSlice.endpoints) && Objects.equals(this.kind, v1EndpointSlice.kind) && Objects.equals(this.metadata, v1EndpointSlice.metadata) && Objects.equals(this.ports, v1EndpointSlice.ports);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.addressType, this.apiVersion, this.endpoints, this.kind, this.metadata, this.ports});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1EndpointSlice {\n");
        sb.append("    addressType: ").append(this.toIndentedString((Object)this.addressType)).append("\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    endpoints: ").append(this.toIndentedString(this.endpoints)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    ports: ").append(this.toIndentedString(this.ports)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum AddressTypeEnum {
        FQDN("FQDN"),
        IPV4("IPv4"),
        IPV6("IPv6");

        private String value;

        private AddressTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static AddressTypeEnum fromValue(String value) {
            for (AddressTypeEnum b : AddressTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<AddressTypeEnum> {
            public void write(JsonWriter jsonWriter, AddressTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public AddressTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return AddressTypeEnum.fromValue(value);
            }
        }
    }
}

