/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1CertificateSigningRequestCondition;
import io.kubernetes.client.openapi.models.V1CertificateSigningRequestConditionBuilder;
import io.kubernetes.client.openapi.models.V1CertificateSigningRequestConditionFluentImpl;
import io.kubernetes.client.openapi.models.V1CertificateSigningRequestStatus;
import io.kubernetes.client.openapi.models.V1CertificateSigningRequestStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1CertificateSigningRequestStatusFluentImpl<A extends V1CertificateSigningRequestStatusFluent<A>>
extends BaseFluent<A>
implements V1CertificateSigningRequestStatusFluent<A> {
    private List<Byte> certificate;
    private ArrayList<V1CertificateSigningRequestConditionBuilder> conditions;

    public V1CertificateSigningRequestStatusFluentImpl() {
    }

    public V1CertificateSigningRequestStatusFluentImpl(V1CertificateSigningRequestStatus instance) {
        this.withCertificate(instance.getCertificate());
        this.withConditions(instance.getConditions());
    }

    @Override
    public A withCertificate(byte ... certificate) {
        if (this.certificate != null) {
            this.certificate.clear();
        }
        if (certificate != null) {
            for (byte item : certificate) {
                this.addToCertificate(item);
            }
        }
        return (A)this;
    }

    @Override
    public byte[] getCertificate() {
        int size = this.certificate != null ? this.certificate.size() : 0;
        byte[] result = new byte[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (byte item : this.certificate) {
            result[index++] = item;
        }
        return result;
    }

    @Override
    public A addToCertificate(Integer index, Byte item) {
        if (this.certificate == null) {
            this.certificate = new ArrayList<Byte>();
        }
        this.certificate.add(index, item);
        return (A)this;
    }

    @Override
    public A setToCertificate(Integer index, Byte item) {
        if (this.certificate == null) {
            this.certificate = new ArrayList<Byte>();
        }
        this.certificate.set(index, item);
        return (A)this;
    }

    @Override
    public A addToCertificate(Byte ... items) {
        if (this.certificate == null) {
            this.certificate = new ArrayList<Byte>();
        }
        for (Byte item : items) {
            this.certificate.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToCertificate(Collection<Byte> items) {
        if (this.certificate == null) {
            this.certificate = new ArrayList<Byte>();
        }
        for (Byte item : items) {
            this.certificate.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromCertificate(Byte ... items) {
        for (Byte item : items) {
            if (this.certificate == null) continue;
            this.certificate.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromCertificate(Collection<Byte> items) {
        for (Byte item : items) {
            if (this.certificate == null) continue;
            this.certificate.remove(item);
        }
        return (A)this;
    }

    @Override
    public Boolean hasCertificate() {
        return this.certificate != null && !this.certificate.isEmpty();
    }

    @Override
    public A addToConditions(Integer index, V1CertificateSigningRequestCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        V1CertificateSigningRequestConditionBuilder builder = new V1CertificateSigningRequestConditionBuilder(item);
        this._visitables.get("conditions").add(index >= 0 ? index.intValue() : this._visitables.get("conditions").size(), builder);
        this.conditions.add(index >= 0 ? index.intValue() : this.conditions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToConditions(Integer index, V1CertificateSigningRequestCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        V1CertificateSigningRequestConditionBuilder builder = new V1CertificateSigningRequestConditionBuilder(item);
        if (index < 0 || index >= this._visitables.get("conditions").size()) {
            this._visitables.get("conditions").add(builder);
        } else {
            this._visitables.get("conditions").set(index, builder);
        }
        if (index < 0 || index >= this.conditions.size()) {
            this.conditions.add(builder);
        } else {
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConditions(V1CertificateSigningRequestCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (V1CertificateSigningRequestCondition item : items) {
            V1CertificateSigningRequestConditionBuilder builder = new V1CertificateSigningRequestConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<V1CertificateSigningRequestCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (V1CertificateSigningRequestCondition item : items) {
            V1CertificateSigningRequestConditionBuilder builder = new V1CertificateSigningRequestConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(V1CertificateSigningRequestCondition ... items) {
        for (V1CertificateSigningRequestCondition item : items) {
            V1CertificateSigningRequestConditionBuilder builder = new V1CertificateSigningRequestConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<V1CertificateSigningRequestCondition> items) {
        for (V1CertificateSigningRequestCondition item : items) {
            V1CertificateSigningRequestConditionBuilder builder = new V1CertificateSigningRequestConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromConditions(Predicate<V1CertificateSigningRequestConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<V1CertificateSigningRequestConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            V1CertificateSigningRequestConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1CertificateSigningRequestCondition> getConditions() {
        return this.conditions != null ? V1CertificateSigningRequestStatusFluentImpl.build(this.conditions) : null;
    }

    @Override
    public List<V1CertificateSigningRequestCondition> buildConditions() {
        return this.conditions != null ? V1CertificateSigningRequestStatusFluentImpl.build(this.conditions) : null;
    }

    @Override
    public V1CertificateSigningRequestCondition buildCondition(Integer index) {
        return this.conditions.get(index).build();
    }

    @Override
    public V1CertificateSigningRequestCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    @Override
    public V1CertificateSigningRequestCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    @Override
    public V1CertificateSigningRequestCondition buildMatchingCondition(Predicate<V1CertificateSigningRequestConditionBuilder> predicate) {
        for (V1CertificateSigningRequestConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCondition(Predicate<V1CertificateSigningRequestConditionBuilder> predicate) {
        for (V1CertificateSigningRequestConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConditions(List<V1CertificateSigningRequestCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").removeAll(this.conditions);
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (V1CertificateSigningRequestCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    @Override
    public A withConditions(V1CertificateSigningRequestCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
        }
        if (conditions != null) {
            for (V1CertificateSigningRequestCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public V1CertificateSigningRequestStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public V1CertificateSigningRequestStatusFluent.ConditionsNested<A> addNewConditionLike(V1CertificateSigningRequestCondition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    @Override
    public V1CertificateSigningRequestStatusFluent.ConditionsNested<A> setNewConditionLike(Integer index, V1CertificateSigningRequestCondition item) {
        return new ConditionsNestedImpl(index, item);
    }

    @Override
    public V1CertificateSigningRequestStatusFluent.ConditionsNested<A> editCondition(Integer index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public V1CertificateSigningRequestStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    @Override
    public V1CertificateSigningRequestStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public V1CertificateSigningRequestStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<V1CertificateSigningRequestConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1CertificateSigningRequestStatusFluentImpl that = (V1CertificateSigningRequestStatusFluentImpl)o;
        if (this.certificate != null ? !this.certificate.equals(that.certificate) : that.certificate != null) {
            return false;
        }
        return !(this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null);
    }

    public int hashCode() {
        return Objects.hash(this.certificate, this.conditions, super.hashCode());
    }

    public class ConditionsNestedImpl<N>
    extends V1CertificateSigningRequestConditionFluentImpl<V1CertificateSigningRequestStatusFluent.ConditionsNested<N>>
    implements V1CertificateSigningRequestStatusFluent.ConditionsNested<N>,
    Nested<N> {
        V1CertificateSigningRequestConditionBuilder builder;
        Integer index;

        ConditionsNestedImpl(Integer index, V1CertificateSigningRequestCondition item) {
            this.index = index;
            this.builder = new V1CertificateSigningRequestConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new V1CertificateSigningRequestConditionBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1CertificateSigningRequestStatusFluentImpl.this.setToConditions(this.index, this.builder.build());
        }

        @Override
        public N endCondition() {
            return this.and();
        }
    }
}

