/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1CephFSPersistentVolumeSource;
import io.kubernetes.client.openapi.models.V1CephFSPersistentVolumeSourceFluent;
import io.kubernetes.client.openapi.models.V1SecretReference;
import io.kubernetes.client.openapi.models.V1SecretReferenceBuilder;
import io.kubernetes.client.openapi.models.V1SecretReferenceFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1CephFSPersistentVolumeSourceFluentImpl<A extends V1CephFSPersistentVolumeSourceFluent<A>>
extends BaseFluent<A>
implements V1CephFSPersistentVolumeSourceFluent<A> {
    private List<String> monitors;
    private String path;
    private Boolean readOnly;
    private String secretFile;
    private V1SecretReferenceBuilder secretRef;
    private String user;

    public V1CephFSPersistentVolumeSourceFluentImpl() {
    }

    public V1CephFSPersistentVolumeSourceFluentImpl(V1CephFSPersistentVolumeSource instance) {
        this.withMonitors(instance.getMonitors());
        this.withPath(instance.getPath());
        this.withReadOnly(instance.getReadOnly());
        this.withSecretFile(instance.getSecretFile());
        this.withSecretRef(instance.getSecretRef());
        this.withUser(instance.getUser());
    }

    @Override
    public A addToMonitors(Integer index, String item) {
        if (this.monitors == null) {
            this.monitors = new ArrayList<String>();
        }
        this.monitors.add(index, item);
        return (A)this;
    }

    @Override
    public A setToMonitors(Integer index, String item) {
        if (this.monitors == null) {
            this.monitors = new ArrayList<String>();
        }
        this.monitors.set(index, item);
        return (A)this;
    }

    @Override
    public A addToMonitors(String ... items) {
        if (this.monitors == null) {
            this.monitors = new ArrayList<String>();
        }
        for (String item : items) {
            this.monitors.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToMonitors(Collection<String> items) {
        if (this.monitors == null) {
            this.monitors = new ArrayList<String>();
        }
        for (String item : items) {
            this.monitors.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromMonitors(String ... items) {
        for (String item : items) {
            if (this.monitors == null) continue;
            this.monitors.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromMonitors(Collection<String> items) {
        for (String item : items) {
            if (this.monitors == null) continue;
            this.monitors.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getMonitors() {
        return this.monitors;
    }

    @Override
    public String getMonitor(Integer index) {
        return this.monitors.get(index);
    }

    @Override
    public String getFirstMonitor() {
        return this.monitors.get(0);
    }

    @Override
    public String getLastMonitor() {
        return this.monitors.get(this.monitors.size() - 1);
    }

    @Override
    public String getMatchingMonitor(Predicate<String> predicate) {
        for (String item : this.monitors) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingMonitor(Predicate<String> predicate) {
        for (String item : this.monitors) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withMonitors(List<String> monitors) {
        if (monitors != null) {
            this.monitors = new ArrayList<String>();
            for (String item : monitors) {
                this.addToMonitors(item);
            }
        } else {
            this.monitors = null;
        }
        return (A)this;
    }

    @Override
    public A withMonitors(String ... monitors) {
        if (this.monitors != null) {
            this.monitors.clear();
        }
        if (monitors != null) {
            for (String item : monitors) {
                this.addToMonitors(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasMonitors() {
        return this.monitors != null && !this.monitors.isEmpty();
    }

    @Override
    public A addNewMonitor(String original) {
        return this.addToMonitors(new String(original));
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public A withPath(String path) {
        this.path = path;
        return (A)this;
    }

    @Override
    public Boolean hasPath() {
        return this.path != null;
    }

    @Override
    @Deprecated
    public A withNewPath(String original) {
        return this.withPath(new String(original));
    }

    @Override
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    @Override
    public A withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return (A)this;
    }

    @Override
    public Boolean hasReadOnly() {
        return this.readOnly != null;
    }

    @Override
    public String getSecretFile() {
        return this.secretFile;
    }

    @Override
    public A withSecretFile(String secretFile) {
        this.secretFile = secretFile;
        return (A)this;
    }

    @Override
    public Boolean hasSecretFile() {
        return this.secretFile != null;
    }

    @Override
    @Deprecated
    public A withNewSecretFile(String original) {
        return this.withSecretFile(new String(original));
    }

    @Override
    @Deprecated
    public V1SecretReference getSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    @Override
    public V1SecretReference buildSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    @Override
    public A withSecretRef(V1SecretReference secretRef) {
        this._visitables.get("secretRef").remove(this.secretRef);
        if (secretRef != null) {
            this.secretRef = new V1SecretReferenceBuilder(secretRef);
            this._visitables.get("secretRef").add(this.secretRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSecretRef() {
        return this.secretRef != null;
    }

    @Override
    public V1CephFSPersistentVolumeSourceFluent.SecretRefNested<A> withNewSecretRef() {
        return new SecretRefNestedImpl();
    }

    @Override
    public V1CephFSPersistentVolumeSourceFluent.SecretRefNested<A> withNewSecretRefLike(V1SecretReference item) {
        return new SecretRefNestedImpl(item);
    }

    @Override
    public V1CephFSPersistentVolumeSourceFluent.SecretRefNested<A> editSecretRef() {
        return this.withNewSecretRefLike(this.getSecretRef());
    }

    @Override
    public V1CephFSPersistentVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRef() {
        return this.withNewSecretRefLike(this.getSecretRef() != null ? this.getSecretRef() : new V1SecretReferenceBuilder().build());
    }

    @Override
    public V1CephFSPersistentVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRefLike(V1SecretReference item) {
        return this.withNewSecretRefLike(this.getSecretRef() != null ? this.getSecretRef() : item);
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public A withUser(String user) {
        this.user = user;
        return (A)this;
    }

    @Override
    public Boolean hasUser() {
        return this.user != null;
    }

    @Override
    @Deprecated
    public A withNewUser(String original) {
        return this.withUser(new String(original));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1CephFSPersistentVolumeSourceFluentImpl that = (V1CephFSPersistentVolumeSourceFluentImpl)o;
        if (this.monitors != null ? !this.monitors.equals(that.monitors) : that.monitors != null) {
            return false;
        }
        if (this.path != null ? !this.path.equals(that.path) : that.path != null) {
            return false;
        }
        if (this.readOnly != null ? !this.readOnly.equals(that.readOnly) : that.readOnly != null) {
            return false;
        }
        if (this.secretFile != null ? !this.secretFile.equals(that.secretFile) : that.secretFile != null) {
            return false;
        }
        if (this.secretRef != null ? !this.secretRef.equals(that.secretRef) : that.secretRef != null) {
            return false;
        }
        return !(this.user != null ? !this.user.equals(that.user) : that.user != null);
    }

    public int hashCode() {
        return Objects.hash(this.monitors, this.path, this.readOnly, this.secretFile, this.secretRef, this.user, super.hashCode());
    }

    public class SecretRefNestedImpl<N>
    extends V1SecretReferenceFluentImpl<V1CephFSPersistentVolumeSourceFluent.SecretRefNested<N>>
    implements V1CephFSPersistentVolumeSourceFluent.SecretRefNested<N>,
    Nested<N> {
        V1SecretReferenceBuilder builder;

        SecretRefNestedImpl(V1SecretReference item) {
            this.builder = new V1SecretReferenceBuilder(this, item);
        }

        SecretRefNestedImpl() {
            this.builder = new V1SecretReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1CephFSPersistentVolumeSourceFluentImpl.this.withSecretRef(this.builder.build());
        }

        @Override
        public N endSecretRef() {
            return this.and();
        }
    }
}

