/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1CSIVolumeSource;
import io.kubernetes.client.openapi.models.V1CSIVolumeSourceFluent;
import io.kubernetes.client.openapi.models.V1LocalObjectReference;
import io.kubernetes.client.openapi.models.V1LocalObjectReferenceBuilder;
import io.kubernetes.client.openapi.models.V1LocalObjectReferenceFluentImpl;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class V1CSIVolumeSourceFluentImpl<A extends V1CSIVolumeSourceFluent<A>>
extends BaseFluent<A>
implements V1CSIVolumeSourceFluent<A> {
    private String driver;
    private String fsType;
    private V1LocalObjectReferenceBuilder nodePublishSecretRef;
    private Boolean readOnly;
    private Map<String, String> volumeAttributes;

    public V1CSIVolumeSourceFluentImpl() {
    }

    public V1CSIVolumeSourceFluentImpl(V1CSIVolumeSource instance) {
        this.withDriver(instance.getDriver());
        this.withFsType(instance.getFsType());
        this.withNodePublishSecretRef(instance.getNodePublishSecretRef());
        this.withReadOnly(instance.getReadOnly());
        this.withVolumeAttributes(instance.getVolumeAttributes());
    }

    @Override
    public String getDriver() {
        return this.driver;
    }

    @Override
    public A withDriver(String driver) {
        this.driver = driver;
        return (A)this;
    }

    @Override
    public Boolean hasDriver() {
        return this.driver != null;
    }

    @Override
    @Deprecated
    public A withNewDriver(String original) {
        return this.withDriver(new String(original));
    }

    @Override
    public String getFsType() {
        return this.fsType;
    }

    @Override
    public A withFsType(String fsType) {
        this.fsType = fsType;
        return (A)this;
    }

    @Override
    public Boolean hasFsType() {
        return this.fsType != null;
    }

    @Override
    @Deprecated
    public A withNewFsType(String original) {
        return this.withFsType(new String(original));
    }

    @Override
    @Deprecated
    public V1LocalObjectReference getNodePublishSecretRef() {
        return this.nodePublishSecretRef != null ? this.nodePublishSecretRef.build() : null;
    }

    @Override
    public V1LocalObjectReference buildNodePublishSecretRef() {
        return this.nodePublishSecretRef != null ? this.nodePublishSecretRef.build() : null;
    }

    @Override
    public A withNodePublishSecretRef(V1LocalObjectReference nodePublishSecretRef) {
        this._visitables.get("nodePublishSecretRef").remove(this.nodePublishSecretRef);
        if (nodePublishSecretRef != null) {
            this.nodePublishSecretRef = new V1LocalObjectReferenceBuilder(nodePublishSecretRef);
            this._visitables.get("nodePublishSecretRef").add(this.nodePublishSecretRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasNodePublishSecretRef() {
        return this.nodePublishSecretRef != null;
    }

    @Override
    public V1CSIVolumeSourceFluent.NodePublishSecretRefNested<A> withNewNodePublishSecretRef() {
        return new NodePublishSecretRefNestedImpl();
    }

    @Override
    public V1CSIVolumeSourceFluent.NodePublishSecretRefNested<A> withNewNodePublishSecretRefLike(V1LocalObjectReference item) {
        return new NodePublishSecretRefNestedImpl(item);
    }

    @Override
    public V1CSIVolumeSourceFluent.NodePublishSecretRefNested<A> editNodePublishSecretRef() {
        return this.withNewNodePublishSecretRefLike(this.getNodePublishSecretRef());
    }

    @Override
    public V1CSIVolumeSourceFluent.NodePublishSecretRefNested<A> editOrNewNodePublishSecretRef() {
        return this.withNewNodePublishSecretRefLike(this.getNodePublishSecretRef() != null ? this.getNodePublishSecretRef() : new V1LocalObjectReferenceBuilder().build());
    }

    @Override
    public V1CSIVolumeSourceFluent.NodePublishSecretRefNested<A> editOrNewNodePublishSecretRefLike(V1LocalObjectReference item) {
        return this.withNewNodePublishSecretRefLike(this.getNodePublishSecretRef() != null ? this.getNodePublishSecretRef() : item);
    }

    @Override
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    @Override
    public A withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return (A)this;
    }

    @Override
    public Boolean hasReadOnly() {
        return this.readOnly != null;
    }

    @Override
    public A addToVolumeAttributes(String key, String value) {
        if (this.volumeAttributes == null && key != null && value != null) {
            this.volumeAttributes = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.volumeAttributes.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToVolumeAttributes(Map<String, String> map) {
        if (this.volumeAttributes == null && map != null) {
            this.volumeAttributes = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.volumeAttributes.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromVolumeAttributes(String key) {
        if (this.volumeAttributes == null) {
            return (A)this;
        }
        if (key != null && this.volumeAttributes != null) {
            this.volumeAttributes.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromVolumeAttributes(Map<String, String> map) {
        if (this.volumeAttributes == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.volumeAttributes == null) continue;
                this.volumeAttributes.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getVolumeAttributes() {
        return this.volumeAttributes;
    }

    @Override
    public <K, V> A withVolumeAttributes(Map<String, String> volumeAttributes) {
        this.volumeAttributes = volumeAttributes == null ? null : new LinkedHashMap<String, String>(volumeAttributes);
        return (A)this;
    }

    @Override
    public Boolean hasVolumeAttributes() {
        return this.volumeAttributes != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1CSIVolumeSourceFluentImpl that = (V1CSIVolumeSourceFluentImpl)o;
        if (this.driver != null ? !this.driver.equals(that.driver) : that.driver != null) {
            return false;
        }
        if (this.fsType != null ? !this.fsType.equals(that.fsType) : that.fsType != null) {
            return false;
        }
        if (this.nodePublishSecretRef != null ? !this.nodePublishSecretRef.equals(that.nodePublishSecretRef) : that.nodePublishSecretRef != null) {
            return false;
        }
        if (this.readOnly != null ? !this.readOnly.equals(that.readOnly) : that.readOnly != null) {
            return false;
        }
        return !(this.volumeAttributes != null ? !this.volumeAttributes.equals(that.volumeAttributes) : that.volumeAttributes != null);
    }

    public int hashCode() {
        return Objects.hash(this.driver, this.fsType, this.nodePublishSecretRef, this.readOnly, this.volumeAttributes, super.hashCode());
    }

    public class NodePublishSecretRefNestedImpl<N>
    extends V1LocalObjectReferenceFluentImpl<V1CSIVolumeSourceFluent.NodePublishSecretRefNested<N>>
    implements V1CSIVolumeSourceFluent.NodePublishSecretRefNested<N>,
    Nested<N> {
        V1LocalObjectReferenceBuilder builder;

        NodePublishSecretRefNestedImpl(V1LocalObjectReference item) {
            this.builder = new V1LocalObjectReferenceBuilder(this, item);
        }

        NodePublishSecretRefNestedImpl() {
            this.builder = new V1LocalObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1CSIVolumeSourceFluentImpl.this.withNodePublishSecretRef(this.builder.build());
        }

        @Override
        public N endNodePublishSecretRef() {
            return this.and();
        }
    }
}

