/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import io.kubernetes.client.openapi.models.V1APIVersions;
import io.kubernetes.client.openapi.models.V1APIVersionsFluent;
import io.kubernetes.client.openapi.models.V1APIVersionsFluentImpl;
import java.util.Objects;

public class V1APIVersionsBuilder
extends V1APIVersionsFluentImpl<V1APIVersionsBuilder>
implements VisitableBuilder<V1APIVersions, V1APIVersionsBuilder> {
    V1APIVersionsFluent<?> fluent;
    Boolean validationEnabled;

    public V1APIVersionsBuilder() {
        this(false);
    }

    public V1APIVersionsBuilder(Boolean validationEnabled) {
        this(new V1APIVersions(), validationEnabled);
    }

    public V1APIVersionsBuilder(V1APIVersionsFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public V1APIVersionsBuilder(V1APIVersionsFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new V1APIVersions(), validationEnabled);
    }

    public V1APIVersionsBuilder(V1APIVersionsFluent<?> fluent, V1APIVersions instance) {
        this(fluent, instance, false);
    }

    public V1APIVersionsBuilder(V1APIVersionsFluent<?> fluent, V1APIVersions instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withServerAddressByClientCIDRs(instance.getServerAddressByClientCIDRs());
        fluent.withVersions(instance.getVersions());
        this.validationEnabled = validationEnabled;
    }

    public V1APIVersionsBuilder(V1APIVersions instance) {
        this(instance, (Boolean)false);
    }

    public V1APIVersionsBuilder(V1APIVersions instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withServerAddressByClientCIDRs(instance.getServerAddressByClientCIDRs());
        this.withVersions(instance.getVersions());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public V1APIVersions build() {
        V1APIVersions buildable = new V1APIVersions();
        buildable.setApiVersion(this.fluent.getApiVersion());
        buildable.setKind(this.fluent.getKind());
        buildable.setServerAddressByClientCIDRs(this.fluent.getServerAddressByClientCIDRs());
        buildable.setVersions(this.fluent.getVersions());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1APIVersionsBuilder that = (V1APIVersionsBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

