/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.netty;

import io.ktor.application.ApplicationCall;
import io.ktor.application.DefaultApplicationEventsKt;
import io.ktor.server.engine.ApplicationEngine;
import io.ktor.server.engine.ApplicationEngineEnvironment;
import io.ktor.server.engine.ApplicationEngineJvmKt;
import io.ktor.server.engine.BaseApplicationEngine;
import io.ktor.server.engine.EngineConnectorConfig;
import io.ktor.server.engine.EngineContextCancellationHelperKt;
import io.ktor.server.engine.EnginePipeline;
import io.ktor.server.netty.EventLoopGroupProxy;
import io.ktor.server.netty.NettyApplicationCall;
import io.ktor.server.netty.NettyApplicationEngine;
import io.ktor.server.netty.NettyChannelInitializer;
import io.ktor.server.netty.NettyDispatcher;
import io.ktor.util.DispatcherWithShutdown;
import io.ktor.util.pipeline.PipelineContext;
import io.ktor.util.pipeline.PipelinePhase;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.Future;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CompletableJob;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.ExecutorsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\"B(\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0019\b\u0002\u0010\u0004\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\b\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0016J\b\u0010 \u001a\u00020!H\u0016R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lio/ktor/server/netty/NettyApplicationEngine;", "Lio/ktor/server/engine/BaseApplicationEngine;", "environment", "Lio/ktor/server/engine/ApplicationEngineEnvironment;", "configure", "Lkotlin/Function1;", "Lio/ktor/server/netty/NettyApplicationEngine$Configuration;", "", "Lkotlin/ExtensionFunctionType;", "(Lio/ktor/server/engine/ApplicationEngineEnvironment;Lkotlin/jvm/functions/Function1;)V", "bootstraps", "", "Lio/netty/bootstrap/ServerBootstrap;", "callEventGroup", "Lio/ktor/server/netty/EventLoopGroupProxy;", "cancellationDeferred", "Lkotlinx/coroutines/CompletableJob;", "channels", "Lio/netty/channel/Channel;", "configuration", "connectionEventGroup", "dispatcherWithShutdown", "Lio/ktor/util/DispatcherWithShutdown;", "engineDispatcherWithShutdown", "workerEventGroup", "start", "wait", "", "stop", "gracePeriodMillis", "", "timeoutMillis", "toString", "", "Configuration", "ktor-server-netty"})
public final class NettyApplicationEngine
extends BaseApplicationEngine {
    private final Configuration configuration;
    private final EventLoopGroupProxy connectionEventGroup;
    private final EventLoopGroupProxy workerEventGroup;
    private final EventLoopGroupProxy callEventGroup;
    private final DispatcherWithShutdown dispatcherWithShutdown;
    private final DispatcherWithShutdown engineDispatcherWithShutdown;
    private CompletableJob cancellationDeferred;
    private List<? extends Channel> channels;
    private final List<ServerBootstrap> bootstraps;

    @NotNull
    public NettyApplicationEngine start(boolean wait) {
        ChannelFuture channelFuture;
        ChannelFuture it;
        Collection<ChannelFuture> collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        this.getEnvironment().start();
        Iterable iterable = CollectionsKt.zip((Iterable)this.bootstraps, (Iterable)this.getEnvironment().getConnectors());
        Object object = this;
        boolean $i$f$map = false;
        Iterator iterator = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            channelFuture = ((ServerBootstrap)it.getFirst()).bind(((EngineConnectorConfig)it.getSecond()).getHost(), ((EngineConnectorConfig)it.getSecond()).getPort());
            collection.add(channelFuture);
        }
        collection = (List)destination$iv$iv;
        $this$map$iv = collection;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ChannelFuture)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            channelFuture = it.sync().channel();
            collection.add(channelFuture);
        }
        collection = (List)destination$iv$iv;
        ((NettyApplicationEngine)((Object)object)).channels = collection;
        this.cancellationDeferred = EngineContextCancellationHelperKt.stopServerOnCancellation((ApplicationEngine)this);
        if (wait) {
            List<? extends Channel> list = this.channels;
            if (list != null) {
                $this$map$iv = list;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (Channel)item$iv$iv;
                    object = destination$iv$iv;
                    boolean bl = false;
                    collection = it.closeFuture();
                    object.add(collection);
                }
                Iterable $this$forEach$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ChannelFuture it2 = (ChannelFuture)element$iv;
                    boolean bl = false;
                    it2.sync();
                }
            }
            ApplicationEngineJvmKt.stop((ApplicationEngine)this, (long)1L, (long)5L, (TimeUnit)TimeUnit.SECONDS);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void stop(long gracePeriodMillis, long timeoutMillis) {
        List list;
        boolean $i$f$mapNotNull;
        Iterable $this$mapNotNull$iv;
        CompletableJob completableJob = this.cancellationDeferred;
        if (completableJob != null) {
            completableJob.complete();
        }
        this.getEnvironment().getMonitor().raise(DefaultApplicationEventsKt.getApplicationStopPreparing(), (Object)this.getEnvironment());
        List<? extends Channel> list2 = this.channels;
        if (list2 != null) {
            void $this$mapNotNullTo$iv$iv;
            $this$mapNotNull$iv = list2;
            $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                ChannelFuture channelFuture;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Channel it = (Channel)element$iv$iv;
                boolean bl2 = false;
                if ((it.isOpen() ? it.close() : null) == null) continue;
                channelFuture = channelFuture;
                boolean bl3 = false;
                boolean bl4 = false;
                ChannelFuture it$iv$iv = channelFuture;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        $this$mapNotNull$iv = list;
        $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        if (iterable == null) {
            iterable = CollectionsKt.emptyList();
        }
        Iterable channelFutures = iterable;
        this.dispatcherWithShutdown.prepareShutdown();
        this.engineDispatcherWithShutdown.prepareShutdown();
        try {
            Future<?> shutdownConnections = this.connectionEventGroup.shutdownGracefully(gracePeriodMillis, timeoutMillis, TimeUnit.MILLISECONDS);
            shutdownConnections.await();
            Future<?> shutdownWorkers = this.workerEventGroup.shutdownGracefully(gracePeriodMillis, timeoutMillis, TimeUnit.MILLISECONDS);
            if (this.configuration.getShareWorkGroup()) {
                shutdownWorkers.await();
            } else {
                Future<?> shutdownCall = this.callEventGroup.shutdownGracefully(gracePeriodMillis, timeoutMillis, TimeUnit.MILLISECONDS);
                shutdownWorkers.await();
                shutdownCall.await();
            }
            this.getEnvironment().stop();
        }
        finally {
            this.dispatcherWithShutdown.completeShutdown();
            this.engineDispatcherWithShutdown.completeShutdown();
            Iterable $this$forEach$iv = channelFutures;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ChannelFuture it = (ChannelFuture)element$iv;
                boolean bl = false;
                it.sync();
            }
        }
    }

    @NotNull
    public String toString() {
        return "Netty(" + this.getEnvironment() + ')';
    }

    /*
     * WARNING - void declaration
     */
    public NettyApplicationEngine(@NotNull ApplicationEngineEnvironment environment, @NotNull Function1<? super Configuration, Unit> configure) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        Intrinsics.checkParameterIsNotNull(configure, (String)"configure");
        super(environment, null, 2, null);
        Object object = new Configuration();
        NettyApplicationEngine nettyApplicationEngine = this;
        boolean bl = false;
        boolean bl2 = false;
        configure.invoke(object);
        Object object2 = object;
        nettyApplicationEngine.configuration = object2;
        this.connectionEventGroup = EventLoopGroupProxy.Companion.create(this.configuration.getConnectionGroupSize());
        this.workerEventGroup = this.configuration.getShareWorkGroup() ? EventLoopGroupProxy.Companion.create(this.configuration.getWorkerGroupSize() + this.configuration.getCallGroupSize()) : EventLoopGroupProxy.Companion.create(this.configuration.getWorkerGroupSize());
        this.callEventGroup = this.configuration.getShareWorkGroup() ? this.workerEventGroup : EventLoopGroupProxy.Companion.create(this.configuration.getCallGroupSize());
        this.dispatcherWithShutdown = new DispatcherWithShutdown((CoroutineDispatcher)NettyDispatcher.INSTANCE);
        this.engineDispatcherWithShutdown = new DispatcherWithShutdown((CoroutineDispatcher)ExecutorsKt.from((ExecutorService)((ExecutorService)((Object)this.workerEventGroup))));
        object = environment.getConnectors();
        nettyApplicationEngine = this;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void connector;
            EngineConnectorConfig engineConnectorConfig = (EngineConnectorConfig)item$iv$iv;
            object2 = destination$iv$iv;
            boolean bl3 = false;
            ServerBootstrap serverBootstrap = new ServerBootstrap();
            boolean bl4 = false;
            boolean bl5 = false;
            ServerBootstrap $this$apply = serverBootstrap;
            boolean bl6 = false;
            this.configuration.getConfigureBootstrap().invoke((Object)$this$apply);
            $this$apply.group((EventLoopGroup)this.connectionEventGroup, (EventLoopGroup)this.workerEventGroup);
            $this$apply.channel(JvmClassMappingKt.getJavaClass(this.connectionEventGroup.getChannel()));
            $this$apply.childHandler((ChannelHandler)new NettyChannelInitializer(this.getPipeline(), environment, (EventExecutorGroup)this.callEventGroup, (CoroutineContext)this.engineDispatcherWithShutdown, (CoroutineContext)this.dispatcherWithShutdown, (EngineConnectorConfig)connector, this.configuration.getRequestQueueLimit(), this.configuration.getRunningLimit(), this.configuration.getResponseWriteTimeoutSeconds(), this.configuration.getRequestReadTimeoutSeconds(), this.configuration.getHttpServerCodec()));
            ServerBootstrap serverBootstrap2 = serverBootstrap;
            object2.add(serverBootstrap2);
        }
        object2 = (List)destination$iv$iv;
        nettyApplicationEngine.bootstraps = object2;
        PipelinePhase afterCall = new PipelinePhase("After");
        this.getPipeline().insertPhaseAfter(EnginePipeline.Companion.getCall(), afterCall);
        this.getPipeline().intercept(afterCall, (Function3)new Function3<PipelineContext<Unit, ApplicationCall>, Unit, Continuation<? super Unit>, Object>(null){
            private PipelineContext p$;
            private Unit p$0;
            Object L$0;
            Object L$1;
            int label;

            @Nullable
            public final Object invokeSuspend(@NotNull Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        PipelineContext $this$intercept = this.p$;
                        Unit it = this.p$0;
                        PipelineContext $this$call$iv = $this$intercept;
                        boolean $i$f$getCall = false;
                        ApplicationCall applicationCall = (ApplicationCall)$this$call$iv.getContext();
                        if (!(applicationCall instanceof NettyApplicationCall)) {
                            applicationCall = null;
                        }
                        NettyApplicationCall nettyApplicationCall = (NettyApplicationCall)applicationCall;
                        if (nettyApplicationCall == null) break;
                        NettyApplicationCall nettyApplicationCall2 = nettyApplicationCall;
                        this.L$0 = $this$intercept;
                        this.L$1 = it;
                        this.label = 1;
                        Object object2 = nettyApplicationCall2.finish$ktor_server_netty((Continuation<? super Unit>)this);
                        if (object2 == object) {
                            return object;
                        }
                        break;
                    }
                    case 1: {
                        Unit it = (Unit)this.L$1;
                        PipelineContext $this$intercept = (PipelineContext)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        break;
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull PipelineContext<Unit, ApplicationCall> $this$create, @NotNull Unit it, @NotNull Continuation<? super Unit> continuation) {
                Intrinsics.checkParameterIsNotNull($this$create, (String)"$this$create");
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                Intrinsics.checkParameterIsNotNull(continuation, (String)"continuation");
                Function3<PipelineContext<Unit, ApplicationCall>, Unit, Continuation<? super Unit>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                PipelineContext<Unit, ApplicationCall> pipelineContext = function3.p$ = $this$create;
                Unit unit = function3.p$0 = it;
                return function3;
            }

            public final Object invoke(Object object, Object object2, Object object3) {
                return (this.create((PipelineContext<Unit, ApplicationCall>)((PipelineContext)object), (Unit)object2, (Continuation<? super Unit>)((Continuation)object3))).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    public /* synthetic */ NettyApplicationEngine(ApplicationEngineEnvironment applicationEngineEnvironment, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function1 = 1.INSTANCE;
        }
        this(applicationEngineEnvironment, (Function1<? super Configuration, Unit>)function1);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R+\u0010\u0003\u001a\u0013\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0002\b\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR \u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0016\"\u0004\b\u001b\u0010\u0018R\u001a\u0010\u001c\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0016\"\u0004\b\u001e\u0010\u0018R\u001a\u0010\u001f\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0016\"\u0004\b!\u0010\u0018R\u001a\u0010\"\u001a\u00020#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'\u00a8\u0006("}, d2={"Lio/ktor/server/netty/NettyApplicationEngine$Configuration;", "Lio/ktor/server/engine/BaseApplicationEngine$Configuration;", "()V", "configureBootstrap", "Lkotlin/Function1;", "Lio/netty/bootstrap/ServerBootstrap;", "", "Lkotlin/ExtensionFunctionType;", "getConfigureBootstrap", "()Lkotlin/jvm/functions/Function1;", "setConfigureBootstrap", "(Lkotlin/jvm/functions/Function1;)V", "httpServerCodec", "Lkotlin/Function0;", "Lio/netty/handler/codec/http/HttpServerCodec;", "getHttpServerCodec", "()Lkotlin/jvm/functions/Function0;", "setHttpServerCodec", "(Lkotlin/jvm/functions/Function0;)V", "requestQueueLimit", "", "getRequestQueueLimit", "()I", "setRequestQueueLimit", "(I)V", "requestReadTimeoutSeconds", "getRequestReadTimeoutSeconds", "setRequestReadTimeoutSeconds", "responseWriteTimeoutSeconds", "getResponseWriteTimeoutSeconds", "setResponseWriteTimeoutSeconds", "runningLimit", "getRunningLimit", "setRunningLimit", "shareWorkGroup", "", "getShareWorkGroup", "()Z", "setShareWorkGroup", "(Z)V", "ktor-server-netty"})
    public static final class Configuration
    extends BaseApplicationEngine.Configuration {
        private int requestQueueLimit = 16;
        private int runningLimit = 10;
        private boolean shareWorkGroup;
        @NotNull
        private Function1<? super ServerBootstrap, Unit> configureBootstrap = configureBootstrap.1.INSTANCE;
        private int responseWriteTimeoutSeconds = 10;
        private int requestReadTimeoutSeconds;
        @NotNull
        private Function0<HttpServerCodec> httpServerCodec = httpServerCodec.1.INSTANCE;

        public final int getRequestQueueLimit() {
            return this.requestQueueLimit;
        }

        public final void setRequestQueueLimit(int n) {
            this.requestQueueLimit = n;
        }

        public final int getRunningLimit() {
            return this.runningLimit;
        }

        public final void setRunningLimit(int n) {
            this.runningLimit = n;
        }

        public final boolean getShareWorkGroup() {
            return this.shareWorkGroup;
        }

        public final void setShareWorkGroup(boolean bl) {
            this.shareWorkGroup = bl;
        }

        @NotNull
        public final Function1<ServerBootstrap, Unit> getConfigureBootstrap() {
            return this.configureBootstrap;
        }

        public final void setConfigureBootstrap(@NotNull Function1<? super ServerBootstrap, Unit> function1) {
            Intrinsics.checkParameterIsNotNull(function1, (String)"<set-?>");
            this.configureBootstrap = function1;
        }

        public final int getResponseWriteTimeoutSeconds() {
            return this.responseWriteTimeoutSeconds;
        }

        public final void setResponseWriteTimeoutSeconds(int n) {
            this.responseWriteTimeoutSeconds = n;
        }

        public final int getRequestReadTimeoutSeconds() {
            return this.requestReadTimeoutSeconds;
        }

        public final void setRequestReadTimeoutSeconds(int n) {
            this.requestReadTimeoutSeconds = n;
        }

        @NotNull
        public final Function0<HttpServerCodec> getHttpServerCodec() {
            return this.httpServerCodec;
        }

        public final void setHttpServerCodec(@NotNull Function0<HttpServerCodec> function0) {
            Intrinsics.checkParameterIsNotNull(function0, (String)"<set-?>");
            this.httpServerCodec = function0;
        }
    }
}

