/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.framework.discovery;

import io.kotest.core.spec.Spec;
import io.kotest.framework.discovery.FullyQualifiedClassName;
import io.kotest.framework.discovery.Modifier;
import io.kotest.framework.discovery.PackageName;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.reflect.KVisibility;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\b\t\nB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006H&\u0082\u0001\u0003\u000b\f\r\u00a8\u0006\u000e"}, d2={"Lio/kotest/framework/discovery/DiscoveryFilter;", "", "()V", "test", "", "kclass", "Lkotlin/reflect/KClass;", "Lio/kotest/core/spec/Spec;", "ClassModifierDiscoveryFilter", "ClassNameDiscoveryFilter", "PackageNameDiscoveryFilter", "Lio/kotest/framework/discovery/DiscoveryFilter$ClassNameDiscoveryFilter;", "Lio/kotest/framework/discovery/DiscoveryFilter$PackageNameDiscoveryFilter;", "Lio/kotest/framework/discovery/DiscoveryFilter$ClassModifierDiscoveryFilter;", "kotest-framework-discovery"})
public abstract class DiscoveryFilter {
    public abstract boolean test(@NotNull KClass<? extends Spec> var1);

    private DiscoveryFilter() {
    }

    public /* synthetic */ DiscoveryFilter(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\u001f\u0010\n\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\u00052\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\u0018\u0010\u0010\u001a\u00020\u00052\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0012H\u0016J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"Lio/kotest/framework/discovery/DiscoveryFilter$ClassNameDiscoveryFilter;", "Lio/kotest/framework/discovery/DiscoveryFilter;", "f", "Lkotlin/Function1;", "Lio/kotest/framework/discovery/FullyQualifiedClassName;", "", "(Lkotlin/jvm/functions/Function1;)V", "getF", "()Lkotlin/jvm/functions/Function1;", "component1", "copy", "equals", "other", "", "hashCode", "", "test", "kclass", "Lkotlin/reflect/KClass;", "Lio/kotest/core/spec/Spec;", "toString", "", "kotest-framework-discovery"})
    public static final class ClassNameDiscoveryFilter
    extends DiscoveryFilter {
        @NotNull
        private final Function1<FullyQualifiedClassName, Boolean> f;

        @Override
        public boolean test(@NotNull KClass<? extends Spec> kclass) {
            Intrinsics.checkNotNullParameter(kclass, (String)"kclass");
            String string = kclass.getQualifiedName();
            if (string == null) {
                string = JvmClassMappingKt.getJavaClass(kclass).getCanonicalName();
            }
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"kclass.qualifiedName ?: kclass.java.canonicalName");
            return (Boolean)this.f.invoke((Object)new FullyQualifiedClassName(string));
        }

        @NotNull
        public final Function1<FullyQualifiedClassName, Boolean> getF() {
            return this.f;
        }

        public ClassNameDiscoveryFilter(@NotNull Function1<? super FullyQualifiedClassName, Boolean> f) {
            Intrinsics.checkNotNullParameter(f, (String)"f");
            super(null);
            this.f = f;
        }

        @NotNull
        public final Function1<FullyQualifiedClassName, Boolean> component1() {
            return this.f;
        }

        @NotNull
        public final ClassNameDiscoveryFilter copy(@NotNull Function1<? super FullyQualifiedClassName, Boolean> f) {
            Intrinsics.checkNotNullParameter(f, (String)"f");
            return new ClassNameDiscoveryFilter(f);
        }

        public static /* synthetic */ ClassNameDiscoveryFilter copy$default(ClassNameDiscoveryFilter classNameDiscoveryFilter, Function1 function1, int n, Object object) {
            if ((n & 1) != 0) {
                function1 = classNameDiscoveryFilter.f;
            }
            return classNameDiscoveryFilter.copy(function1);
        }

        @NotNull
        public String toString() {
            return "ClassNameDiscoveryFilter(f=" + this.f + ")";
        }

        public int hashCode() {
            Function1<FullyQualifiedClassName, Boolean> function1 = this.f;
            return function1 != null ? function1.hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ClassNameDiscoveryFilter)) break block3;
                    ClassNameDiscoveryFilter classNameDiscoveryFilter = (ClassNameDiscoveryFilter)object;
                    if (!Intrinsics.areEqual(this.f, classNameDiscoveryFilter.f)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\u001f\u0010\n\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\u00052\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\u0018\u0010\u0010\u001a\u00020\u00052\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0012H\u0016J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"Lio/kotest/framework/discovery/DiscoveryFilter$PackageNameDiscoveryFilter;", "Lio/kotest/framework/discovery/DiscoveryFilter;", "f", "Lkotlin/Function1;", "Lio/kotest/framework/discovery/PackageName;", "", "(Lkotlin/jvm/functions/Function1;)V", "getF", "()Lkotlin/jvm/functions/Function1;", "component1", "copy", "equals", "other", "", "hashCode", "", "test", "kclass", "Lkotlin/reflect/KClass;", "Lio/kotest/core/spec/Spec;", "toString", "", "kotest-framework-discovery"})
    public static final class PackageNameDiscoveryFilter
    extends DiscoveryFilter {
        @NotNull
        private final Function1<PackageName, Boolean> f;

        @Override
        public boolean test(@NotNull KClass<? extends Spec> kclass) {
            Intrinsics.checkNotNullParameter(kclass, (String)"kclass");
            Package package_ = JvmClassMappingKt.getJavaClass(kclass).getPackage();
            Intrinsics.checkNotNullExpressionValue((Object)package_, (String)"kclass.java.`package`");
            String string = package_.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"kclass.java.`package`.name");
            return (Boolean)this.f.invoke((Object)new PackageName(string));
        }

        @NotNull
        public final Function1<PackageName, Boolean> getF() {
            return this.f;
        }

        public PackageNameDiscoveryFilter(@NotNull Function1<? super PackageName, Boolean> f) {
            Intrinsics.checkNotNullParameter(f, (String)"f");
            super(null);
            this.f = f;
        }

        @NotNull
        public final Function1<PackageName, Boolean> component1() {
            return this.f;
        }

        @NotNull
        public final PackageNameDiscoveryFilter copy(@NotNull Function1<? super PackageName, Boolean> f) {
            Intrinsics.checkNotNullParameter(f, (String)"f");
            return new PackageNameDiscoveryFilter(f);
        }

        public static /* synthetic */ PackageNameDiscoveryFilter copy$default(PackageNameDiscoveryFilter packageNameDiscoveryFilter, Function1 function1, int n, Object object) {
            if ((n & 1) != 0) {
                function1 = packageNameDiscoveryFilter.f;
            }
            return packageNameDiscoveryFilter.copy(function1);
        }

        @NotNull
        public String toString() {
            return "PackageNameDiscoveryFilter(f=" + this.f + ")";
        }

        public int hashCode() {
            Function1<PackageName, Boolean> function1 = this.f;
            return function1 != null ? function1.hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof PackageNameDiscoveryFilter)) break block3;
                    PackageNameDiscoveryFilter packageNameDiscoveryFilter = (PackageNameDiscoveryFilter)object;
                    if (!Intrinsics.areEqual(this.f, packageNameDiscoveryFilter.f)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\u0018\u0010\u0010\u001a\u00020\u000b2\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0012H\u0016J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lio/kotest/framework/discovery/DiscoveryFilter$ClassModifierDiscoveryFilter;", "Lio/kotest/framework/discovery/DiscoveryFilter;", "modifiers", "", "Lio/kotest/framework/discovery/Modifier;", "(Ljava/util/Set;)V", "getModifiers", "()Ljava/util/Set;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "test", "kclass", "Lkotlin/reflect/KClass;", "Lio/kotest/core/spec/Spec;", "toString", "", "kotest-framework-discovery"})
    public static final class ClassModifierDiscoveryFilter
    extends DiscoveryFilter {
        @NotNull
        private final Set<Modifier> modifiers;

        @Override
        public boolean test(@NotNull KClass<? extends Spec> kclass) {
            Intrinsics.checkNotNullParameter(kclass, (String)"kclass");
            if (kclass.getVisibility() == KVisibility.INTERNAL) {
                return this.modifiers.contains((Object)Modifier.Internal);
            }
            if (kclass.getVisibility() == KVisibility.PUBLIC || java.lang.reflect.Modifier.isPublic(JvmClassMappingKt.getJavaClass(kclass).getModifiers())) {
                return this.modifiers.contains((Object)Modifier.Public);
            }
            if (kclass.getVisibility() == KVisibility.PRIVATE || java.lang.reflect.Modifier.isPrivate(JvmClassMappingKt.getJavaClass(kclass).getModifiers())) {
                return this.modifiers.contains((Object)Modifier.Private);
            }
            return false;
        }

        @NotNull
        public final Set<Modifier> getModifiers() {
            return this.modifiers;
        }

        public ClassModifierDiscoveryFilter(@NotNull Set<? extends Modifier> modifiers) {
            Intrinsics.checkNotNullParameter(modifiers, (String)"modifiers");
            super(null);
            this.modifiers = modifiers;
        }

        @NotNull
        public final Set<Modifier> component1() {
            return this.modifiers;
        }

        @NotNull
        public final ClassModifierDiscoveryFilter copy(@NotNull Set<? extends Modifier> modifiers) {
            Intrinsics.checkNotNullParameter(modifiers, (String)"modifiers");
            return new ClassModifierDiscoveryFilter(modifiers);
        }

        public static /* synthetic */ ClassModifierDiscoveryFilter copy$default(ClassModifierDiscoveryFilter classModifierDiscoveryFilter, Set set, int n, Object object) {
            if ((n & 1) != 0) {
                set = classModifierDiscoveryFilter.modifiers;
            }
            return classModifierDiscoveryFilter.copy(set);
        }

        @NotNull
        public String toString() {
            return "ClassModifierDiscoveryFilter(modifiers=" + this.modifiers + ")";
        }

        public int hashCode() {
            Set<Modifier> set = this.modifiers;
            return set != null ? ((Object)set).hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ClassModifierDiscoveryFilter)) break block3;
                    ClassModifierDiscoveryFilter classModifierDiscoveryFilter = (ClassModifierDiscoveryFilter)object;
                    if (!Intrinsics.areEqual(this.modifiers, classModifierDiscoveryFilter.modifiers)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

