package io.kotest.core.factory

import io.kotest.core.Tag
import io.kotest.core.extensions.Extension
import io.kotest.core.spec.RootTest
import io.kotest.core.spec.Spec
import io.kotest.core.test.AssertionMode

/**
 * A [TestFactory] is a generator of tests along with optional configuration and
 * callbacks related to those tests. A test factory can be added to a [Spec] and the
 * tests generated by the factory will be included in that spec.
 *
 * Factories are useful if you want to group tests together with some callbacks and settings
 * and inject them into specs as a unit.
 */
data class TestFactory(
   val factoryId: FactoryId,
   val tests: List<RootTest>,
   val tags: Set<Tag>,
   val assertionMode: AssertionMode?,
   val extensions: List<Extension>,
)
