/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.assertions.eq;

import io.kotest.assertions.Actual;
import io.kotest.assertions.AssertionsConfig;
import io.kotest.assertions.DiffLargeStringKt;
import io.kotest.assertions.Expected;
import io.kotest.assertions.FailuresKt;
import io.kotest.assertions.eq.Eq;
import io.kotest.assertions.eq.StringEqKt;
import io.kotest.assertions.show.Printed;
import io.kotest.assertions.show.ShowKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0002H\u0002J\u001a\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0018\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0002\u00a8\u0006\f"}, d2={"Lio/kotest/assertions/eq/StringEq;", "Lio/kotest/assertions/eq/Eq;", "", "()V", "diff", "", "expected", "actual", "equalIgnoringWhitespace", "", "equals", "useDiff", "kotest-assertions-shared"})
public final class StringEq
implements Eq<String> {
    public static final StringEq INSTANCE;

    @Override
    @Nullable
    public Throwable equals(@NotNull String actual, @NotNull String expected) {
        Intrinsics.checkParameterIsNotNull((Object)actual, (String)"actual");
        Intrinsics.checkParameterIsNotNull((Object)expected, (String)"expected");
        return Intrinsics.areEqual((Object)actual, (Object)expected) ? null : (this.equalIgnoringWhitespace(actual, expected) ? (Throwable)((Object)FailuresKt.failure("expected: " + StringEqKt.escapeLineBreaks(expected) + " but was: " + StringEqKt.escapeLineBreaks(actual) + "\n(contents match, but line-breaks differ; output has been escaped to show line-breaks)")) : (this.useDiff(expected, actual) ? this.diff(expected, actual) : FailuresKt.failure$default(new Expected(ShowKt.show(expected)), new Actual(ShowKt.show(actual)), null, 4, null)));
    }

    private final boolean equalIgnoringWhitespace(String actual, String expected) {
        String a = StringEqKt.access$getLinebreaks$p().replace((CharSequence)expected, "");
        String b = StringEqKt.access$getLinebreaks$p().replace((CharSequence)actual, "");
        return Intrinsics.areEqual((Object)a, (Object)b);
    }

    private final Throwable diff(String expected, String actual) {
        Pair<String, String> result = DiffLargeStringKt.diffLargeString(expected, actual);
        return result == null ? FailuresKt.failure$default(new Expected(ShowKt.show(expected)), new Actual(ShowKt.show(actual)), null, 4, null) : FailuresKt.failure$default(new Expected(new Printed((String)result.getFirst())), new Actual(new Printed((String)result.getSecond())), null, 4, null);
    }

    private final boolean useDiff(String expected, String actual) {
        int minSizeForDiff = AssertionsConfig.INSTANCE.getLargeStringDiffMinSize();
        return StringsKt.lines((CharSequence)expected).size() >= minSizeForDiff && StringsKt.lines((CharSequence)actual).size() >= minSizeForDiff && Intrinsics.areEqual((Object)AssertionsConfig.INSTANCE.getMultiLineDiff(), (Object)"simple") ^ true;
    }

    private StringEq() {
    }

    static {
        StringEq stringEq;
        INSTANCE = stringEq = new StringEq();
    }
}

