/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.assertions.eq;

import io.kotest.assertions.AssertionsConfig;
import io.kotest.assertions.eq.DataClassEq;
import io.kotest.assertions.eq.DataClassEqKt;
import io.kotest.assertions.eq.DefaultEq;
import io.kotest.assertions.eq.MapEq;
import io.kotest.assertions.eq.NumberEq;
import io.kotest.assertions.eq.RegexEq;
import io.kotest.assertions.eq.StringEq;
import io.kotest.assertions.eq.ThrowableEq;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.text.Regex;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u0012\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a#\u0010\u0000\u001a\u0004\u0018\u00010\u0001\"\u0004\b\u0000\u0010\u00022\u0006\u0010\u0003\u001a\u0002H\u00022\u0006\u0010\u0004\u001a\u0002H\u0002\u00a2\u0006\u0002\u0010\u0005\u001a#\u0010\u0006\u001a\u00020\u0007\"\u0004\b\u0000\u0010\u00022\u0006\u0010\u0003\u001a\u0002H\u00022\u0006\u0010\u0004\u001a\u0002H\u0002H\u0002\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"eq", "", "T", "actual", "expected", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Throwable;", "shouldShowDataClassDiff", "", "(Ljava/lang/Object;Ljava/lang/Object;)Z", "kotest-assertions-shared"})
public final class EqKt {
    @Nullable
    public static final <T> Throwable eq(T actual, T expected) {
        Throwable throwable;
        if (actual instanceof Map && expected instanceof Map) {
            throwable = MapEq.INSTANCE.equals((Map)actual, (Map)expected);
        } else if (actual instanceof Throwable && expected instanceof Throwable) {
            throwable = ThrowableEq.INSTANCE.equals((Throwable)actual, (Throwable)expected);
        } else if (actual instanceof Regex && expected instanceof Regex) {
            throwable = RegexEq.INSTANCE.equals((Regex)actual, (Regex)expected);
        } else if (actual instanceof String && expected instanceof String) {
            throwable = StringEq.INSTANCE.equals((String)actual, (String)expected);
        } else if (actual instanceof Number && expected instanceof Number) {
            throwable = NumberEq.INSTANCE.equals((Number)actual, (Number)expected);
        } else if (EqKt.shouldShowDataClassDiff(actual, expected)) {
            T t = actual;
            if (t == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Any");
            }
            T t2 = expected;
            if (t2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Any");
            }
            throwable = DataClassEq.INSTANCE.equals((Object)t, (Object)t2);
        } else {
            T t = actual;
            if (t == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Any");
            }
            T t3 = expected;
            if (t3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Any");
            }
            throwable = DefaultEq.INSTANCE.equals((Object)t, (Object)t3);
        }
        return throwable;
    }

    private static final <T> boolean shouldShowDataClassDiff(T actual, T expected) {
        return AssertionsConfig.INSTANCE.getShowDataClassDiff() && DataClassEqKt.isDataClassInstance(actual) && DataClassEqKt.isDataClassInstance(expected);
    }
}

