/*
 * Decompiled with CFR 0.152.
 */
package kamon.datadog;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ExtendedActorSystem;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import com.typesafe.config.Config;
import java.net.InetSocketAddress;
import kamon.Kamon;
import kamon.Kamon$;
import kamon.datadog.DatadogExtension$;
import kamon.datadog.DatadogMetricsSender$;
import kamon.metric.MetricScaleDecorator$;
import kamon.metric.TickMetricSnapshotBuffer$;
import kamon.util.ConfigTools;
import kamon.util.ConfigTools$;
import kamon.util.NeedToScale$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001}4A!\u0001\u0002\u0001\u000f\t\u0001B)\u0019;bI><W\t\u001f;f]NLwN\u001c\u0006\u0003\u0007\u0011\tq\u0001Z1uC\u0012|wMC\u0001\u0006\u0003\u0015Y\u0017-\\8o\u0007\u0001\u00192\u0001\u0001\u0005\u000f!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fMB\u0011qb\u0005\b\u0003!Ei\u0011\u0001B\u0005\u0003%\u0011\tQaS1n_:L!\u0001F\u000b\u0003\u0013\u0015CH/\u001a8tS>t'B\u0001\n\u0005\u0011!9\u0002A!A!\u0002\u0013A\u0012AB:zgR,W\u000e\u0005\u0002\u001a=5\t!D\u0003\u0002\u001c9\u0005)\u0011m\u0019;pe*\tQ$\u0001\u0003bW.\f\u0017BA\u0010\u001b\u0005M)\u0005\u0010^3oI\u0016$\u0017i\u0019;peNK8\u000f^3n\u0011\u0015\t\u0003\u0001\"\u0001#\u0003\u0019a\u0014N\\5u}Q\u00111%\n\t\u0003I\u0001i\u0011A\u0001\u0005\u0006/\u0001\u0002\r\u0001\u0007\u0005\bO\u0001\u0011\r\u0011b\u0001)\u0003\t\t7/F\u0001\u0019\u0011\u0019Q\u0003\u0001)A\u00051\u0005\u0019\u0011m\u001d\u0011\t\u000f1\u0002!\u0019!C\u0001[\u0005\u0019An\\4\u0016\u00039\u0002\"a\f\u001a\u000e\u0003AR!!\r\u000f\u0002\u000b\u00154XM\u001c;\n\u0005M\u0002$A\u0004'pO\u001eLgnZ!eCB$XM\u001d\u0005\u0007k\u0001\u0001\u000b\u0011\u0002\u0018\u0002\t1|w\r\t\u0005\bo\u0001\u0011\r\u0011\"\u00039\u00035!\u0017\r^1e_\u001e\u001cuN\u001c4jOV\t\u0011\b\u0005\u0002;\u00036\t1H\u0003\u0002={\u000511m\u001c8gS\u001eT!AP \u0002\u0011QL\b/Z:bM\u0016T\u0011\u0001Q\u0001\u0004G>l\u0017B\u0001\"<\u0005\u0019\u0019uN\u001c4jO\"1A\t\u0001Q\u0001\ne\na\u0002Z1uC\u0012|wmQ8oM&<\u0007\u0005C\u0004G\u0001\t\u0007I\u0011A$\u0002\u0017\u0011\fG/\u00193pO\"{7\u000f^\u000b\u0002\u0011B\u0011\u0011JT\u0007\u0002\u0015*\u00111\nT\u0001\u0004]\u0016$(\"A'\u0002\t)\fg/Y\u0005\u0003\u001f*\u0013\u0011#\u00138fiN{7m[3u\u0003\u0012$'/Z:t\u0011\u0019\t\u0006\u0001)A\u0005\u0011\u0006aA-\u0019;bI><\u0007j\\:uA!91\u000b\u0001b\u0001\n\u0003!\u0016!\u00044mkND\u0017J\u001c;feZ\fG.F\u0001V!\t16,D\u0001X\u0015\tA\u0016,\u0001\u0005ekJ\fG/[8o\u0015\tQ&\"\u0001\u0006d_:\u001cWO\u001d:f]RL!\u0001X,\u0003\u001d\u0019Kg.\u001b;f\tV\u0014\u0018\r^5p]\"1a\f\u0001Q\u0001\nU\u000baB\u001a7vg\"Le\u000e^3sm\u0006d\u0007\u0005C\u0004a\u0001\t\u0007I\u0011A1\u0002)5\f\u0007\u0010U1dW\u0016$8+\u001b>f\u0013:\u0014\u0015\u0010^3t+\u0005\u0011\u0007CA2g\u001b\u0005!'BA3M\u0003\u0011a\u0017M\\4\n\u0005\u001d$'\u0001\u0002'p]\u001eDa!\u001b\u0001!\u0002\u0013\u0011\u0017!F7bqB\u000b7m[3u'&TX-\u00138CsR,7\u000f\t\u0005\bW\u0002\u0011\r\u0011\"\u0001U\u00031!\u0018nY6J]R,'O^1m\u0011\u0019i\u0007\u0001)A\u0005+\u0006iA/[2l\u0013:$XM\u001d<bY\u0002Bqa\u001c\u0001C\u0002\u0013\u0005\u0001/\u0001\feCR\fGm\\4NKR\u0014\u0018nY:MSN$XM\\3s+\u0005\t\bCA\rs\u0013\t\u0019(D\u0001\u0005BGR|'OU3g\u0011\u0019)\b\u0001)A\u0005c\u00069B-\u0019;bI><W*\u001a;sS\u000e\u001cH*[:uK:,'\u000f\t\u0005\bo\u0002\u0011\r\u0011\"\u00019\u00035\u0019XOY:de&\u0004H/[8og\"1\u0011\u0010\u0001Q\u0001\ne\nab];cg\u000e\u0014\u0018\u000e\u001d;j_:\u001c\b\u0005C\u0003|\u0001\u0011\u0005A0\u0001\u000bck&dG-T3ue&\u001c7\u000fT5ti\u0016tWM\u001d\u000b\u0004cvt\b\"B6{\u0001\u0004)\u0006\"B*{\u0001\u0004)\u0006")
public class DatadogExtension
implements Kamon.Extension {
    private final ExtendedActorSystem system;
    private final ExtendedActorSystem as;
    private final LoggingAdapter log;
    private final Config datadogConfig;
    private final InetSocketAddress datadogHost;
    private final FiniteDuration flushInterval;
    private final Long maxPacketSizeInBytes;
    private final FiniteDuration tickInterval;
    private final ActorRef datadogMetricsListener;
    private final Config subscriptions;

    public ExtendedActorSystem as() {
        return this.as;
    }

    public LoggingAdapter log() {
        return this.log;
    }

    private Config datadogConfig() {
        return this.datadogConfig;
    }

    public InetSocketAddress datadogHost() {
        return this.datadogHost;
    }

    public FiniteDuration flushInterval() {
        return this.flushInterval;
    }

    public Long maxPacketSizeInBytes() {
        return this.maxPacketSizeInBytes;
    }

    public FiniteDuration tickInterval() {
        return this.tickInterval;
    }

    public ActorRef datadogMetricsListener() {
        return this.datadogMetricsListener;
    }

    public Config subscriptions() {
        return this.subscriptions;
    }

    public ActorRef buildMetricsListener(FiniteDuration tickInterval, FiniteDuration flushInterval) {
        boolean bl = flushInterval.$greater$eq((Object)tickInterval);
        Predef$ predef$ = Predef$.MODULE$;
        if (!bl) {
            throw new AssertionError((Object)new StringBuilder().append((Object)"assertion failed: ").append((Object)"Datadog flush-interval needs to be equal or greater to the tick-interval").toString());
        }
        Long l = this.maxPacketSizeInBytes();
        Predef$ predef$2 = Predef$.MODULE$;
        ActorRef metricsSender = this.system.actorOf(DatadogMetricsSender$.MODULE$.props(this.datadogHost(), l), "datadog-metrics-sender");
        Config config = this.datadogConfig();
        Option option = NeedToScale$.MODULE$.unapply(config);
        ActorRef actorRef = option.isEmpty() ? metricsSender : this.system.actorOf(MetricScaleDecorator$.MODULE$.props((Option)((Tuple2)option.get())._1(), (Option)((Tuple2)option.get())._2(), metricsSender), "datadog-metric-scale-decorator");
        FiniteDuration finiteDuration = flushInterval;
        return !(finiteDuration != null ? !finiteDuration.equals(tickInterval) : tickInterval != null) ? actorRef : this.system.actorOf(TickMetricSnapshotBuffer$.MODULE$.props(flushInterval, actorRef), "datadog-metrics-buffer");
    }

    public DatadogExtension(ExtendedActorSystem system) {
        this.system = system;
        this.as = system;
        this.log = Logging$.MODULE$.apply((ActorSystem)system, DatadogExtension.class, LogSource$.MODULE$.fromAnyClass());
        this.log().info("Starting the Kamon(Datadog) extension");
        this.datadogConfig = system.settings().config().getConfig("kamon.datadog");
        this.datadogHost = new InetSocketAddress(this.datadogConfig().getString("hostname"), this.datadogConfig().getInt("port"));
        this.flushInterval = ConfigTools.Syntax$.MODULE$.getFiniteDuration$extension(ConfigTools$.MODULE$.Syntax(this.datadogConfig()), "flush-interval");
        this.maxPacketSizeInBytes = this.datadogConfig().getBytes("max-packet-size");
        this.tickInterval = Kamon$.MODULE$.metrics().settings().tickInterval();
        this.datadogMetricsListener = this.buildMetricsListener(this.tickInterval(), this.flushInterval());
        this.subscriptions = this.datadogConfig().getConfig("subscriptions");
        ConfigTools.Syntax$.MODULE$.firstLevelKeys$extension(ConfigTools$.MODULE$.Syntax(this.subscriptions())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            public final /* synthetic */ DatadogExtension $outer;

            public final void apply(String subscriptionCategory) {
                ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.$outer.subscriptions().getStringList(subscriptionCategory)).asScala()).foreach((Function1)new Serializable(this, subscriptionCategory){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;
                    private final String subscriptionCategory$1;

                    public final void apply(String pattern) {
                        Kamon$.MODULE$.metrics().subscribe(this.subscriptionCategory$1, pattern, this.$outer.$outer.datadogMetricsListener(), true);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.subscriptionCategory$1 = subscriptionCategory$1;
                    }
                });
            }

            public /* synthetic */ DatadogExtension kamon$datadog$DatadogExtension$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Set$.MODULE$.canBuildFrom());
    }
}

