package io.joynr.generator.util;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.UnmodifiableIterator;
import com.google.inject.Inject;
import io.joynr.generator.templates.util.BroadcastUtil;
import io.joynr.generator.templates.util.InterfaceUtil;
import io.joynr.generator.templates.util.JoynrGeneratorExtensions;
import io.joynr.generator.util.JavaTypeUtil;
import java.util.Iterator;
import java.util.TreeSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.franca.core.franca.FAnnotation;
import org.franca.core.franca.FAnnotationBlock;
import org.franca.core.franca.FAnnotationType;
import org.franca.core.franca.FBroadcast;
import org.franca.core.franca.FCompoundType;
import org.franca.core.franca.FField;
import org.franca.core.franca.FInterface;
import org.franca.core.franca.FModelElement;
import org.franca.core.franca.FType;
import org.franca.core.franca.FTypeDef;
import org.franca.core.franca.FTypeRef;
import org.franca.core.franca.FTypedElement;

@SuppressWarnings("all")
public class JoynrJavaGeneratorExtensions extends JoynrGeneratorExtensions {
  @Inject
  @Extension
  private JavaTypeUtil _javaTypeUtil;
  
  @Inject
  @Extension
  private InterfaceUtil _interfaceUtil;
  
  @Inject
  @Extension
  private BroadcastUtil _broadcastUtil;
  
  public String getNamespaceStarter(final FInterface interfaceType) {
    UnmodifiableIterator<String> _packageNames = this.getPackageNames(interfaceType);
    return this.getNamespaceStarter(_packageNames);
  }
  
  public String getNamespaceStarter(final FType datatype) {
    UnmodifiableIterator<String> _packageNames = this.getPackageNames(datatype);
    return this.getNamespaceStarter(_packageNames);
  }
  
  public String getNamespaceEnder(final FInterface interfaceType) {
    UnmodifiableIterator<String> _packageNames = this.getPackageNames(interfaceType);
    return this.getNamespaceEnder(_packageNames);
  }
  
  public String getNamespaceEnder(final FType datatype) {
    UnmodifiableIterator<String> _packageNames = this.getPackageNames(datatype);
    return this.getNamespaceEnder(_packageNames);
  }
  
  private String getNamespaceStarter(final Iterator<String> packageList) {
    return this.getNamespaceStarterFromPackageList(packageList);
  }
  
  public String getNamespaceStarterFromPackageList(final Iterator<String> packageList) {
    StringBuilder sb = new StringBuilder();
    while (packageList.hasNext()) {
      String _next = packageList.next();
      String _plus = ("namespace " + _next);
      String _plus_1 = (_plus + "{ ");
      sb.append(_plus_1);
    }
    return sb.toString();
  }
  
  private String getNamespaceEnder(final Iterator<String> packageList) {
    return this.getNameSpaceEnderFromPackageList(packageList);
  }
  
  public String getNameSpaceEnderFromPackageList(final Iterator<String> packageList) {
    StringBuilder sb = new StringBuilder();
    while (packageList.hasNext()) {
      String _next = packageList.next();
      String _plus = ("} /* namespace " + _next);
      String _plus_1 = (_plus + " */ ");
      sb.insert(0, _plus_1);
    }
    return sb.toString();
  }
  
  public Iterable<String> getRequiredIncludesFor(final FCompoundType datatype) {
    return this.getRequiredIncludesFor(datatype, true);
  }
  
  public Iterable<String> getRequiredIncludesFor(final FCompoundType datatype, final boolean includingExendedType) {
    final Iterable<FField> members = this._javaTypeUtil.getComplexMembers(datatype);
    final TreeSet<String> typeList = new TreeSet<String>();
    boolean _hasExtendsDeclaration = this._javaTypeUtil.hasExtendsDeclaration(datatype);
    if (_hasExtendsDeclaration) {
      if (includingExendedType) {
        FCompoundType _extendedType = this._javaTypeUtil.getExtendedType(datatype);
        String _includeOf = this.getIncludeOf(_extendedType);
        typeList.add(_includeOf);
      }
      FCompoundType _extendedType_1 = this._javaTypeUtil.getExtendedType(datatype);
      Iterable<String> _requiredIncludesFor = this.getRequiredIncludesFor(_extendedType_1, false);
      Iterables.<String>addAll(typeList, _requiredIncludesFor);
    }
    for (final FField member : members) {
      {
        FTypeRef _type = member.getType();
        final Object type = this._javaTypeUtil.getDatatype(_type);
        if ((type instanceof FType)) {
          String _includeOf_1 = this.getIncludeOf(((FType)type));
          typeList.add(_includeOf_1);
        }
      }
    }
    return typeList;
  }
  
  public Iterable<String> getRequiredIncludesFor(final FInterface serviceInterface) {
    return this.getRequiredIncludesFor(serviceInterface, true, true, true, true, true);
  }
  
  public Iterable<String> getRequiredIncludesFor(final FInterface serviceInterface, final boolean methods, final boolean readAttributes, final boolean writeAttributes, final boolean notifyAttributes, final boolean broadcasts) {
    final TreeSet<String> includeSet = new TreeSet<String>();
    final InterfaceUtil.TypeSelector selector = InterfaceUtil.TypeSelector.defaultTypeSelector();
    selector.methods(methods);
    selector.readAttributes(readAttributes);
    selector.writeAttributes(writeAttributes);
    selector.notifyAttributes(notifyAttributes);
    selector.broadcasts(broadcasts);
    Iterable<FType> _allComplexTypes = this._interfaceUtil.getAllComplexTypes(serviceInterface, selector);
    for (final FType datatype : _allComplexTypes) {
      if ((datatype instanceof FType)) {
        final String include = this.getIncludeOf(datatype);
        boolean _notEquals = (!Objects.equal(include, null));
        if (_notEquals) {
          includeSet.add(include);
        }
      }
    }
    return includeSet;
  }
  
  public Iterable<String> getRequiredIncludesFor(final FBroadcast broadcast) {
    final TreeSet<String> includeSet = new TreeSet<String>();
    Iterable<FType> _allComplexTypes = this._broadcastUtil.getAllComplexTypes(broadcast);
    for (final FType datatype : _allComplexTypes) {
      if ((datatype instanceof FType)) {
        String _includeOf = this.getIncludeOf(datatype);
        includeSet.add(_includeOf);
      }
    }
    return includeSet;
  }
  
  public String ReformatComment(final FAnnotation comment, final String prefixForNewLines) {
    String _comment = comment.getComment();
    String _replaceAll = _comment.replaceAll("\\s+", " ");
    return _replaceAll.replaceAll("\n", ("\n" + prefixForNewLines));
  }
  
  public CharSequence appendJavadocSummaryAndWriteSeeAndDescription(final FModelElement element, final String prefixForNewLines) {
    StringConcatenation _builder = new StringConcatenation();
    {
      FAnnotationBlock _comment = element.getComment();
      boolean _notEquals = (!Objects.equal(_comment, null));
      if (_notEquals) {
        {
          FAnnotationBlock _comment_1 = element.getComment();
          EList<FAnnotation> _elements = _comment_1.getElements();
          for(final FAnnotation comment : _elements) {
            {
              FAnnotationType _type = comment.getType();
              boolean _equals = Objects.equal(_type, FAnnotationType.DESCRIPTION);
              if (_equals) {
                _builder.append(prefixForNewLines, "");
                _builder.append(" ");
                String _ReformatComment = this.ReformatComment(comment, prefixForNewLines);
                _builder.append(_ReformatComment, "");
                _builder.newLineIfNotEmpty();
              }
            }
          }
        }
        {
          FAnnotationBlock _comment_2 = element.getComment();
          EList<FAnnotation> _elements_1 = _comment_2.getElements();
          for(final FAnnotation comment_1 : _elements_1) {
            {
              FAnnotationType _type_1 = comment_1.getType();
              boolean _equals_1 = Objects.equal(_type_1, FAnnotationType.SEE);
              if (_equals_1) {
                _builder.append(prefixForNewLines, "");
                _builder.append(" @see ");
                String _ReformatComment_1 = this.ReformatComment(comment_1, prefixForNewLines);
                _builder.append(_ReformatComment_1, "");
                _builder.newLineIfNotEmpty();
              }
            }
            {
              FAnnotationType _type_2 = comment_1.getType();
              boolean _equals_2 = Objects.equal(_type_2, FAnnotationType.DETAILS);
              if (_equals_2) {
                _builder.append(prefixForNewLines, "");
                _builder.newLineIfNotEmpty();
                _builder.append(prefixForNewLines, "");
                _builder.append(" ");
                String _ReformatComment_2 = this.ReformatComment(comment_1, prefixForNewLines);
                _builder.append(_ReformatComment_2, "");
                _builder.newLineIfNotEmpty();
              }
            }
          }
        }
      }
    }
    return _builder;
  }
  
  public CharSequence appendJavadocComment(final FModelElement element, final String prefixForNewLines) {
    StringConcatenation _builder = new StringConcatenation();
    {
      FAnnotationBlock _comment = element.getComment();
      boolean _notEquals = (!Objects.equal(_comment, null));
      if (_notEquals) {
        {
          FAnnotationBlock _comment_1 = element.getComment();
          EList<FAnnotation> _elements = _comment_1.getElements();
          for(final FAnnotation comment : _elements) {
            {
              FAnnotationType _type = comment.getType();
              boolean _equals = Objects.equal(_type, FAnnotationType.DESCRIPTION);
              if (_equals) {
                String _ReformatComment = this.ReformatComment(comment, prefixForNewLines);
                _builder.append(_ReformatComment, "");
                _builder.newLineIfNotEmpty();
              }
            }
          }
        }
      }
    }
    return _builder;
  }
  
  public String appendJavadocParameter(final FTypedElement element, final String prefixForNewLines) {
    String _joynrName = this._namingUtil.joynrName(element);
    String _plus = ((prefixForNewLines + " @param ") + _joynrName);
    String description = (_plus + " ");
    FAnnotationBlock _comment = element.getComment();
    boolean _notEquals = (!Objects.equal(_comment, null));
    if (_notEquals) {
      FAnnotationBlock _comment_1 = element.getComment();
      EList<FAnnotation> _elements = _comment_1.getElements();
      for (final FAnnotation comment : _elements) {
        FAnnotationType _type = comment.getType();
        boolean _equals = Objects.equal(_type, FAnnotationType.DESCRIPTION);
        if (_equals) {
          String _description = description;
          String _ReformatComment = this.ReformatComment(comment, prefixForNewLines);
          description = (_description + _ReformatComment);
        }
      }
    } else {
      String _description_1 = description;
      description = (_description_1 + "description missing in Franca model.");
    }
    FTypeRef _type_1 = element.getType();
    boolean _isTypeDef = this._javaTypeUtil.isTypeDef(_type_1);
    if (_isTypeDef) {
      String _description_2 = description;
      FTypeRef _type_2 = element.getType();
      String _joynrName_1 = this._namingUtil.joynrName(_type_2);
      String _plus_1 = ((("\n" + prefixForNewLines) + 
        " (type resolved from modeled Franca typedef ") + _joynrName_1);
      String _plus_2 = (_plus_1 + 
        " as ");
      FTypeRef _type_3 = element.getType();
      FTypeDef _typeDefType = this._javaTypeUtil.getTypeDefType(_type_3);
      FTypeRef _actualType = _typeDefType.getActualType();
      String _typeName = this._javaTypeUtil.getTypeName(_actualType);
      String _plus_3 = (_plus_2 + _typeName);
      String _plus_4 = (_plus_3 + 
        ")");
      description = (_description_2 + _plus_4);
    }
    return description;
  }
  
  public String getIncludeOf(final FType dataType) {
    String _buildPackagePath = this.buildPackagePath(dataType, ".", true);
    String _plus = (_buildPackagePath + ".");
    String _joynrName = this._namingUtil.joynrName(dataType);
    return (_plus + _joynrName);
  }
  
  @Override
  public String getOneLineWarning() {
    return "/* Generated Code */  ";
  }
  
  public boolean hasArrayMembers(final FCompoundType datatype) {
    EList<FField> _members = this._javaTypeUtil.getMembers(datatype);
    for (final FField member : _members) {
      boolean _isArray = this._javaTypeUtil.isArray(member);
      if (_isArray) {
        return true;
      }
    }
    return false;
  }
  
  public String getJoynTypePackagePrefix() {
    return this.getJoynrGenerationPrefix();
  }
}
