package io.joynr.generator.util;

import com.google.inject.Inject;
import io.joynr.generator.templates.util.AbstractTypeUtil;
import io.joynr.generator.templates.util.BroadcastUtil;
import io.joynr.generator.templates.util.MethodUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.franca.core.franca.FArgument;
import org.franca.core.franca.FBasicTypeId;
import org.franca.core.franca.FBroadcast;
import org.franca.core.franca.FCompoundType;
import org.franca.core.franca.FEnumerationType;
import org.franca.core.franca.FEnumerator;
import org.franca.core.franca.FMethod;
import org.franca.core.franca.FType;
import org.franca.core.franca.FTypeDef;
import org.franca.core.franca.FTypeRef;
import org.franca.core.franca.FTypedElement;

@SuppressWarnings("all")
public class JavaTypeUtil extends AbstractTypeUtil {
  @Inject
  @Extension
  private MethodUtil _methodUtil;
  
  @Inject
  @Extension
  private BroadcastUtil _broadcastUtil;
  
  private Map<FBasicTypeId, String> primitiveDataTypeDefaultMap;
  
  public JavaTypeUtil() {
    final Map<FBasicTypeId, String> primitiveDataTypeDefaultValue = new HashMap<FBasicTypeId, String>();
    primitiveDataTypeDefaultValue.put(FBasicTypeId.BOOLEAN, "false");
    primitiveDataTypeDefaultValue.put(FBasicTypeId.INT8, "0");
    primitiveDataTypeDefaultValue.put(FBasicTypeId.UINT8, "0");
    primitiveDataTypeDefaultValue.put(FBasicTypeId.INT16, "0");
    primitiveDataTypeDefaultValue.put(FBasicTypeId.UINT16, "0");
    primitiveDataTypeDefaultValue.put(FBasicTypeId.INT32, "0");
    primitiveDataTypeDefaultValue.put(FBasicTypeId.UINT32, "0");
    primitiveDataTypeDefaultValue.put(FBasicTypeId.INT64, "0L");
    primitiveDataTypeDefaultValue.put(FBasicTypeId.UINT64, "0l");
    primitiveDataTypeDefaultValue.put(FBasicTypeId.FLOAT, "0f");
    primitiveDataTypeDefaultValue.put(FBasicTypeId.DOUBLE, "0d");
    primitiveDataTypeDefaultValue.put(FBasicTypeId.STRING, "\"\"");
    primitiveDataTypeDefaultValue.put(FBasicTypeId.BYTE_BUFFER, "new Byte[0]");
    primitiveDataTypeDefaultValue.put(FBasicTypeId.UNDEFINED, "");
    Map<FBasicTypeId, String> _unmodifiableMap = Collections.<FBasicTypeId, String>unmodifiableMap(primitiveDataTypeDefaultValue);
    this.primitiveDataTypeDefaultMap = _unmodifiableMap;
  }
  
  public String getCommaSeperatedTypedOutputParameterList(final Iterable<FArgument> arguments, final boolean linebreak) {
    final StringBuilder returnStringBuilder = new StringBuilder();
    for (final FArgument argument : arguments) {
      {
        String _typeName = this.getTypeName(argument);
        returnStringBuilder.append(_typeName);
        returnStringBuilder.append(" ");
        String _joynrName = this._namingUtil.joynrName(argument);
        returnStringBuilder.append(_joynrName);
        returnStringBuilder.append(",");
        if (linebreak) {
          returnStringBuilder.append("\n");
        } else {
          returnStringBuilder.append(" ");
        }
      }
    }
    final String returnString = returnStringBuilder.toString();
    int _length = returnString.length();
    boolean _equals = (_length == 0);
    if (_equals) {
      return "";
    } else {
      int _length_1 = returnString.length();
      int _minus = (_length_1 - 2);
      return returnString.substring(0, _minus);
    }
  }
  
  public String getCommaSeperatedTypedOutputParameterList(final FMethod method) {
    Iterable<FArgument> _outputParameters = this._methodUtil.getOutputParameters(method);
    return this.getCommaSeperatedTypedOutputParameterList(_outputParameters, false);
  }
  
  public String getCommaSeperatedTypedOutputParameterList(final FBroadcast broadcast) {
    Iterable<FArgument> _outputParameters = this._broadcastUtil.getOutputParameters(broadcast);
    return this.getCommaSeperatedTypedOutputParameterList(_outputParameters, false);
  }
  
  public String getCommaSeperatedTypedOutputParameterListLinebreak(final FBroadcast broadcast) {
    Iterable<FArgument> _outputParameters = this._broadcastUtil.getOutputParameters(broadcast);
    return this.getCommaSeperatedTypedOutputParameterList(_outputParameters, true);
  }
  
  public String getCommaSeperatedUntypedInputParameterList(final FMethod method) {
    Iterable<FArgument> _inputParameters = this._methodUtil.getInputParameters(method);
    return this.getCommaSeperatedUntypedParameterList(_inputParameters);
  }
  
  public String getCommaSeperatedUntypedOutputParameterList(final FMethod method) {
    Iterable<FArgument> _outputParameters = this._methodUtil.getOutputParameters(method);
    return this.getCommaSeperatedUntypedParameterList(_outputParameters);
  }
  
  public String getCommaSeperatedUntypedOutputParameterList(final FBroadcast broadcast) {
    Iterable<FArgument> _outputParameters = this._broadcastUtil.getOutputParameters(broadcast);
    return this.getCommaSeperatedUntypedParameterList(_outputParameters);
  }
  
  public String getCommaSeperatedUntypedParameterList(final Iterable<FArgument> arguments) {
    final StringBuilder returnStringBuilder = new StringBuilder();
    for (final FArgument argument : arguments) {
      {
        String _joynrName = this._namingUtil.joynrName(argument);
        returnStringBuilder.append(_joynrName);
        returnStringBuilder.append(", ");
      }
    }
    final String returnString = returnStringBuilder.toString();
    int _length = returnString.length();
    boolean _equals = (_length == 0);
    if (_equals) {
      return "";
    }
    int _length_1 = returnString.length();
    int _minus = (_length_1 - 2);
    return returnString.substring(0, _minus);
  }
  
  public String getCommaSeperatedTypedParameterList(final FMethod method) {
    final StringBuilder returnStringBuilder = new StringBuilder();
    Iterable<FArgument> _inputParameters = this._methodUtil.getInputParameters(method);
    for (final FArgument param : _inputParameters) {
      {
        String _typeName = this.getTypeName(param);
        returnStringBuilder.append(_typeName);
        returnStringBuilder.append(" ");
        String _joynrName = this._namingUtil.joynrName(param);
        returnStringBuilder.append(_joynrName);
        returnStringBuilder.append(", ");
      }
    }
    final String returnString = returnStringBuilder.toString();
    int _length = returnString.length();
    boolean _equals = (_length == 0);
    if (_equals) {
      return "";
    } else {
      int _length_1 = returnString.length();
      int _minus = (_length_1 - 2);
      return returnString.substring(0, _minus);
    }
  }
  
  public String getCommaSeperatedTypedFilterParameterList(final FBroadcast broadcast) {
    final StringBuilder returnStringBuilder = new StringBuilder();
    ArrayList<String> _filterParameters = this._broadcastUtil.getFilterParameters(broadcast);
    for (final String filterParameter : _filterParameters) {
      {
        returnStringBuilder.append("String ");
        returnStringBuilder.append(filterParameter);
        returnStringBuilder.append(", ");
      }
    }
    final String returnString = returnStringBuilder.toString();
    int _length = returnString.length();
    boolean _equals = (_length == 0);
    if (_equals) {
      return "";
    } else {
      int _length_1 = returnString.length();
      int _minus = (_length_1 - 2);
      return returnString.substring(0, _minus);
    }
  }
  
  @Override
  public String getTypeName(final FBasicTypeId datatype) {
    String _switchResult = null;
    if (datatype != null) {
      switch (datatype) {
        case BOOLEAN:
          _switchResult = "Boolean";
          break;
        case INT8:
          _switchResult = "Byte";
          break;
        case UINT8:
          _switchResult = "Byte";
          break;
        case INT16:
          _switchResult = "Short";
          break;
        case UINT16:
          _switchResult = "Short";
          break;
        case INT32:
          _switchResult = "Integer";
          break;
        case UINT32:
          _switchResult = "Integer";
          break;
        case INT64:
          _switchResult = "Long";
          break;
        case UINT64:
          _switchResult = "Long";
          break;
        case FLOAT:
          _switchResult = "Float";
          break;
        case DOUBLE:
          _switchResult = "Double";
          break;
        case STRING:
          _switchResult = "String";
          break;
        case BYTE_BUFFER:
          _switchResult = "Byte[]";
          break;
        default:
          String _joynrName = this._namingUtil.joynrName(datatype);
          String _plus = ("Unsupported basic type: " + _joynrName);
          throw new IllegalArgumentException(_plus);
      }
    } else {
      String _joynrName = this._namingUtil.joynrName(datatype);
      String _plus = ("Unsupported basic type: " + _joynrName);
      throw new IllegalArgumentException(_plus);
    }
    return _switchResult;
  }
  
  @Override
  public String getTypeName(final FType datatype) {
    String _xifexpression = null;
    boolean _isTypeDef = this.isTypeDef(datatype);
    if (_isTypeDef) {
      FTypeDef _typeDefType = this.getTypeDefType(datatype);
      FTypeRef _actualType = _typeDefType.getActualType();
      _xifexpression = this._namingUtil.joynrName(_actualType);
    } else {
      _xifexpression = this._namingUtil.joynrName(datatype);
    }
    return _xifexpression;
  }
  
  @Override
  public String getTypeNameForList(final FBasicTypeId datatype) {
    String _typeName = this.getTypeName(datatype);
    String _objectDataTypeForPlainType = this.getObjectDataTypeForPlainType(_typeName);
    return (_objectDataTypeForPlainType + "[]");
  }
  
  @Override
  public String getTypeNameForList(final FType datatype) {
    String _typeName = this.getTypeName(datatype);
    String _objectDataTypeForPlainType = this.getObjectDataTypeForPlainType(_typeName);
    return (_objectDataTypeForPlainType + "[]");
  }
  
  public String getTypedParameterListJavaRpc(final FMethod method) {
    StringBuilder sb = new StringBuilder();
    final Iterable<FArgument> params = this._methodUtil.getInputParameters(method);
    int i = 0;
    while ((i < IterableExtensions.size(params))) {
      {
        final FArgument param = ((FArgument[])Conversions.unwrapArray(params, FArgument.class))[i];
        sb.append("@JoynrRpcParam");
        String _joynrName = this._namingUtil.joynrName(param);
        String _plus = ("(\"" + _joynrName);
        String _plus_1 = (_plus + "\")");
        sb.append(_plus_1);
        String _typeName = this.getTypeName(param);
        String _plus_2 = (" " + _typeName);
        sb.append(_plus_2);
        String _joynrName_1 = this._namingUtil.joynrName(param);
        String _plus_3 = (" " + _joynrName_1);
        sb.append(_plus_3);
        int _size = IterableExtensions.size(params);
        int _minus = (_size - 1);
        boolean _notEquals = (i != _minus);
        if (_notEquals) {
          sb.append(",\n");
        }
        i = (i + 1);
      }
    }
    return sb.toString();
  }
  
  public String getJavadocCommentsParameterListJavaRpc(final FMethod method) {
    StringBuilder sb = new StringBuilder();
    final Iterable<FArgument> params = this._methodUtil.getInputParameters(method);
    int i = 0;
    while ((i < IterableExtensions.size(params))) {
      {
        final FArgument param = ((FArgument[])Conversions.unwrapArray(params, FArgument.class))[i];
        String _joynrName = this._namingUtil.joynrName(param);
        String _plus = (" * @param " + _joynrName);
        String _plus_1 = (_plus + " the parameter ");
        String _joynrName_1 = this._namingUtil.joynrName(param);
        String _plus_2 = (_plus_1 + _joynrName_1);
        String _plus_3 = (_plus_2 + "\n");
        sb.append(_plus_3);
        i = (i + 1);
      }
    }
    return sb.toString();
  }
  
  public String getTypedParameterListJavaTypeReference(final FMethod method) {
    final StringBuilder sb = new StringBuilder();
    final Iterable<FArgument> params = this._methodUtil.getInputParameters(method);
    for (final FArgument param : params) {
      String _typeName = this.getTypeName(param);
      String _plus = ("public static class " + _typeName);
      String _plus_1 = (_plus + "Token extends TypeReference<");
      String _typeName_1 = this.getTypeName(param);
      String _plus_2 = (_plus_1 + _typeName_1);
      String _plus_3 = (_plus_2 + " > {}\n");
      sb.append(_plus_3);
    }
    ArrayList<String> _typeNamesForOutputParameter = this.getTypeNamesForOutputParameter(method);
    String _plus_4 = ("public static class " + _typeNamesForOutputParameter);
    String _plus_5 = (_plus_4 + "Token extends TypeReference<");
    ArrayList<String> _typeNamesForOutputParameter_1 = this.getTypeNamesForOutputParameter(method);
    String _plus_6 = (_plus_5 + _typeNamesForOutputParameter_1);
    String _plus_7 = (_plus_6 + " > {}\n");
    sb.append(_plus_7);
    int _length = sb.length();
    boolean _equals = (_length == 0);
    if (_equals) {
      return "";
    }
    return sb.toString();
  }
  
  public String getDefaultValue(final FTypedElement element) {
    boolean _isArray = this.isArray(element);
    if (_isArray) {
      return "{}";
    }
    FTypeRef _type = element.getType();
    return this.getDefaultValue(_type);
  }
  
  public String getDefaultValue(final FTypeRef typeRef) {
    boolean _isMap = this.isMap(typeRef);
    if (_isMap) {
      String _joynrName = this._namingUtil.joynrName(typeRef);
      String _plus = ("new " + _joynrName);
      return (_plus + "()");
    }
    boolean _isTypeDef = this.isTypeDef(typeRef);
    if (_isTypeDef) {
      FTypeDef _typeDefType = this.getTypeDefType(typeRef);
      FTypeRef _actualType = _typeDefType.getActualType();
      return this.getDefaultValue(_actualType);
    }
    boolean _or = false;
    boolean _isCompound = this.isCompound(typeRef);
    if (_isCompound) {
      _or = true;
    } else {
      boolean _isMap_1 = this.isMap(typeRef);
      _or = _isMap_1;
    }
    if (_or) {
      FCompoundType _compoundType = this.getCompoundType(typeRef);
      String _joynrName_1 = this._namingUtil.joynrName(_compoundType);
      String _plus_1 = ("new " + _joynrName_1);
      return (_plus_1 + "()");
    } else {
      boolean _isEnum = this.isEnum(typeRef);
      if (_isEnum) {
        FEnumerationType _enumType = this.getEnumType(typeRef);
        String _joynrName_2 = this._namingUtil.joynrName(_enumType);
        String _plus_2 = (_joynrName_2 + ".");
        FEnumerationType _enumType_1 = this.getEnumType(typeRef);
        EList<FEnumerator> _enumerators = _enumType_1.getEnumerators();
        FEnumerator _get = _enumerators.get(0);
        String _joynrName_3 = this._namingUtil.joynrName(_get);
        return (_plus_2 + _joynrName_3);
      } else {
        FBasicTypeId _predefined = typeRef.getPredefined();
        boolean _containsKey = this.primitiveDataTypeDefaultMap.containsKey(_predefined);
        boolean _not = (!_containsKey);
        if (_not) {
          return "NaN";
        } else {
          boolean _isPrimitive = this.isPrimitive(typeRef);
          if (_isPrimitive) {
            FBasicTypeId _predefined_1 = typeRef.getPredefined();
            return this.primitiveDataTypeDefaultMap.get(_predefined_1);
          }
        }
      }
    }
    return null;
  }
}
