package io.joynr.generator.proxy;

import com.google.inject.Inject;
import io.joynr.generator.proxy.InterfaceProxyTemplate;
import io.joynr.generator.templates.util.NamingUtil;
import io.joynr.generator.util.JoynrJavaGeneratorExtensions;
import java.io.File;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.xbase.lib.Extension;
import org.franca.core.franca.FInterface;

@SuppressWarnings("all")
public class ProxyGenerator {
  @Inject
  @Extension
  private JoynrJavaGeneratorExtensions _joynrJavaGeneratorExtensions;
  
  @Inject
  @Extension
  private NamingUtil _namingUtil;
  
  @Inject
  private InterfaceProxyTemplate interfaceProxy;
  
  public void doGenerate(final FInterface fInterface, final IFileSystemAccess fsa) {
    String _packagePathWithJoynrPrefix = this._joynrJavaGeneratorExtensions.getPackagePathWithJoynrPrefix(fInterface, File.separator);
    final String path = (_packagePathWithJoynrPrefix + File.separator);
    String serviceName = this._namingUtil.joynrName(fInterface);
    this._joynrJavaGeneratorExtensions.generateFile(fsa, 
      ((path + serviceName) + "Proxy.java"), 
      this.interfaceProxy, fInterface);
  }
}
