package io.joynr.generator.proxy;

import com.google.inject.Inject;
import io.joynr.generator.templates.InterfaceTemplate;
import io.joynr.generator.templates.util.NamingUtil;
import io.joynr.generator.util.JoynrJavaGeneratorExtensions;
import io.joynr.generator.util.TemplateBase;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.franca.core.franca.FAttribute;
import org.franca.core.franca.FBroadcast;
import org.franca.core.franca.FInterface;

@SuppressWarnings("all")
public class InterfaceProxyTemplate implements InterfaceTemplate {
  @Inject
  @Extension
  private JoynrJavaGeneratorExtensions _joynrJavaGeneratorExtensions;
  
  @Inject
  @Extension
  private NamingUtil _namingUtil;
  
  @Inject
  @Extension
  private TemplateBase _templateBase;
  
  @Override
  public CharSequence generate(final FInterface fInterface) {
    CharSequence _xblockexpression = null;
    {
      final String interfaceName = this._namingUtil.joynrName(fInterface);
      final String className = (interfaceName + "Proxy");
      final String asyncClassName = (interfaceName + "Async");
      final String syncClassName = (interfaceName + "Sync");
      final String subscriptionClassName = (interfaceName + "SubscriptionInterface");
      final String broadcastClassName = (interfaceName + "BroadcastInterface");
      final String packagePath = this._joynrJavaGeneratorExtensions.getPackagePathWithJoynrPrefix(fInterface, ".");
      StringConcatenation _builder = new StringConcatenation();
      _builder.newLine();
      CharSequence _warning = this._templateBase.warning();
      _builder.append(_warning, "");
      _builder.newLineIfNotEmpty();
      _builder.append("package ");
      _builder.append(packagePath, "");
      _builder.append(";");
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _builder.append("public interface ");
      _builder.append(className, "");
      _builder.append(" extends ");
      _builder.append(asyncClassName, "");
      _builder.append(", ");
      _builder.append(syncClassName, "");
      {
        EList<FAttribute> _attributes = fInterface.getAttributes();
        int _size = _attributes.size();
        boolean _greaterThan = (_size > 0);
        if (_greaterThan) {
          _builder.append(", ");
          _builder.append(subscriptionClassName, "");
        }
      }
      {
        EList<FBroadcast> _broadcasts = fInterface.getBroadcasts();
        int _size_1 = _broadcasts.size();
        boolean _greaterThan_1 = (_size_1 > 0);
        if (_greaterThan_1) {
          _builder.append(", ");
          _builder.append(broadcastClassName, "");
        }
      }
      _builder.append(" {");
      _builder.newLineIfNotEmpty();
      _builder.append("    ");
      _builder.append("public static String INTERFACE_NAME = \"");
      String _packagePathWithoutJoynrPrefix = this._joynrJavaGeneratorExtensions.getPackagePathWithoutJoynrPrefix(fInterface, "/");
      _builder.append(_packagePathWithoutJoynrPrefix, "    ");
      _builder.append("/");
      _builder.append(interfaceName, "    ");
      _builder.append("\";");
      _builder.newLineIfNotEmpty();
      _builder.append("}");
      _builder.newLine();
      _xblockexpression = _builder;
    }
    return _xblockexpression;
  }
}
