package io.joynr.generator.provider;

import com.google.inject.Inject;
import io.joynr.generator.provider.DefaultInterfaceProviderTemplate;
import io.joynr.generator.provider.InterfaceAbstractProviderTemplate;
import io.joynr.generator.provider.InterfaceProviderTemplate;
import io.joynr.generator.templates.util.NamingUtil;
import io.joynr.generator.util.JoynrJavaGeneratorExtensions;
import java.io.File;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.xbase.lib.Extension;
import org.franca.core.franca.FInterface;

@SuppressWarnings("all")
public class ProviderGenerator {
  @Inject
  @Extension
  private JoynrJavaGeneratorExtensions _joynrJavaGeneratorExtensions;
  
  @Inject
  @Extension
  private NamingUtil _namingUtil;
  
  @Inject
  private InterfaceProviderTemplate interfaceProvider;
  
  @Inject
  private DefaultInterfaceProviderTemplate defaultInterfaceProvider;
  
  @Inject
  private InterfaceAbstractProviderTemplate interfaceAbstractProvider;
  
  public void doGenerate(final FInterface fInterface, final IFileSystemAccess fsa) {
    String _packagePathWithJoynrPrefix = this._joynrJavaGeneratorExtensions.getPackagePathWithJoynrPrefix(fInterface, File.separator);
    final String path = (_packagePathWithJoynrPrefix + File.separator);
    String serviceName = this._namingUtil.joynrName(fInterface);
    this._joynrJavaGeneratorExtensions.generateFile(fsa, 
      ((path + serviceName) + "Provider.java"), 
      this.interfaceProvider, fInterface);
    this._joynrJavaGeneratorExtensions.generateFile(fsa, 
      (((path + "Default") + serviceName) + "Provider.java"), 
      this.defaultInterfaceProvider, fInterface);
    this._joynrJavaGeneratorExtensions.generateFile(fsa, 
      ((path + serviceName) + "AbstractProvider.java"), 
      this.interfaceAbstractProvider, fInterface);
  }
}
