package io.joynr.generator.provider;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import io.joynr.generator.templates.InterfaceTemplate;
import io.joynr.generator.templates.util.AttributeUtil;
import io.joynr.generator.templates.util.InterfaceUtil;
import io.joynr.generator.templates.util.MethodUtil;
import io.joynr.generator.templates.util.NamingUtil;
import io.joynr.generator.util.JavaTypeUtil;
import io.joynr.generator.util.JoynrJavaGeneratorExtensions;
import io.joynr.generator.util.TemplateBase;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.franca.core.franca.FArgument;
import org.franca.core.franca.FAttribute;
import org.franca.core.franca.FBroadcast;
import org.franca.core.franca.FEnumerationType;
import org.franca.core.franca.FInterface;
import org.franca.core.franca.FMethod;
import org.franca.core.franca.FTypeRef;
import org.franca.core.franca.FTypedElement;

@SuppressWarnings("all")
public class InterfaceProviderTemplate implements InterfaceTemplate {
  @Inject
  @Extension
  private JoynrJavaGeneratorExtensions _joynrJavaGeneratorExtensions;
  
  @Inject
  @Extension
  private JavaTypeUtil _javaTypeUtil;
  
  @Inject
  @Extension
  private InterfaceUtil _interfaceUtil;
  
  @Inject
  @Extension
  private MethodUtil _methodUtil;
  
  @Inject
  @Extension
  private AttributeUtil _attributeUtil;
  
  @Inject
  @Extension
  private NamingUtil _namingUtil;
  
  @Inject
  @Extension
  private TemplateBase _templateBase;
  
  public void init(final FInterface serviceInterface, final HashMap<FMethod, String> methodToDeferredName) {
    ArrayList<FMethod> _arrayList = new ArrayList<FMethod>();
    this.init(serviceInterface, methodToDeferredName, _arrayList);
  }
  
  public void init(final FInterface serviceInterface, final HashMap<FMethod, String> methodToDeferredName, final ArrayList<FMethod> uniqueMethodsToCreateDeferreds) {
    HashMap<String, String> uniqueMethodSignatureToPromiseName = new HashMap<String, String>();
    EList<FMethod> _methods = this._interfaceUtil.getMethods(serviceInterface);
    HashMap<String, Integer> methodNameToCount = this._methodUtil.overloadedMethodCounts(_methods);
    HashMap<String, Integer> methodNameToIndex = new HashMap<String, Integer>();
    EList<FMethod> _methods_1 = this._interfaceUtil.getMethods(serviceInterface);
    for (final FMethod method : _methods_1) {
      boolean _and = false;
      Iterable<FArgument> _outputParameters = this._methodUtil.getOutputParameters(method);
      boolean _isEmpty = IterableExtensions.isEmpty(_outputParameters);
      if (!_isEmpty) {
        _and = false;
      } else {
        boolean _hasErrorEnum = this._methodUtil.hasErrorEnum(method);
        boolean _not = (!_hasErrorEnum);
        _and = _not;
      }
      if (_and) {
        methodToDeferredName.put(method, "DeferredVoid");
      } else {
        String _name = method.getName();
        Integer _get = methodNameToCount.get(_name);
        boolean _equals = ((_get).intValue() == 1);
        if (_equals) {
          String _name_1 = method.getName();
          String _firstUpper = StringExtensions.toFirstUpper(_name_1);
          String _plus = (_firstUpper + "Deferred");
          methodToDeferredName.put(method, _plus);
          uniqueMethodsToCreateDeferreds.add(method);
        } else {
          String _name_2 = method.getName();
          boolean _containsKey = methodNameToIndex.containsKey(_name_2);
          boolean _not_1 = (!_containsKey);
          if (_not_1) {
            String _name_3 = method.getName();
            methodNameToIndex.put(_name_3, Integer.valueOf(0));
          }
          final String methodSignature = this._methodUtil.createMethodSignatureFromOutParameters(method);
          boolean _containsKey_1 = uniqueMethodSignatureToPromiseName.containsKey(methodSignature);
          boolean _not_2 = (!_containsKey_1);
          if (_not_2) {
            String _name_4 = method.getName();
            Integer index = methodNameToIndex.get(_name_4);
            index++;
            String _name_5 = method.getName();
            methodNameToIndex.put(_name_5, index);
            String _name_6 = method.getName();
            String _firstUpper_1 = StringExtensions.toFirstUpper(_name_6);
            String _plus_1 = (_firstUpper_1 + index);
            uniqueMethodSignatureToPromiseName.put(methodSignature, _plus_1);
            uniqueMethodsToCreateDeferreds.add(method);
          }
          String _get_1 = uniqueMethodSignatureToPromiseName.get(methodSignature);
          String _plus_2 = (_get_1 + "Deferred");
          methodToDeferredName.put(method, _plus_2);
        }
      }
    }
  }
  
  @Override
  public CharSequence generate(final FInterface serviceInterface) {
    CharSequence _xblockexpression = null;
    {
      HashMap<FMethod, String> methodToDeferredName = new HashMap<FMethod, String>();
      HashMap<FMethod, String> methodToErrorEnumName = this._interfaceUtil.methodToErrorEnumName(serviceInterface);
      ArrayList<FMethod> uniqueMethodsToCreateDeferreds = new ArrayList<FMethod>();
      this.init(serviceInterface, methodToDeferredName, uniqueMethodsToCreateDeferreds);
      final String interfaceName = this._namingUtil.joynrName(serviceInterface);
      final String className = (interfaceName + "Provider");
      final String packagePath = this._joynrJavaGeneratorExtensions.getPackagePathWithJoynrPrefix(serviceInterface, ".");
      StringConcatenation _builder = new StringConcatenation();
      CharSequence _warning = this._templateBase.warning();
      _builder.append(_warning, "");
      _builder.newLineIfNotEmpty();
      _builder.append("package ");
      _builder.append(packagePath, "");
      _builder.append(";");
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      {
        boolean _or = false;
        EList<FMethod> _methods = this._interfaceUtil.getMethods(serviceInterface);
        int _size = _methods.size();
        boolean _greaterThan = (_size > 0);
        if (_greaterThan) {
          _or = true;
        } else {
          boolean _hasReadAttribute = this._interfaceUtil.hasReadAttribute(serviceInterface);
          _or = _hasReadAttribute;
        }
        if (_or) {
          _builder.append("import io.joynr.provider.Promise;");
          _builder.newLine();
        }
      }
      {
        boolean _hasReadAttribute_1 = this._interfaceUtil.hasReadAttribute(serviceInterface);
        if (_hasReadAttribute_1) {
          _builder.append("import io.joynr.provider.Deferred;");
          _builder.newLine();
        }
      }
      {
        boolean _isEmpty = uniqueMethodsToCreateDeferreds.isEmpty();
        boolean _not = (!_isEmpty);
        if (_not) {
          _builder.append("import io.joynr.provider.AbstractDeferred;");
          _builder.newLine();
        }
      }
      {
        boolean _or_1 = false;
        boolean _hasWriteAttribute = this._interfaceUtil.hasWriteAttribute(serviceInterface);
        if (_hasWriteAttribute) {
          _or_1 = true;
        } else {
          boolean _hasMethodWithArguments = this._interfaceUtil.hasMethodWithArguments(serviceInterface);
          _or_1 = _hasMethodWithArguments;
        }
        if (_or_1) {
          _builder.append("import io.joynr.dispatcher.rpc.annotation.JoynrRpcParam;");
          _builder.newLine();
        }
      }
      {
        boolean _or_2 = false;
        boolean _hasWriteAttribute_1 = this._interfaceUtil.hasWriteAttribute(serviceInterface);
        if (_hasWriteAttribute_1) {
          _or_2 = true;
        } else {
          boolean _hasMethodWithoutReturnValue = this._interfaceUtil.hasMethodWithoutReturnValue(serviceInterface);
          _or_2 = _hasMethodWithoutReturnValue;
        }
        if (_or_2) {
          _builder.append("import io.joynr.provider.DeferredVoid;");
          _builder.newLine();
        }
      }
      {
        boolean _hasMethodWithErrorEnum = this._interfaceUtil.hasMethodWithErrorEnum(serviceInterface);
        if (_hasMethodWithErrorEnum) {
          _builder.append("import joynr.exceptions.ApplicationException;");
          _builder.newLine();
        }
      }
      _builder.newLine();
      _builder.append("import io.joynr.provider.JoynrProvider;");
      _builder.newLine();
      _builder.newLine();
      {
        Iterable<String> _requiredIncludesFor = this._joynrJavaGeneratorExtensions.getRequiredIncludesFor(serviceInterface);
        for(final String datatype : _requiredIncludesFor) {
          _builder.append("import ");
          _builder.append(datatype, "");
          _builder.append(";");
          _builder.newLineIfNotEmpty();
        }
      }
      _builder.newLine();
      _builder.append("public interface ");
      _builder.append(className, "");
      _builder.append(" extends JoynrProvider {");
      _builder.newLineIfNotEmpty();
      _builder.append("\t");
      _builder.append("public static final String INTERFACE_NAME = \"");
      String _packagePathWithoutJoynrPrefix = this._joynrJavaGeneratorExtensions.getPackagePathWithoutJoynrPrefix(serviceInterface, "/");
      _builder.append(_packagePathWithoutJoynrPrefix, "\t");
      _builder.append("/");
      _builder.append(interfaceName, "\t");
      _builder.append("\";");
      _builder.newLineIfNotEmpty();
      {
        EList<FAttribute> _attributes = this._interfaceUtil.getAttributes(serviceInterface);
        for(final FAttribute attribute : _attributes) {
          _builder.append("\t");
          String attributeName = this._namingUtil.joynrName(attribute);
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          String _typeName = this._javaTypeUtil.getTypeName(attribute);
          String attributeType = this._javaTypeUtil.getObjectDataTypeForPlainType(_typeName);
          _builder.newLineIfNotEmpty();
          _builder.newLine();
          {
            boolean _isReadable = this._attributeUtil.isReadable(attribute);
            if (_isReadable) {
              _builder.append("\t");
              _builder.append("Promise<Deferred<");
              _builder.append(attributeType, "\t");
              _builder.append(">> get");
              String _firstUpper = StringExtensions.toFirstUpper(attributeName);
              _builder.append(_firstUpper, "\t");
              _builder.append("();");
              _builder.newLineIfNotEmpty();
            }
          }
          {
            boolean _isWritable = this._attributeUtil.isWritable(attribute);
            if (_isWritable) {
              _builder.append("\t");
              _builder.append("Promise<DeferredVoid> set");
              String _firstUpper_1 = StringExtensions.toFirstUpper(attributeName);
              _builder.append(_firstUpper_1, "\t");
              _builder.append("(");
              _builder.append(attributeType, "\t");
              _builder.append(" ");
              _builder.append(attributeName, "\t");
              _builder.append(");");
              _builder.newLineIfNotEmpty();
            }
          }
          {
            boolean _isNotifiable = this._attributeUtil.isNotifiable(attribute);
            if (_isNotifiable) {
              _builder.append("\t");
              _builder.append("public void ");
              _builder.append(attributeName, "\t");
              _builder.append("Changed(");
              _builder.append(attributeType, "\t");
              _builder.append(" ");
              _builder.append(attributeName, "\t");
              _builder.append(");");
              _builder.newLineIfNotEmpty();
            }
          }
        }
      }
      {
        EList<FMethod> _methods_1 = this._interfaceUtil.getMethods(serviceInterface);
        for(final FMethod method : _methods_1) {
          _builder.append("\t");
          String methodName = this._namingUtil.joynrName(method);
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          String params = this._javaTypeUtil.getTypedParameterListJavaRpc(method);
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          String comments = this._javaTypeUtil.getJavadocCommentsParameterListJavaRpc(method);
          _builder.newLineIfNotEmpty();
          _builder.newLine();
          _builder.append("\t");
          _builder.append("/**");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("* ");
          _builder.append(methodName, "\t ");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          {
            boolean _equals = comments.equals("");
            boolean _not_1 = (!_equals);
            if (_not_1) {
              _builder.append(comments, "\t");
            }
          }
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("* @return promise for asynchronous handling");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("*/");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("public Promise<");
          String _get = methodToDeferredName.get(method);
          _builder.append(_get, "\t");
          _builder.append("> ");
          _builder.append(methodName, "\t");
          _builder.append("(");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("\t\t");
          {
            boolean _equals_1 = params.equals("");
            boolean _not_2 = (!_equals_1);
            if (_not_2) {
              _builder.append(params, "\t\t\t");
            }
          }
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append(");");
          _builder.newLine();
        }
      }
      {
        for(final FMethod method_1 : uniqueMethodsToCreateDeferreds) {
          _builder.newLine();
          _builder.append("\t");
          _builder.append("public class ");
          String _get_1 = methodToDeferredName.get(method_1);
          _builder.append(_get_1, "\t");
          _builder.append(" extends AbstractDeferred {");
          _builder.newLineIfNotEmpty();
          {
            Iterable<FArgument> _outputParameters = this._methodUtil.getOutputParameters(method_1);
            boolean _isEmpty_1 = IterableExtensions.isEmpty(_outputParameters);
            if (_isEmpty_1) {
              _builder.append("\t");
              _builder.append("\t");
              _builder.append("public synchronized boolean resolve() {");
              _builder.newLine();
              _builder.append("\t");
              _builder.append("\t");
              _builder.append("\t");
              _builder.append("Object[] values = new Object[] {};");
              _builder.newLine();
              _builder.append("\t");
              _builder.append("\t");
              _builder.append("\t");
              _builder.append("return super.resolve(values);");
              _builder.newLine();
              _builder.append("\t");
              _builder.append("\t");
              _builder.append("}");
              _builder.newLine();
            } else {
              boolean _and = false;
              Iterable<FArgument> _outputParameters_1 = this._methodUtil.getOutputParameters(method_1);
              int _length = ((Object[])Conversions.unwrapArray(_outputParameters_1, Object.class)).length;
              boolean _equals_2 = (_length == 1);
              if (!_equals_2) {
                _and = false;
              } else {
                boolean _or_3 = false;
                Iterable<FArgument> _outputParameters_2 = this._methodUtil.getOutputParameters(method_1);
                FTypedElement _get_2 = ((FTypedElement[])Conversions.unwrapArray(_outputParameters_2, FTypedElement.class))[0];
                boolean _isArray = this._javaTypeUtil.isArray(_get_2);
                if (_isArray) {
                  _or_3 = true;
                } else {
                  Iterable<FArgument> _outputParameters_3 = this._methodUtil.getOutputParameters(method_1);
                  FArgument _get_3 = ((FArgument[])Conversions.unwrapArray(_outputParameters_3, FArgument.class))[0];
                  FTypeRef _type = _get_3.getType();
                  boolean _isByteBuffer = this._javaTypeUtil.isByteBuffer(_type);
                  _or_3 = _isByteBuffer;
                }
                _and = _or_3;
              }
              if (_and) {
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("public synchronized boolean resolve(");
                String _commaSeperatedTypedOutputParameterList = this._javaTypeUtil.getCommaSeperatedTypedOutputParameterList(method_1);
                _builder.append(_commaSeperatedTypedOutputParameterList, "\t\t");
                _builder.append(") {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("return super.resolve((Object)");
                String _commaSeperatedUntypedOutputParameterList = this._javaTypeUtil.getCommaSeperatedUntypedOutputParameterList(method_1);
                _builder.append(_commaSeperatedUntypedOutputParameterList, "\t\t\t");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
              } else {
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("public synchronized boolean resolve(");
                String _commaSeperatedTypedOutputParameterList_1 = this._javaTypeUtil.getCommaSeperatedTypedOutputParameterList(method_1);
                _builder.append(_commaSeperatedTypedOutputParameterList_1, "\t\t");
                _builder.append(") {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("return super.resolve(");
                String _commaSeperatedUntypedOutputParameterList_1 = this._javaTypeUtil.getCommaSeperatedUntypedOutputParameterList(method_1);
                _builder.append(_commaSeperatedUntypedOutputParameterList_1, "\t\t\t");
                _builder.append(");");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
              }
            }
          }
          {
            boolean _hasErrorEnum = this._methodUtil.hasErrorEnum(method_1);
            if (_hasErrorEnum) {
              {
                FEnumerationType _errors = method_1.getErrors();
                boolean _notEquals = (!Objects.equal(_errors, null));
                if (_notEquals) {
                  _builder.append("\t");
                  _builder.append("\t");
                  _builder.append("public synchronized boolean reject(");
                  _builder.append(packagePath, "\t\t");
                  _builder.append(".");
                  _builder.append(interfaceName, "\t\t");
                  _builder.append(".");
                  String _get_4 = methodToErrorEnumName.get(method_1);
                  _builder.append(_get_4, "\t\t");
                  _builder.append(" error) {");
                  _builder.newLineIfNotEmpty();
                } else {
                  _builder.append("\t");
                  _builder.append("\t");
                  _builder.append("public synchronized boolean reject(");
                  FEnumerationType _errorEnum = method_1.getErrorEnum();
                  String _buildPackagePath = this._joynrJavaGeneratorExtensions.buildPackagePath(_errorEnum, ".", true);
                  _builder.append(_buildPackagePath, "\t\t");
                  _builder.append(".");
                  FEnumerationType _errorEnum_1 = method_1.getErrorEnum();
                  String _joynrName = this._namingUtil.joynrName(_errorEnum_1);
                  _builder.append(_joynrName, "\t\t");
                  _builder.append(" error) {");
                  _builder.newLineIfNotEmpty();
                }
              }
              _builder.append("\t");
              _builder.append("\t");
              _builder.append("\t");
              _builder.append("return super.reject(new ApplicationException(error));");
              _builder.newLine();
              _builder.append("\t");
              _builder.append("\t");
              _builder.append("}");
              _builder.newLine();
            }
          }
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
        }
      }
      {
        EList<FBroadcast> _broadcasts = serviceInterface.getBroadcasts();
        for(final FBroadcast broadcast : _broadcasts) {
          _builder.append("\t");
          final String broadcastName = this._namingUtil.joynrName(broadcast);
          _builder.newLineIfNotEmpty();
          _builder.newLine();
          _builder.append("\t");
          _builder.append("public void fire");
          String _firstUpper_2 = StringExtensions.toFirstUpper(broadcastName);
          _builder.append(_firstUpper_2, "\t");
          _builder.append("(");
          String _commaSeperatedTypedOutputParameterList_2 = this._javaTypeUtil.getCommaSeperatedTypedOutputParameterList(broadcast);
          _builder.append(_commaSeperatedTypedOutputParameterList_2, "\t");
          _builder.append(");");
          _builder.newLineIfNotEmpty();
        }
      }
      _builder.append("}");
      _builder.newLine();
      _xblockexpression = _builder;
    }
    return _xblockexpression;
  }
}
