package io.joynr.generator.provider;

import com.google.inject.Inject;
import io.joynr.generator.templates.InterfaceTemplate;
import io.joynr.generator.templates.util.AttributeUtil;
import io.joynr.generator.templates.util.InterfaceUtil;
import io.joynr.generator.templates.util.NamingUtil;
import io.joynr.generator.util.JavaTypeUtil;
import io.joynr.generator.util.JoynrJavaGeneratorExtensions;
import io.joynr.generator.util.TemplateBase;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.franca.core.franca.FArgument;
import org.franca.core.franca.FAttribute;
import org.franca.core.franca.FBroadcast;
import org.franca.core.franca.FInterface;
import org.franca.core.franca.FTypeRef;

@SuppressWarnings("all")
public class InterfaceAbstractProviderTemplate implements InterfaceTemplate {
  @Inject
  @Extension
  private JoynrJavaGeneratorExtensions _joynrJavaGeneratorExtensions;
  
  @Inject
  @Extension
  private JavaTypeUtil _javaTypeUtil;
  
  @Inject
  @Extension
  private NamingUtil _namingUtil;
  
  @Inject
  @Extension
  private InterfaceUtil _interfaceUtil;
  
  @Inject
  @Extension
  private AttributeUtil _attributeUtil;
  
  @Inject
  @Extension
  private TemplateBase _templateBase;
  
  @Override
  public CharSequence generate(final FInterface serviceInterface) {
    CharSequence _xblockexpression = null;
    {
      final String interfaceName = this._namingUtil.joynrName(serviceInterface);
      final String className = (interfaceName + "AbstractProvider");
      final String providerInterfaceName = (interfaceName + "Provider");
      final String packagePath = this._joynrJavaGeneratorExtensions.getPackagePathWithJoynrPrefix(serviceInterface, ".");
      StringConcatenation _builder = new StringConcatenation();
      CharSequence _warning = this._templateBase.warning();
      _builder.append(_warning, "");
      _builder.newLineIfNotEmpty();
      _builder.append("package ");
      _builder.append(packagePath, "");
      _builder.append(";");
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _builder.append("import io.joynr.provider.AbstractJoynrProvider;");
      _builder.newLine();
      _builder.newLine();
      {
        Iterable<String> _requiredIncludesFor = this._joynrJavaGeneratorExtensions.getRequiredIncludesFor(serviceInterface, false, false, false, true, true);
        for(final String datatype : _requiredIncludesFor) {
          _builder.append("import ");
          _builder.append(datatype, "");
          _builder.append(";");
          _builder.newLineIfNotEmpty();
        }
      }
      _builder.newLine();
      _builder.append("public abstract class ");
      _builder.append(className, "");
      _builder.append(" extends AbstractJoynrProvider implements ");
      _builder.append(providerInterfaceName, "");
      _builder.append(" {");
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _builder.append("\t");
      _builder.append("@Override");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("public Class<?> getProvidedInterface() {");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("return ");
      _builder.append(providerInterfaceName, "\t\t");
      _builder.append(".class;");
      _builder.newLineIfNotEmpty();
      _builder.append("\t");
      _builder.append("}");
      _builder.newLine();
      _builder.newLine();
      _builder.append("\t");
      _builder.append("@Override");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("public String getInterfaceName() {");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("return ");
      _builder.append(providerInterfaceName, "\t\t");
      _builder.append(".INTERFACE_NAME;");
      _builder.newLineIfNotEmpty();
      _builder.append("\t");
      _builder.append("}");
      _builder.newLine();
      _builder.newLine();
      {
        EList<FAttribute> _attributes = this._interfaceUtil.getAttributes(serviceInterface);
        for(final FAttribute attribute : _attributes) {
          _builder.append("\t");
          final String attributeName = this._namingUtil.joynrName(attribute);
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          final String attributeType = this._javaTypeUtil.getTypeName(attribute);
          _builder.newLineIfNotEmpty();
          {
            boolean _isNotifiable = this._attributeUtil.isNotifiable(attribute);
            if (_isNotifiable) {
              _builder.append("\t");
              _builder.append("@Override");
              _builder.newLine();
              _builder.append("\t");
              _builder.append("public final void ");
              _builder.append(attributeName, "\t");
              _builder.append("Changed(");
              _builder.append(attributeType, "\t");
              _builder.append(" ");
              _builder.append(attributeName, "\t");
              _builder.append(") {");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("\t");
              _builder.append("onAttributeValueChanged(\"");
              _builder.append(attributeName, "\t\t");
              _builder.append("\", ");
              _builder.append(attributeName, "\t\t");
              _builder.append(");");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("}");
              _builder.newLine();
            }
          }
        }
      }
      _builder.newLine();
      {
        EList<FBroadcast> _broadcasts = serviceInterface.getBroadcasts();
        for(final FBroadcast broadcast : _broadcasts) {
          _builder.append("\t");
          String broadcastName = this._namingUtil.joynrName(broadcast);
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("@Override");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("public void fire");
          String _firstUpper = StringExtensions.toFirstUpper(broadcastName);
          _builder.append(_firstUpper, "\t");
          _builder.append("(");
          String _commaSeperatedTypedOutputParameterList = this._javaTypeUtil.getCommaSeperatedTypedOutputParameterList(broadcast);
          _builder.append(_commaSeperatedTypedOutputParameterList, "\t");
          _builder.append(") {");
          _builder.newLineIfNotEmpty();
          {
            boolean _and = false;
            EList<FArgument> _outArgs = broadcast.getOutArgs();
            int _length = ((Object[])Conversions.unwrapArray(_outArgs, Object.class)).length;
            boolean _equals = (_length == 1);
            if (!_equals) {
              _and = false;
            } else {
              boolean _or = false;
              EList<FArgument> _outArgs_1 = broadcast.getOutArgs();
              FArgument _get = _outArgs_1.get(0);
              boolean _isArray = this._javaTypeUtil.isArray(_get);
              if (_isArray) {
                _or = true;
              } else {
                EList<FArgument> _outArgs_2 = broadcast.getOutArgs();
                FArgument _get_1 = _outArgs_2.get(0);
                FTypeRef _type = _get_1.getType();
                boolean _isByteBuffer = this._javaTypeUtil.isByteBuffer(_type);
                _or = _isByteBuffer;
              }
              _and = _or;
            }
            if (_and) {
              _builder.append("\t");
              _builder.append("\t");
              _builder.append("// passing array to varargs will cause array elements to be understood as multiple parameters.");
              _builder.newLine();
              _builder.append("\t");
              _builder.append("\t");
              _builder.append("// Cast to Object prevents this.");
              _builder.newLine();
              _builder.append("\t");
              _builder.append("\t");
              _builder.append("fireBroadcast(\"");
              _builder.append(broadcastName, "\t\t");
              _builder.append("\", broadcastFilters.get(\"");
              _builder.append(broadcastName, "\t\t");
              _builder.append("\"), (Object) ");
              String _commaSeperatedUntypedOutputParameterList = this._javaTypeUtil.getCommaSeperatedUntypedOutputParameterList(broadcast);
              _builder.append(_commaSeperatedUntypedOutputParameterList, "\t\t");
              _builder.append(");");
              _builder.newLineIfNotEmpty();
            } else {
              _builder.append("\t");
              _builder.append("\t");
              _builder.append("fireBroadcast(\"");
              _builder.append(broadcastName, "\t\t");
              _builder.append("\", broadcastFilters.get(\"");
              _builder.append(broadcastName, "\t\t");
              _builder.append("\"), ");
              String _commaSeperatedUntypedOutputParameterList_1 = this._javaTypeUtil.getCommaSeperatedUntypedOutputParameterList(broadcast);
              _builder.append(_commaSeperatedUntypedOutputParameterList_1, "\t\t");
              _builder.append(");");
              _builder.newLineIfNotEmpty();
            }
          }
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
          _builder.newLine();
        }
      }
      _builder.append("}");
      _builder.newLine();
      _xblockexpression = _builder;
    }
    return _xblockexpression;
  }
}
