package io.joynr.generator.provider;

import com.google.inject.Inject;
import io.joynr.generator.provider.InterfaceProviderTemplate;
import io.joynr.generator.templates.InterfaceTemplate;
import io.joynr.generator.templates.util.AttributeUtil;
import io.joynr.generator.templates.util.InterfaceUtil;
import io.joynr.generator.templates.util.MethodUtil;
import io.joynr.generator.templates.util.NamingUtil;
import io.joynr.generator.util.JavaTypeUtil;
import io.joynr.generator.util.JoynrJavaGeneratorExtensions;
import io.joynr.generator.util.TemplateBase;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.franca.core.franca.FArgument;
import org.franca.core.franca.FAttribute;
import org.franca.core.franca.FInterface;
import org.franca.core.franca.FMethod;

@SuppressWarnings("all")
public class DefaultInterfaceProviderTemplate implements InterfaceTemplate {
  @Inject
  @Extension
  private JoynrJavaGeneratorExtensions _joynrJavaGeneratorExtensions;
  
  @Inject
  @Extension
  private NamingUtil _namingUtil;
  
  @Inject
  @Extension
  private InterfaceUtil _interfaceUtil;
  
  @Inject
  @Extension
  private AttributeUtil _attributeUtil;
  
  @Inject
  @Extension
  private MethodUtil _methodUtil;
  
  @Inject
  @Extension
  private JavaTypeUtil _javaTypeUtil;
  
  @Inject
  @Extension
  private TemplateBase _templateBase;
  
  @Inject
  @Extension
  private InterfaceProviderTemplate _interfaceProviderTemplate;
  
  @Override
  public CharSequence generate(final FInterface serviceInterface) {
    CharSequence _xblockexpression = null;
    {
      HashMap<FMethod, String> methodToDeferredName = new HashMap<FMethod, String>();
      ArrayList<FMethod> uniqueMethodsToCreateDeferreds = new ArrayList<FMethod>();
      this._interfaceProviderTemplate.init(serviceInterface, methodToDeferredName, uniqueMethodsToCreateDeferreds);
      final String interfaceName = this._namingUtil.joynrName(serviceInterface);
      final String className = (("Default" + interfaceName) + "Provider");
      final String abstractProviderName = (interfaceName + "AbstractProvider");
      final String packagePath = this._joynrJavaGeneratorExtensions.getPackagePathWithJoynrPrefix(serviceInterface, ".");
      StringConcatenation _builder = new StringConcatenation();
      CharSequence _warning = this._templateBase.warning();
      _builder.append(_warning, "");
      _builder.newLineIfNotEmpty();
      _builder.append("package ");
      _builder.append(packagePath, "");
      _builder.append(";");
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _builder.append("import org.slf4j.Logger;");
      _builder.newLine();
      _builder.append("import org.slf4j.LoggerFactory;");
      _builder.newLine();
      _builder.newLine();
      _builder.append("import io.joynr.provider.Promise;");
      _builder.newLine();
      {
        boolean _hasReadAttribute = this._interfaceUtil.hasReadAttribute(serviceInterface);
        if (_hasReadAttribute) {
          _builder.append("import io.joynr.provider.Deferred;");
          _builder.newLine();
        }
      }
      {
        boolean _or = false;
        boolean _hasWriteAttribute = this._interfaceUtil.hasWriteAttribute(serviceInterface);
        if (_hasWriteAttribute) {
          _or = true;
        } else {
          boolean _hasMethodWithArguments = this._interfaceUtil.hasMethodWithArguments(serviceInterface);
          _or = _hasMethodWithArguments;
        }
        if (_or) {
          _builder.append("import io.joynr.dispatcher.rpc.annotation.JoynrRpcParam;");
          _builder.newLine();
        }
      }
      {
        boolean _or_1 = false;
        boolean _hasWriteAttribute_1 = this._interfaceUtil.hasWriteAttribute(serviceInterface);
        if (_hasWriteAttribute_1) {
          _or_1 = true;
        } else {
          boolean _hasMethodWithoutReturnValue = this._interfaceUtil.hasMethodWithoutReturnValue(serviceInterface);
          _or_1 = _hasMethodWithoutReturnValue;
        }
        if (_or_1) {
          _builder.append("import io.joynr.provider.DeferredVoid;");
          _builder.newLine();
        }
      }
      _builder.newLine();
      {
        Iterable<String> _requiredIncludesFor = this._joynrJavaGeneratorExtensions.getRequiredIncludesFor(serviceInterface, true, true, true, false, false);
        for(final String datatype : _requiredIncludesFor) {
          _builder.append("import ");
          _builder.append(datatype, "");
          _builder.append(";");
          _builder.newLineIfNotEmpty();
        }
      }
      _builder.newLine();
      _builder.append("public class ");
      _builder.append(className, "");
      _builder.append(" extends ");
      _builder.append(abstractProviderName, "");
      _builder.append(" {");
      _builder.newLineIfNotEmpty();
      _builder.append("\t");
      _builder.append("private static final Logger logger = LoggerFactory.getLogger(");
      _builder.append(className, "\t");
      _builder.append(".class);");
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      {
        EList<FAttribute> _attributes = this._interfaceUtil.getAttributes(serviceInterface);
        for(final FAttribute attribute : _attributes) {
          _builder.append("\t");
          final String attributeName = this._namingUtil.joynrName(attribute);
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          final String attributeType = this._javaTypeUtil.getTypeName(attribute);
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("protected ");
          _builder.append(attributeType, "\t");
          _builder.append(" ");
          _builder.append(attributeName, "\t");
          _builder.append(";");
          _builder.newLineIfNotEmpty();
        }
      }
      _builder.newLine();
      _builder.append("\t");
      _builder.append("public ");
      _builder.append(className, "\t");
      _builder.append("() {");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      _builder.append("// default uses a priority that is the current time,");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("// causing arbitration to the last started instance");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("providerQos.setPriority(System.currentTimeMillis());");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("}");
      _builder.newLine();
      _builder.newLine();
      {
        EList<FAttribute> _attributes_1 = this._interfaceUtil.getAttributes(serviceInterface);
        for(final FAttribute attribute_1 : _attributes_1) {
          _builder.append("\t");
          final String attributeName_1 = this._namingUtil.joynrName(attribute_1);
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          final String attributeType_1 = this._javaTypeUtil.getTypeName(attribute_1);
          _builder.newLineIfNotEmpty();
          _builder.newLine();
          {
            boolean _isReadable = this._attributeUtil.isReadable(attribute_1);
            if (_isReadable) {
              _builder.append("\t");
              _builder.append("@Override");
              _builder.newLine();
              _builder.append("\t");
              _builder.append("public Promise<Deferred<");
              _builder.append(attributeType_1, "\t");
              _builder.append(">> get");
              String _firstUpper = StringExtensions.toFirstUpper(attributeName_1);
              _builder.append(_firstUpper, "\t");
              _builder.append("() {");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("\t");
              _builder.append("Deferred<");
              _builder.append(attributeType_1, "\t\t");
              _builder.append("> deferred = new Deferred<");
              _builder.append(attributeType_1, "\t\t");
              _builder.append(">();");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("\t");
              _builder.append("deferred.resolve(");
              _builder.append(attributeName_1, "\t\t");
              _builder.append(");");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("\t");
              _builder.append("return new Promise<Deferred<");
              _builder.append(attributeType_1, "\t\t");
              _builder.append(">>(deferred);");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("}");
              _builder.newLine();
            }
          }
          {
            boolean _isWritable = this._attributeUtil.isWritable(attribute_1);
            if (_isWritable) {
              _builder.append("\t");
              _builder.append("@Override");
              _builder.newLine();
              _builder.append("\t");
              _builder.append("public Promise<DeferredVoid> set");
              String _firstUpper_1 = StringExtensions.toFirstUpper(attributeName_1);
              _builder.append(_firstUpper_1, "\t");
              _builder.append("(");
              _builder.append(attributeType_1, "\t");
              _builder.append(" ");
              _builder.append(attributeName_1, "\t");
              _builder.append(") {");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("\t");
              _builder.append("DeferredVoid deferred = new DeferredVoid();");
              _builder.newLine();
              _builder.append("\t");
              _builder.append("\t");
              _builder.append("this.");
              _builder.append(attributeName_1, "\t\t");
              _builder.append(" = ");
              _builder.append(attributeName_1, "\t\t");
              _builder.append(";");
              _builder.newLineIfNotEmpty();
              {
                boolean _isNotifiable = this._attributeUtil.isNotifiable(attribute_1);
                if (_isNotifiable) {
                  _builder.append("\t");
                  _builder.append("\t");
                  _builder.append(attributeName_1, "\t\t");
                  _builder.append("Changed(");
                  _builder.append(attributeName_1, "\t\t");
                  _builder.append(");");
                  _builder.newLineIfNotEmpty();
                }
              }
              _builder.append("\t");
              _builder.append("\t");
              _builder.append("deferred.resolve();");
              _builder.newLine();
              _builder.append("\t");
              _builder.append("\t");
              _builder.append("return new Promise<DeferredVoid>(deferred);");
              _builder.newLine();
              _builder.append("\t");
              _builder.append("}");
              _builder.newLine();
            }
          }
        }
      }
      _builder.newLine();
      {
        EList<FMethod> _methods = this._interfaceUtil.getMethods(serviceInterface);
        for(final FMethod method : _methods) {
          _builder.append("\t");
          String methodName = this._namingUtil.joynrName(method);
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          String deferredName = methodToDeferredName.get(method);
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          String params = this._javaTypeUtil.getTypedParameterListJavaRpc(method);
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          final Iterable<FArgument> outputParameters = this._methodUtil.getOutputParameters(method);
          _builder.newLineIfNotEmpty();
          _builder.newLine();
          _builder.append("\t");
          _builder.append("/*");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("* ");
          _builder.append(methodName, "\t");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("*/");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("@Override");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("public Promise<");
          _builder.append(deferredName, "\t");
          _builder.append("> ");
          _builder.append(methodName, "\t");
          _builder.append("(");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("\t\t");
          {
            boolean _equals = params.equals("");
            boolean _not = (!_equals);
            if (_not) {
              _builder.append(params, "\t\t\t");
            }
          }
          _builder.append(") {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("\t");
          _builder.append("logger.warn(\"**********************************************\");");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("\t");
          _builder.append("logger.warn(\"* ");
          _builder.append(className, "\t\t");
          _builder.append(".");
          _builder.append(methodName, "\t\t");
          _builder.append(" called\");");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("\t");
          _builder.append("logger.warn(\"**********************************************\");");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("\t");
          _builder.append(deferredName, "\t\t");
          _builder.append(" deferred = new ");
          _builder.append(deferredName, "\t\t");
          _builder.append("();");
          _builder.newLineIfNotEmpty();
          {
            for(final FArgument outputParameter : outputParameters) {
              _builder.append("\t");
              _builder.append("\t");
              String _typeName = this._javaTypeUtil.getTypeName(outputParameter);
              _builder.append(_typeName, "\t\t");
              _builder.append(" ");
              String _name = outputParameter.getName();
              _builder.append(_name, "\t\t");
              _builder.append(" = ");
              String _defaultValue = this._javaTypeUtil.getDefaultValue(outputParameter);
              _builder.append(_defaultValue, "\t\t");
              _builder.append(";");
              _builder.newLineIfNotEmpty();
            }
          }
          _builder.append("\t");
          _builder.append("\t");
          _builder.append("deferred.resolve(");
          String _commaSeperatedUntypedOutputParameterList = this._javaTypeUtil.getCommaSeperatedUntypedOutputParameterList(method);
          _builder.append(_commaSeperatedUntypedOutputParameterList, "\t\t");
          _builder.append(");");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("\t");
          _builder.append("return new Promise<");
          _builder.append(deferredName, "\t\t");
          _builder.append(">(deferred);");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
        }
      }
      _builder.append("}");
      _builder.newLine();
      _xblockexpression = _builder;
    }
    return _xblockexpression;
  }
}
