package io.joynr.generator.interfaces;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import io.joynr.generator.communicationmodel.EnumTypeTemplate;
import io.joynr.generator.templates.InterfaceTemplate;
import io.joynr.generator.templates.util.InterfaceUtil;
import io.joynr.generator.templates.util.NamingUtil;
import io.joynr.generator.util.JoynrJavaGeneratorExtensions;
import io.joynr.generator.util.TemplateBase;
import java.util.HashMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.franca.core.franca.FEnumerationType;
import org.franca.core.franca.FInterface;
import org.franca.core.franca.FMethod;

@SuppressWarnings("all")
public class InterfacesTemplate implements InterfaceTemplate {
  @Inject
  @Extension
  private JoynrJavaGeneratorExtensions _joynrJavaGeneratorExtensions;
  
  @Inject
  @Extension
  private NamingUtil _namingUtil;
  
  @Inject
  @Extension
  private InterfaceUtil _interfaceUtil;
  
  @Inject
  @Extension
  private EnumTypeTemplate _enumTypeTemplate;
  
  @Inject
  @Extension
  private TemplateBase _templateBase;
  
  @Override
  public CharSequence generate(final FInterface serviceInterface) {
    CharSequence _xblockexpression = null;
    {
      final String interfaceName = this._namingUtil.joynrName(serviceInterface);
      final String className = interfaceName;
      final String packagePath = this._joynrJavaGeneratorExtensions.getPackagePathWithJoynrPrefix(serviceInterface, ".");
      final boolean hasMethodWithImplicitErrorEnum = this._interfaceUtil.hasMethodWithImplicitErrorEnum(serviceInterface);
      final HashMap<FMethod, String> methodToErrorEnumName = this._interfaceUtil.methodToErrorEnumName(serviceInterface);
      StringConcatenation _builder = new StringConcatenation();
      _builder.newLine();
      _builder.append("\t\t");
      CharSequence _warning = this._templateBase.warning();
      _builder.append(_warning, "\t\t");
      _builder.newLineIfNotEmpty();
      _builder.append("package ");
      _builder.append(packagePath, "");
      _builder.append(";");
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _builder.append("import java.util.List;");
      _builder.newLine();
      {
        if (hasMethodWithImplicitErrorEnum) {
          _builder.append("import java.util.HashMap;");
          _builder.newLine();
          _builder.append("import java.util.Map;");
          _builder.newLine();
          _builder.append("import java.util.Map.Entry;");
          _builder.newLine();
        }
      }
      _builder.newLine();
      _builder.append("import com.fasterxml.jackson.core.type.TypeReference;");
      _builder.newLine();
      {
        Iterable<String> _requiredIncludesFor = this._joynrJavaGeneratorExtensions.getRequiredIncludesFor(serviceInterface);
        for(final String datatype : _requiredIncludesFor) {
          _builder.append("import ");
          _builder.append(datatype, "");
          _builder.append(";");
          _builder.newLineIfNotEmpty();
        }
      }
      _builder.newLine();
      _builder.append("//The current generator is not able to check wether some of the imports are acutally necessary for this specific interface.");
      _builder.newLine();
      _builder.append("//Therefore some imports migth be unused in this version of the interface.");
      _builder.newLine();
      _builder.append("//To prevent warnings @SuppressWarnings(\"unused\") is being used. ");
      _builder.newLine();
      _builder.append("//To prevent warnings about an unnecessary SuppressWarnings we have to import something that is not used. (e.g. TreeSet)");
      _builder.newLine();
      _builder.append("import java.util.TreeSet;");
      _builder.newLine();
      _builder.append("@SuppressWarnings(\"unused\")");
      _builder.newLine();
      _builder.append("public interface ");
      _builder.append(className, "");
      _builder.append("  {");
      _builder.newLineIfNotEmpty();
      _builder.append("\t");
      _builder.append("public static String INTERFACE_NAME = \"");
      String _packagePathWithoutJoynrPrefix = this._joynrJavaGeneratorExtensions.getPackagePathWithoutJoynrPrefix(serviceInterface, "/");
      _builder.append(_packagePathWithoutJoynrPrefix, "\t");
      _builder.append("/");
      _builder.append(interfaceName, "\t");
      _builder.append("\";");
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      {
        EList<FMethod> _methods = this._interfaceUtil.getMethods(serviceInterface);
        for(final FMethod method : _methods) {
          _builder.append("\t");
          FEnumerationType enumType = method.getErrors();
          _builder.newLineIfNotEmpty();
          {
            boolean _notEquals = (!Objects.equal(enumType, null));
            if (_notEquals) {
              _builder.append("\t");
              String _get = methodToErrorEnumName.get(method);
              enumType.setName(_get);
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              CharSequence _generateEnumCode = this._enumTypeTemplate.generateEnumCode(enumType);
              _builder.append(_generateEnumCode, "\t");
              _builder.newLineIfNotEmpty();
              _builder.newLine();
            }
          }
        }
      }
      _builder.append("}");
      _builder.newLine();
      _builder.newLine();
      _xblockexpression = _builder;
    }
    return _xblockexpression;
  }
}
