package io.joynr.generator.interfaces;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import io.joynr.generator.templates.InterfaceTemplate;
import io.joynr.generator.templates.util.AttributeUtil;
import io.joynr.generator.templates.util.InterfaceUtil;
import io.joynr.generator.templates.util.MethodUtil;
import io.joynr.generator.templates.util.NamingUtil;
import io.joynr.generator.util.JavaTypeUtil;
import io.joynr.generator.util.JoynrJavaGeneratorExtensions;
import io.joynr.generator.util.TemplateBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.franca.core.franca.FArgument;
import org.franca.core.franca.FAttribute;
import org.franca.core.franca.FInterface;
import org.franca.core.franca.FMethod;

@SuppressWarnings("all")
public class InterfaceSyncTemplate implements InterfaceTemplate {
  @Inject
  @Extension
  private JoynrJavaGeneratorExtensions _joynrJavaGeneratorExtensions;
  
  @Inject
  @Extension
  private JavaTypeUtil _javaTypeUtil;
  
  @Inject
  @Extension
  private MethodUtil _methodUtil;
  
  @Inject
  @Extension
  private AttributeUtil _attributeUtil;
  
  @Inject
  @Extension
  private InterfaceUtil _interfaceUtil;
  
  @Inject
  @Extension
  private NamingUtil _namingUtil;
  
  @Inject
  @Extension
  private TemplateBase _templateBase;
  
  public void init(final FInterface serviceInterface, final HashMap<FMethod, String> methodToReturnTypeName, final ArrayList<FMethod> uniqueMultioutMethods) {
    HashMap<String, String> uniqueMultioutMethodSignatureToContainerNames = new HashMap<String, String>();
    EList<FMethod> _methods = this._interfaceUtil.getMethods(serviceInterface);
    HashMap<String, Integer> methodCounts = this._methodUtil.overloadedMethodCounts(_methods);
    HashMap<String, Integer> indexForMethod = new HashMap<String, Integer>();
    EList<FMethod> _methods_1 = this._interfaceUtil.getMethods(serviceInterface);
    for (final FMethod method : _methods_1) {
      Iterable<FArgument> _outputParameters = this._methodUtil.getOutputParameters(method);
      int _size = IterableExtensions.size(_outputParameters);
      boolean _lessThan = (_size < 2);
      if (_lessThan) {
        ArrayList<String> _typeNamesForOutputParameter = this._javaTypeUtil.getTypeNamesForOutputParameter(method);
        Iterator<String> _iterator = _typeNamesForOutputParameter.iterator();
        final String outputParamterType = _iterator.next();
        boolean _equals = Objects.equal(outputParamterType, "void");
        if (_equals) {
          methodToReturnTypeName.put(method, "void");
        } else {
          String _objectDataTypeForPlainType = this._javaTypeUtil.getObjectDataTypeForPlainType(outputParamterType);
          methodToReturnTypeName.put(method, _objectDataTypeForPlainType);
        }
      } else {
        String _name = method.getName();
        String containerName = StringExtensions.toFirstUpper(_name);
        String _name_1 = method.getName();
        Integer _get = methodCounts.get(_name_1);
        boolean _equals_1 = ((_get).intValue() == 1);
        if (_equals_1) {
          uniqueMultioutMethods.add(method);
          String _containerName = containerName;
          containerName = (_containerName + "Returned");
        } else {
          String _name_2 = method.getName();
          boolean _containsKey = indexForMethod.containsKey(_name_2);
          boolean _not = (!_containsKey);
          if (_not) {
            String _name_3 = method.getName();
            indexForMethod.put(_name_3, Integer.valueOf(0));
          }
          final String methodSignature = this._methodUtil.createMethodSignatureFromOutParameters(method);
          boolean _containsKey_1 = uniqueMultioutMethodSignatureToContainerNames.containsKey(methodSignature);
          boolean _not_1 = (!_containsKey_1);
          if (_not_1) {
            String _name_4 = method.getName();
            Integer index = indexForMethod.get(_name_4);
            index++;
            String _name_5 = method.getName();
            indexForMethod.put(_name_5, index);
            String _name_6 = method.getName();
            String _firstUpper = StringExtensions.toFirstUpper(_name_6);
            String _plus = (_firstUpper + index);
            uniqueMultioutMethodSignatureToContainerNames.put(methodSignature, _plus);
            uniqueMultioutMethods.add(method);
          }
          String _containerName_1 = containerName;
          String _get_1 = uniqueMultioutMethodSignatureToContainerNames.get(methodSignature);
          String _plus_1 = (_get_1 + "Returned");
          containerName = (_containerName_1 + _plus_1);
        }
        methodToReturnTypeName.put(method, containerName);
      }
    }
  }
  
  @Override
  public CharSequence generate(final FInterface serviceInterface) {
    CharSequence _xblockexpression = null;
    {
      HashMap<FMethod, String> methodToReturnTypeName = new HashMap<FMethod, String>();
      ArrayList<FMethod> uniqueMultioutMethods = new ArrayList<FMethod>();
      this.init(serviceInterface, methodToReturnTypeName, uniqueMultioutMethods);
      final String interfaceName = this._namingUtil.joynrName(serviceInterface);
      final String syncClassName = (interfaceName + "Sync");
      final String packagePath = this._joynrJavaGeneratorExtensions.getPackagePathWithJoynrPrefix(serviceInterface, ".");
      final boolean hasMethodWithArguments = this._interfaceUtil.hasMethodWithArguments(serviceInterface);
      final boolean hasWriteAttribute = this._interfaceUtil.hasWriteAttribute(serviceInterface);
      StringConcatenation _builder = new StringConcatenation();
      CharSequence _warning = this._templateBase.warning();
      _builder.append(_warning, "");
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _builder.append("package ");
      _builder.append(packagePath, "");
      _builder.append(";");
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _builder.append("import io.joynr.dispatcher.rpc.JoynrSyncInterface;");
      _builder.newLine();
      _builder.newLine();
      {
        boolean _or = false;
        if (hasWriteAttribute) {
          _or = true;
        } else {
          _or = hasMethodWithArguments;
        }
        if (_or) {
          _builder.append("import io.joynr.dispatcher.rpc.annotation.JoynrRpcParam;");
          _builder.newLine();
        }
      }
      _builder.newLine();
      _builder.append("import io.joynr.exceptions.JoynrRuntimeException;");
      _builder.newLine();
      {
        boolean _hasMethodWithErrorEnum = this._interfaceUtil.hasMethodWithErrorEnum(serviceInterface);
        if (_hasMethodWithErrorEnum) {
          _builder.append("import joynr.exceptions.ApplicationException;");
          _builder.newLine();
        }
      }
      _builder.newLine();
      {
        Iterable<String> _requiredIncludesFor = this._joynrJavaGeneratorExtensions.getRequiredIncludesFor(serviceInterface, true, true, true, false, false);
        for(final String datatype : _requiredIncludesFor) {
          _builder.append("import ");
          _builder.append(datatype, "");
          _builder.append(";");
          _builder.newLineIfNotEmpty();
        }
      }
      _builder.newLine();
      _builder.append("public interface ");
      _builder.append(syncClassName, "");
      _builder.append(" extends ");
      _builder.append(interfaceName, "");
      _builder.append(", JoynrSyncInterface {");
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      {
        EList<FAttribute> _attributes = this._interfaceUtil.getAttributes(serviceInterface);
        boolean _hasElements = false;
        for(final FAttribute attribute : _attributes) {
          if (!_hasElements) {
            _hasElements = true;
          } else {
            _builder.appendImmediate("\n", "");
          }
          String attributeName = this._namingUtil.joynrName(attribute);
          _builder.newLineIfNotEmpty();
          String _typeName = this._javaTypeUtil.getTypeName(attribute);
          String attributeType = this._javaTypeUtil.getObjectDataTypeForPlainType(_typeName);
          _builder.newLineIfNotEmpty();
          String _firstUpper = StringExtensions.toFirstUpper(attributeName);
          String getAttribute = ("get" + _firstUpper);
          _builder.newLineIfNotEmpty();
          String _firstUpper_1 = StringExtensions.toFirstUpper(attributeName);
          String setAttribute = ("set" + _firstUpper_1);
          _builder.newLineIfNotEmpty();
          {
            boolean _isReadable = this._attributeUtil.isReadable(attribute);
            if (_isReadable) {
              _builder.append("\t");
              _builder.append("public ");
              _builder.append(attributeType, "\t");
              _builder.append(" ");
              _builder.append(getAttribute, "\t");
              _builder.append("() throws JoynrRuntimeException;");
              _builder.newLineIfNotEmpty();
            }
          }
          {
            boolean _isWritable = this._attributeUtil.isWritable(attribute);
            if (_isWritable) {
              _builder.append("\t");
              _builder.append("void ");
              _builder.append(setAttribute, "\t");
              _builder.append("(");
              _builder.append(attributeType, "\t");
              _builder.append(" ");
              _builder.append(attributeName, "\t");
              _builder.append(") throws JoynrRuntimeException;");
              _builder.newLineIfNotEmpty();
            }
          }
        }
      }
      _builder.newLine();
      {
        for(final FMethod method : uniqueMultioutMethods) {
          final String containerName = methodToReturnTypeName.get(method);
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("public class ");
          _builder.append(containerName, "\t");
          _builder.append(" {");
          _builder.newLineIfNotEmpty();
          {
            Iterable<FArgument> _outputParameters = this._methodUtil.getOutputParameters(method);
            for(final FArgument outParameter : _outputParameters) {
              _builder.append("\t\t");
              _builder.append("public final ");
              String _typeName_1 = this._javaTypeUtil.getTypeName(outParameter);
              _builder.append(_typeName_1, "\t\t");
              _builder.append(" ");
              String _name = outParameter.getName();
              _builder.append(_name, "\t\t");
              _builder.append(";");
              _builder.newLineIfNotEmpty();
            }
          }
          _builder.append("\t\t");
          _builder.append("public ");
          _builder.append(containerName, "\t\t");
          _builder.append("(Object... outParameters) {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t\t\t");
          int index = 0;
          _builder.newLineIfNotEmpty();
          {
            Iterable<FArgument> _outputParameters_1 = this._methodUtil.getOutputParameters(method);
            for(final FArgument outParameter_1 : _outputParameters_1) {
              _builder.append("\t\t\t");
              _builder.append("this.");
              String _name_1 = outParameter_1.getName();
              _builder.append(_name_1, "\t\t\t");
              _builder.append(" = (");
              String _typeName_2 = this._javaTypeUtil.getTypeName(outParameter_1);
              _builder.append(_typeName_2, "\t\t\t");
              _builder.append(") outParameters[");
              int _plusPlus = index++;
              _builder.append(_plusPlus, "\t\t\t");
              _builder.append("];");
              _builder.newLineIfNotEmpty();
            }
          }
          _builder.append("\t\t");
          _builder.append("}");
          _builder.newLine();
          _builder.newLine();
          _builder.append("\t\t");
          _builder.append("public static Class<?>[] getDatatypes() {");
          _builder.newLine();
          _builder.append("\t\t\t");
          _builder.append("return new Class<?>[] {");
          {
            Iterable<FArgument> _outputParameters_2 = this._methodUtil.getOutputParameters(method);
            boolean _hasElements_1 = false;
            for(final FArgument outParameter_2 : _outputParameters_2) {
              if (!_hasElements_1) {
                _hasElements_1 = true;
              } else {
                _builder.appendImmediate(", ", "\t\t\t");
              }
              String _typeName_3 = this._javaTypeUtil.getTypeName(outParameter_2);
              _builder.append(_typeName_3, "\t\t\t");
              _builder.append(".class");
            }
          }
          _builder.append("};");
          _builder.newLineIfNotEmpty();
          _builder.append("\t\t");
          _builder.append("}");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
        }
      }
      _builder.newLine();
      {
        EList<FMethod> _methods = this._interfaceUtil.getMethods(serviceInterface);
        boolean _hasElements_2 = false;
        for(final FMethod method_1 : _methods) {
          if (!_hasElements_2) {
            _hasElements_2 = true;
          } else {
            _builder.appendImmediate("\n", "");
          }
          String methodName = this._namingUtil.joynrName(method_1);
          _builder.newLineIfNotEmpty();
          ArrayList<String> outputParameters = this._javaTypeUtil.getTypeNamesForOutputParameter(method_1);
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("/*");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("* ");
          _builder.append(methodName, "\t");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("*/");
          _builder.newLine();
          {
            int _size = outputParameters.size();
            boolean _greaterThan = (_size > 1);
            if (_greaterThan) {
              _builder.append("\t");
              _builder.append("public ");
              String _get = methodToReturnTypeName.get(method_1);
              _builder.append(_get, "\t");
              _builder.append(" ");
              _builder.append(methodName, "\t");
              _builder.append("(");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("\t\t");
              String _typedParameterListJavaRpc = this._javaTypeUtil.getTypedParameterListJavaRpc(method_1);
              _builder.append(_typedParameterListJavaRpc, "\t\t\t");
              _builder.newLineIfNotEmpty();
            } else {
              {
                ArrayList<String> _typeNamesForOutputParameter = this._javaTypeUtil.getTypeNamesForOutputParameter(method_1);
                Iterator<String> _iterator = _typeNamesForOutputParameter.iterator();
                String _next = _iterator.next();
                boolean _equals = Objects.equal(_next, "void");
                if (_equals) {
                  _builder.append("\t");
                  _builder.append("public ");
                  String _get_1 = methodToReturnTypeName.get(method_1);
                  _builder.append(_get_1, "\t");
                  _builder.append(" ");
                  _builder.append(methodName, "\t");
                  _builder.append("(");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t");
                  _builder.append("\t\t");
                  String _typedParameterListJavaRpc_1 = this._javaTypeUtil.getTypedParameterListJavaRpc(method_1);
                  _builder.append(_typedParameterListJavaRpc_1, "\t\t\t");
                  _builder.newLineIfNotEmpty();
                } else {
                  _builder.append("\t");
                  _builder.append("public ");
                  String _get_2 = methodToReturnTypeName.get(method_1);
                  _builder.append(_get_2, "\t");
                  _builder.append(" ");
                  _builder.append(methodName, "\t");
                  _builder.append("(");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t");
                  _builder.append("\t\t");
                  String _typedParameterListJavaRpc_2 = this._javaTypeUtil.getTypedParameterListJavaRpc(method_1);
                  _builder.append(_typedParameterListJavaRpc_2, "\t\t\t");
                  _builder.newLineIfNotEmpty();
                }
              }
            }
          }
          _builder.append("\t");
          _builder.append(") throws JoynrRuntimeException");
          {
            boolean _hasErrorEnum = this._methodUtil.hasErrorEnum(method_1);
            if (_hasErrorEnum) {
              _builder.append(", ApplicationException");
            }
          }
          _builder.append(";");
          _builder.newLineIfNotEmpty();
        }
      }
      _builder.append("}");
      _builder.newLine();
      _xblockexpression = _builder;
    }
    return _xblockexpression;
  }
}
