package io.joynr.generator.interfaces;

import com.google.inject.Inject;
import io.joynr.generator.templates.InterfaceTemplate;
import io.joynr.generator.templates.util.AttributeUtil;
import io.joynr.generator.templates.util.InterfaceUtil;
import io.joynr.generator.templates.util.NamingUtil;
import io.joynr.generator.util.JavaTypeUtil;
import io.joynr.generator.util.JoynrJavaGeneratorExtensions;
import io.joynr.generator.util.TemplateBase;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.franca.core.franca.FAttribute;
import org.franca.core.franca.FInterface;

@SuppressWarnings("all")
public class InterfaceSubscriptionTemplate implements InterfaceTemplate {
  @Inject
  @Extension
  private JoynrJavaGeneratorExtensions _joynrJavaGeneratorExtensions;
  
  @Inject
  @Extension
  private JavaTypeUtil _javaTypeUtil;
  
  @Inject
  @Extension
  private NamingUtil _namingUtil;
  
  @Inject
  @Extension
  private InterfaceUtil _interfaceUtil;
  
  @Inject
  @Extension
  private AttributeUtil _attributeUtil;
  
  @Inject
  @Extension
  private TemplateBase _templateBase;
  
  @Override
  public CharSequence generate(final FInterface serviceInterface) {
    CharSequence _xblockexpression = null;
    {
      final String interfaceName = this._namingUtil.joynrName(serviceInterface);
      final String subscriptionClassName = (interfaceName + "SubscriptionInterface");
      final String packagePath = this._joynrJavaGeneratorExtensions.getPackagePathWithJoynrPrefix(serviceInterface, ".");
      StringConcatenation _builder = new StringConcatenation();
      CharSequence _warning = this._templateBase.warning();
      _builder.append(_warning, "");
      _builder.newLineIfNotEmpty();
      _builder.append("package ");
      _builder.append(packagePath, "");
      _builder.append(";");
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _builder.append("import io.joynr.dispatcher.rpc.JoynrSubscriptionInterface;");
      _builder.newLine();
      _builder.newLine();
      {
        boolean _and = false;
        EList<FAttribute> _attributes = this._interfaceUtil.getAttributes(serviceInterface);
        int _size = _attributes.size();
        boolean _greaterThan = (_size > 0);
        if (!_greaterThan) {
          _and = false;
        } else {
          boolean _hasReadAttribute = this._interfaceUtil.hasReadAttribute(serviceInterface);
          _and = _hasReadAttribute;
        }
        if (_and) {
          _builder.append("import io.joynr.dispatcher.rpc.annotation.JoynrRpcSubscription;");
          _builder.newLine();
          _builder.append("import io.joynr.pubsub.subscription.AttributeSubscriptionListener;");
          _builder.newLine();
          _builder.append("import io.joynr.pubsub.SubscriptionQos;");
          _builder.newLine();
        }
      }
      _builder.newLine();
      {
        Iterable<String> _requiredIncludesFor = this._joynrJavaGeneratorExtensions.getRequiredIncludesFor(serviceInterface, false, false, false, true, false);
        for(final String datatype : _requiredIncludesFor) {
          _builder.append("import ");
          _builder.append(datatype, "");
          _builder.append(";");
          _builder.newLineIfNotEmpty();
        }
      }
      _builder.newLine();
      _builder.append("public interface ");
      _builder.append(subscriptionClassName, "");
      _builder.append(" extends JoynrSubscriptionInterface, ");
      _builder.append(interfaceName, "");
      _builder.append(" {");
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      {
        EList<FAttribute> _attributes_1 = this._interfaceUtil.getAttributes(serviceInterface);
        for(final FAttribute attribute : _attributes_1) {
          String attributeName = this._namingUtil.joynrName(attribute);
          _builder.newLineIfNotEmpty();
          String _typeName = this._javaTypeUtil.getTypeName(attribute);
          String attributeType = this._javaTypeUtil.getObjectDataTypeForPlainType(_typeName);
          _builder.newLineIfNotEmpty();
          {
            boolean _isNotifiable = this._attributeUtil.isNotifiable(attribute);
            if (_isNotifiable) {
              _builder.newLine();
              _builder.append("\t");
              _builder.append("@JoynrRpcSubscription(attributeName = \"");
              _builder.append(attributeName, "\t");
              _builder.append("\", attributeType = ");
              _builder.append(attributeType, "\t");
              _builder.append(".class)");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("public String subscribeTo");
              String _firstUpper = StringExtensions.toFirstUpper(attributeName);
              _builder.append(_firstUpper, "\t");
              _builder.append("(AttributeSubscriptionListener<");
              _builder.append(attributeType, "\t");
              _builder.append("> listener, SubscriptionQos subscriptionQos);");
              _builder.newLineIfNotEmpty();
              _builder.newLine();
              _builder.append("\t");
              _builder.append("@JoynrRpcSubscription(attributeName = \"");
              _builder.append(attributeName, "\t");
              _builder.append("\", attributeType = ");
              _builder.append(attributeType, "\t");
              _builder.append(".class)");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("public String subscribeTo");
              String _firstUpper_1 = StringExtensions.toFirstUpper(attributeName);
              _builder.append(_firstUpper_1, "\t");
              _builder.append("(AttributeSubscriptionListener<");
              _builder.append(attributeType, "\t");
              _builder.append("> listener, SubscriptionQos subscriptionQos, String subscriptionId);");
              _builder.newLineIfNotEmpty();
              _builder.newLine();
              _builder.append("\t");
              _builder.append("public void unsubscribeFrom");
              String _firstUpper_2 = StringExtensions.toFirstUpper(attributeName);
              _builder.append(_firstUpper_2, "\t");
              _builder.append("(String subscriptionId);");
              _builder.newLineIfNotEmpty();
            }
          }
        }
      }
      _builder.append("}");
      _builder.newLine();
      _xblockexpression = _builder;
    }
    return _xblockexpression;
  }
}
