package io.joynr.generator.interfaces;

import com.google.inject.Inject;
import io.joynr.generator.interfaces.InterfaceAsyncTemplate;
import io.joynr.generator.interfaces.InterfaceBroadcastTemplate;
import io.joynr.generator.interfaces.InterfaceSubscriptionTemplate;
import io.joynr.generator.interfaces.InterfaceSyncTemplate;
import io.joynr.generator.interfaces.InterfacesTemplate;
import io.joynr.generator.templates.util.NamingUtil;
import io.joynr.generator.util.JoynrJavaGeneratorExtensions;
import java.io.File;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.xbase.lib.Extension;
import org.franca.core.franca.FAttribute;
import org.franca.core.franca.FBroadcast;
import org.franca.core.franca.FInterface;

@SuppressWarnings("all")
public class InterfaceGenerator {
  @Inject
  @Extension
  private JoynrJavaGeneratorExtensions _joynrJavaGeneratorExtensions;
  
  @Inject
  @Extension
  private NamingUtil _namingUtil;
  
  @Inject
  private InterfacesTemplate interfaces;
  
  @Inject
  private InterfaceSyncTemplate interfaceSync;
  
  @Inject
  private InterfaceAsyncTemplate interfaceAsync;
  
  @Inject
  private InterfaceSubscriptionTemplate interfaceSubscription;
  
  @Inject
  private InterfaceBroadcastTemplate interfaceBroadcast;
  
  public void doGenerate(final FInterface serviceInterface, final IFileSystemAccess fsa) {
    String _packagePathWithJoynrPrefix = this._joynrJavaGeneratorExtensions.getPackagePathWithJoynrPrefix(serviceInterface, File.separator);
    final String path = (_packagePathWithJoynrPrefix + File.separator);
    String serviceName = this._namingUtil.joynrName(serviceInterface);
    this._joynrJavaGeneratorExtensions.generateFile(fsa, 
      ((path + serviceName) + ".java"), 
      this.interfaces, serviceInterface);
    this._joynrJavaGeneratorExtensions.generateFile(fsa, 
      ((path + serviceName) + "Sync.java"), 
      this.interfaceSync, serviceInterface);
    this._joynrJavaGeneratorExtensions.generateFile(fsa, 
      ((path + serviceName) + "Async.java"), 
      this.interfaceAsync, serviceInterface);
    EList<FAttribute> _attributes = serviceInterface.getAttributes();
    int _size = _attributes.size();
    boolean _greaterThan = (_size > 0);
    if (_greaterThan) {
      this._joynrJavaGeneratorExtensions.generateFile(fsa, 
        ((path + serviceName) + "SubscriptionInterface.java"), 
        this.interfaceSubscription, serviceInterface);
    }
    EList<FBroadcast> _broadcasts = serviceInterface.getBroadcasts();
    int _size_1 = _broadcasts.size();
    boolean _greaterThan_1 = (_size_1 > 0);
    if (_greaterThan_1) {
      this._joynrJavaGeneratorExtensions.generateFile(fsa, 
        ((path + serviceName) + "BroadcastInterface.java"), 
        this.interfaceBroadcast, serviceInterface);
    }
  }
}
