package io.joynr.generator.interfaces;

import com.google.inject.Inject;
import io.joynr.generator.templates.InterfaceTemplate;
import io.joynr.generator.templates.util.BroadcastUtil;
import io.joynr.generator.templates.util.NamingUtil;
import io.joynr.generator.util.JavaTypeUtil;
import io.joynr.generator.util.JoynrJavaGeneratorExtensions;
import io.joynr.generator.util.TemplateBase;
import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.franca.core.franca.FBroadcast;
import org.franca.core.franca.FInterface;

@SuppressWarnings("all")
public class InterfaceBroadcastTemplate implements InterfaceTemplate {
  @Inject
  @Extension
  private JoynrJavaGeneratorExtensions _joynrJavaGeneratorExtensions;
  
  @Inject
  @Extension
  private JavaTypeUtil _javaTypeUtil;
  
  @Inject
  @Extension
  private NamingUtil _namingUtil;
  
  @Inject
  @Extension
  private BroadcastUtil _broadcastUtil;
  
  @Inject
  @Extension
  private TemplateBase _templateBase;
  
  @Override
  public CharSequence generate(final FInterface serviceInterface) {
    CharSequence _xblockexpression = null;
    {
      final String interfaceName = this._namingUtil.joynrName(serviceInterface);
      final String broadcastClassName = (interfaceName + "BroadcastInterface");
      final String packagePath = this._joynrJavaGeneratorExtensions.getPackagePathWithJoynrPrefix(serviceInterface, ".");
      StringConcatenation _builder = new StringConcatenation();
      CharSequence _warning = this._templateBase.warning();
      _builder.append(_warning, "");
      _builder.newLineIfNotEmpty();
      _builder.append("package ");
      _builder.append(packagePath, "");
      _builder.append(";");
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _builder.append("import io.joynr.dispatcher.rpc.annotation.JoynrRpcBroadcast;");
      _builder.newLine();
      _builder.append("import io.joynr.dispatcher.rpc.JoynrBroadcastSubscriptionInterface;");
      _builder.newLine();
      _builder.append("import io.joynr.pubsub.subscription.BroadcastSubscriptionListener;");
      _builder.newLine();
      _builder.append("import joynr.OnChangeSubscriptionQos;");
      _builder.newLine();
      _builder.append("import joynr.BroadcastFilterParameters;");
      _builder.newLine();
      _builder.newLine();
      {
        Iterable<String> _requiredIncludesFor = this._joynrJavaGeneratorExtensions.getRequiredIncludesFor(serviceInterface, false, false, false, false, true);
        for(final String datatype : _requiredIncludesFor) {
          _builder.append("import ");
          _builder.append(datatype, "");
          _builder.append(";");
          _builder.newLineIfNotEmpty();
        }
      }
      _builder.newLine();
      _builder.append("public interface ");
      _builder.append(broadcastClassName, "");
      _builder.append(" extends JoynrBroadcastSubscriptionInterface, ");
      _builder.append(interfaceName, "");
      _builder.append(" {");
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      {
        EList<FBroadcast> _broadcasts = serviceInterface.getBroadcasts();
        for(final FBroadcast broadcast : _broadcasts) {
          final String broadcastName = this._namingUtil.joynrName(broadcast);
          _builder.newLineIfNotEmpty();
          final ArrayList<String> filterParameters = this._broadcastUtil.getFilterParameters(broadcast);
          _builder.newLineIfNotEmpty();
          String _firstUpper = StringExtensions.toFirstUpper(broadcastName);
          final String filterParameterType = (_firstUpper + "BroadcastFilterParameters");
          _builder.newLineIfNotEmpty();
          String _firstUpper_1 = StringExtensions.toFirstUpper(broadcastName);
          final String listenerInterface = (_firstUpper_1 + "BroadcastListener");
          _builder.newLineIfNotEmpty();
          _builder.newLine();
          _builder.append("public interface ");
          _builder.append(listenerInterface, "");
          _builder.append(" extends BroadcastSubscriptionListener {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("public void onReceive(");
          String _commaSeperatedTypedOutputParameterList = this._javaTypeUtil.getCommaSeperatedTypedOutputParameterList(broadcast);
          _builder.append(_commaSeperatedTypedOutputParameterList, "\t");
          _builder.append(");");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("public void onError();");
          _builder.newLine();
          _builder.append("}");
          _builder.newLine();
          _builder.newLine();
          _builder.append("public class ");
          String _firstUpper_2 = StringExtensions.toFirstUpper(broadcastName);
          _builder.append(_firstUpper_2, "");
          _builder.append("BroadcastAdapter implements ");
          _builder.append(listenerInterface, "");
          _builder.append(" {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("public void onReceive(");
          String _commaSeperatedTypedOutputParameterList_1 = this._javaTypeUtil.getCommaSeperatedTypedOutputParameterList(broadcast);
          _builder.append(_commaSeperatedTypedOutputParameterList_1, "\t");
          _builder.append(") {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t\t");
          _builder.append("// empty implementation");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("public void onError() {");
          _builder.newLine();
          _builder.append("\t\t");
          _builder.append("// empty implementation");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
          _builder.append("}");
          _builder.newLine();
          _builder.newLine();
          {
            boolean _isSelective = this._broadcastUtil.isSelective(broadcast);
            if (_isSelective) {
              _builder.append("public class ");
              _builder.append(filterParameterType, "");
              _builder.append(" extends BroadcastFilterParameters {");
              _builder.newLineIfNotEmpty();
              _builder.append("\t");
              _builder.append("public ");
              _builder.append(filterParameterType, "\t");
              _builder.append("() {};");
              _builder.newLineIfNotEmpty();
              _builder.newLine();
              {
                int _size = filterParameters.size();
                boolean _greaterThan = (_size > 0);
                if (_greaterThan) {
                  _builder.append("\t");
                  _builder.append("public ");
                  _builder.append(filterParameterType, "\t");
                  _builder.append("(");
                  String _commaSeperatedTypedFilterParameterList = this._javaTypeUtil.getCommaSeperatedTypedFilterParameterList(broadcast);
                  _builder.append(_commaSeperatedTypedFilterParameterList, "\t");
                  _builder.append(") {");
                  _builder.newLineIfNotEmpty();
                  {
                    for(final String filterParameter : filterParameters) {
                      _builder.append("\t");
                      _builder.append("\t");
                      _builder.append("super.setFilterParameter(\"");
                      _builder.append(filterParameter, "\t\t");
                      _builder.append("\", ");
                      _builder.append(filterParameter, "\t\t");
                      _builder.append(");");
                      _builder.newLineIfNotEmpty();
                    }
                  }
                  _builder.append("\t");
                  _builder.append("}");
                  _builder.newLine();
                }
              }
              {
                for(final String filterParameter_1 : filterParameters) {
                  _builder.append("\t");
                  _builder.append("public void set");
                  String _firstUpper_3 = StringExtensions.toFirstUpper(filterParameter_1);
                  _builder.append(_firstUpper_3, "\t");
                  _builder.append("(String ");
                  _builder.append(filterParameter_1, "\t");
                  _builder.append(") {");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t");
                  _builder.append("\t");
                  _builder.append("super.setFilterParameter(\"");
                  _builder.append(filterParameter_1, "\t\t");
                  _builder.append("\", ");
                  _builder.append(filterParameter_1, "\t\t");
                  _builder.append(");");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t");
                  _builder.append("}");
                  _builder.newLine();
                  _builder.append("\t");
                  _builder.append("public String get");
                  String _firstUpper_4 = StringExtensions.toFirstUpper(filterParameter_1);
                  _builder.append(_firstUpper_4, "\t");
                  _builder.append("() {");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t");
                  _builder.append("\t");
                  _builder.append("return super.getFilterParameter(\"");
                  _builder.append(filterParameter_1, "\t\t");
                  _builder.append("\");");
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t");
                  _builder.append("}");
                  _builder.newLine();
                }
              }
              _builder.append("}");
              _builder.newLine();
              _builder.newLine();
              _builder.append("@JoynrRpcBroadcast(broadcastName = \"");
              _builder.append(broadcastName, "");
              _builder.append("\")");
              _builder.newLineIfNotEmpty();
              _builder.append("abstract String subscribeTo");
              String _firstUpper_5 = StringExtensions.toFirstUpper(broadcastName);
              _builder.append(_firstUpper_5, "");
              _builder.append("Broadcast(");
              _builder.newLineIfNotEmpty();
              _builder.append("\t\t");
              _builder.append(listenerInterface, "\t\t");
              _builder.append(" broadcastListener,");
              _builder.newLineIfNotEmpty();
              _builder.append("\t\t");
              _builder.append("OnChangeSubscriptionQos subscriptionQos,");
              _builder.newLine();
              _builder.append("\t\t");
              _builder.append(filterParameterType, "\t\t");
              _builder.append(" filterParameters);");
              _builder.newLineIfNotEmpty();
              _builder.newLine();
              _builder.append("@JoynrRpcBroadcast(broadcastName = \"");
              _builder.append(broadcastName, "");
              _builder.append("\")");
              _builder.newLineIfNotEmpty();
              _builder.append("abstract String subscribeTo");
              String _firstUpper_6 = StringExtensions.toFirstUpper(broadcastName);
              _builder.append(_firstUpper_6, "");
              _builder.append("Broadcast(");
              _builder.newLineIfNotEmpty();
              _builder.append("\t\t");
              _builder.append(listenerInterface, "\t\t");
              _builder.append(" broadcastListener,");
              _builder.newLineIfNotEmpty();
              _builder.append("\t\t");
              _builder.append("OnChangeSubscriptionQos subscriptionQos,");
              _builder.newLine();
              _builder.append("\t\t");
              _builder.append(filterParameterType, "\t\t");
              _builder.append(" filterParameters,");
              _builder.newLineIfNotEmpty();
              _builder.append("\t\t");
              _builder.append("String subscriptionId);");
              _builder.newLine();
            } else {
              _builder.append("@JoynrRpcBroadcast(broadcastName = \"");
              _builder.append(broadcastName, "");
              _builder.append("\")");
              _builder.newLineIfNotEmpty();
              _builder.append("abstract String subscribeTo");
              String _firstUpper_7 = StringExtensions.toFirstUpper(broadcastName);
              _builder.append(_firstUpper_7, "");
              _builder.append("Broadcast(");
              _builder.newLineIfNotEmpty();
              _builder.append("\t\t");
              _builder.append(listenerInterface, "\t\t");
              _builder.append(" subscriptionListener,");
              _builder.newLineIfNotEmpty();
              _builder.append("\t\t");
              _builder.append("OnChangeSubscriptionQos subscriptionQos);");
              _builder.newLine();
              _builder.newLine();
              _builder.append("@JoynrRpcBroadcast(broadcastName = \"");
              _builder.append(broadcastName, "");
              _builder.append("\")");
              _builder.newLineIfNotEmpty();
              _builder.append("abstract String subscribeTo");
              String _firstUpper_8 = StringExtensions.toFirstUpper(broadcastName);
              _builder.append(_firstUpper_8, "");
              _builder.append("Broadcast(");
              _builder.newLineIfNotEmpty();
              _builder.append("\t\t");
              _builder.append(listenerInterface, "\t\t");
              _builder.append(" subscriptionListener,");
              _builder.newLineIfNotEmpty();
              _builder.append("\t\t");
              _builder.append("OnChangeSubscriptionQos subscriptionQos,");
              _builder.newLine();
              _builder.append("\t\t");
              _builder.append("String subscriptionId);");
              _builder.newLine();
            }
          }
          _builder.newLine();
          _builder.append("abstract void unsubscribeFrom");
          String _firstUpper_9 = StringExtensions.toFirstUpper(broadcastName);
          _builder.append(_firstUpper_9, "");
          _builder.append("Broadcast(String subscriptionId);");
          _builder.newLineIfNotEmpty();
        }
      }
      _builder.append("}");
      _builder.newLine();
      _xblockexpression = _builder;
    }
    return _xblockexpression;
  }
}
