package io.joynr.generator.interfaces;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import io.joynr.generator.templates.InterfaceTemplate;
import io.joynr.generator.templates.util.AttributeUtil;
import io.joynr.generator.templates.util.InterfaceUtil;
import io.joynr.generator.templates.util.MethodUtil;
import io.joynr.generator.templates.util.NamingUtil;
import io.joynr.generator.util.JavaTypeUtil;
import io.joynr.generator.util.JoynrJavaGeneratorExtensions;
import io.joynr.generator.util.TemplateBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.franca.core.franca.FArgument;
import org.franca.core.franca.FAttribute;
import org.franca.core.franca.FEnumerationType;
import org.franca.core.franca.FInterface;
import org.franca.core.franca.FMethod;

@SuppressWarnings("all")
public class InterfaceAsyncTemplate implements InterfaceTemplate {
  @Inject
  @Extension
  private JoynrJavaGeneratorExtensions _joynrJavaGeneratorExtensions;
  
  @Inject
  @Extension
  private JavaTypeUtil _javaTypeUtil;
  
  @Inject
  @Extension
  private InterfaceUtil _interfaceUtil;
  
  @Inject
  @Extension
  private MethodUtil _methodUtil;
  
  @Inject
  @Extension
  private NamingUtil _namingUtil;
  
  @Inject
  @Extension
  private AttributeUtil _attributeUtil;
  
  @Inject
  @Extension
  private TemplateBase _templateBase;
  
  public void init(final FInterface serviceInterface, final HashMap<FMethod, String> methodToCallbackName, final HashMap<FMethod, String> methodToFutureName, final HashMap<FMethod, String> methodToErrorEnumName, final HashMap<FMethod, String> methodToSyncReturnedName, final ArrayList<FMethod> uniqueMultioutMethods) {
    final String packagePath = this._joynrJavaGeneratorExtensions.getPackagePathWithJoynrPrefix(serviceInterface, ".");
    HashMap<String, String> uniqueMultioutMethodSignatureToOutputContainerName = new HashMap<String, String>();
    EList<FMethod> _methods = this._interfaceUtil.getMethods(serviceInterface);
    HashMap<String, Integer> methodCounts = this._methodUtil.overloadedMethodCounts(_methods);
    HashMap<String, Integer> indexForMethod = new HashMap<String, Integer>();
    EList<FMethod> _methods_1 = this._interfaceUtil.getMethods(serviceInterface);
    for (final FMethod method : _methods_1) {
      Iterable<FArgument> _outputParameters = this._methodUtil.getOutputParameters(method);
      int _size = IterableExtensions.size(_outputParameters);
      boolean _lessThan = (_size < 2);
      if (_lessThan) {
        ArrayList<String> _typeNamesForOutputParameter = this._javaTypeUtil.getTypeNamesForOutputParameter(method);
        Iterator<String> _iterator = _typeNamesForOutputParameter.iterator();
        final String outputParamterType = _iterator.next();
        String _xifexpression = null;
        boolean _equals = Objects.equal(outputParamterType, "void");
        if (_equals) {
          _xifexpression = "Void";
        } else {
          _xifexpression = this._javaTypeUtil.getObjectDataTypeForPlainType(outputParamterType);
        }
        String outputType = _xifexpression;
        boolean _hasErrorEnum = this._methodUtil.hasErrorEnum(method);
        if (_hasErrorEnum) {
          String errorEnumType = "";
          FEnumerationType _errors = method.getErrors();
          boolean _notEquals = (!Objects.equal(_errors, null));
          if (_notEquals) {
            String _joynrName = this._namingUtil.joynrName(serviceInterface);
            String _plus = ((packagePath + ".") + _joynrName);
            String _plus_1 = (_plus + ".");
            String _get = methodToErrorEnumName.get(method);
            String _plus_2 = (_plus_1 + _get);
            errorEnumType = _plus_2;
          } else {
            FEnumerationType _errorEnum = method.getErrorEnum();
            String _buildPackagePath = this._joynrJavaGeneratorExtensions.buildPackagePath(_errorEnum, ".", true);
            String _plus_3 = (_buildPackagePath + ".");
            FEnumerationType _errorEnum_1 = method.getErrorEnum();
            String _joynrName_1 = this._namingUtil.joynrName(_errorEnum_1);
            String _plus_4 = (_plus_3 + _joynrName_1);
            errorEnumType = _plus_4;
          }
          methodToCallbackName.put(method, (((("CallbackWithModeledError<" + outputType) + ",") + errorEnumType) + ">"));
        } else {
          methodToCallbackName.put(method, (("Callback<" + outputType) + ">"));
        }
        methodToFutureName.put(method, (("Future<" + outputType) + ">"));
        methodToSyncReturnedName.put(method, outputType);
      } else {
        String _name = method.getName();
        String callbackName = StringExtensions.toFirstUpper(_name);
        String _name_1 = method.getName();
        String futureName = StringExtensions.toFirstUpper(_name_1);
        String _name_2 = method.getName();
        String syncReturnedName = StringExtensions.toFirstUpper(_name_2);
        String _name_3 = method.getName();
        Integer _get_1 = methodCounts.get(_name_3);
        boolean _equals_1 = ((_get_1).intValue() == 1);
        if (_equals_1) {
          uniqueMultioutMethods.add(method);
          String _callbackName = callbackName;
          callbackName = (_callbackName + "Callback");
          String _futureName = futureName;
          futureName = (_futureName + "Future");
          String _syncReturnedName = syncReturnedName;
          syncReturnedName = (_syncReturnedName + "Returned");
        } else {
          String _name_4 = method.getName();
          boolean _containsKey = indexForMethod.containsKey(_name_4);
          boolean _not = (!_containsKey);
          if (_not) {
            String _name_5 = method.getName();
            indexForMethod.put(_name_5, Integer.valueOf(0));
          }
          final String methodSignature = this._methodUtil.createMethodSignatureFromOutParameters(method);
          boolean _containsKey_1 = uniqueMultioutMethodSignatureToOutputContainerName.containsKey(methodSignature);
          boolean _not_1 = (!_containsKey_1);
          if (_not_1) {
            String _name_6 = method.getName();
            Integer index = indexForMethod.get(_name_6);
            index++;
            String _name_7 = method.getName();
            indexForMethod.put(_name_7, index);
            String _name_8 = method.getName();
            String _firstUpper = StringExtensions.toFirstUpper(_name_8);
            String _plus_5 = (_firstUpper + index);
            uniqueMultioutMethodSignatureToOutputContainerName.put(methodSignature, _plus_5);
            uniqueMultioutMethods.add(method);
          }
          final String outputContainerName = uniqueMultioutMethodSignatureToOutputContainerName.get(methodSignature);
          String _callbackName_1 = callbackName;
          callbackName = (_callbackName_1 + (outputContainerName + "Callback"));
          String _futureName_1 = futureName;
          futureName = (_futureName_1 + (outputContainerName + "Future"));
          String _syncReturnedName_1 = syncReturnedName;
          syncReturnedName = (_syncReturnedName_1 + (outputContainerName + "Returned"));
        }
        methodToCallbackName.put(method, callbackName);
        methodToFutureName.put(method, futureName);
        methodToSyncReturnedName.put(method, syncReturnedName);
      }
    }
  }
  
  @Override
  public CharSequence generate(final FInterface serviceInterface) {
    CharSequence _xblockexpression = null;
    {
      HashMap<FMethod, String> methodToCallbackName = new HashMap<FMethod, String>();
      HashMap<FMethod, String> methodToFutureName = new HashMap<FMethod, String>();
      HashMap<FMethod, String> methodToErrorEnumName = this._interfaceUtil.methodToErrorEnumName(serviceInterface);
      HashMap<FMethod, String> methodToSyncReturnedName = new HashMap<FMethod, String>();
      ArrayList<FMethod> uniqueMultioutMethods = new ArrayList<FMethod>();
      this.init(serviceInterface, methodToCallbackName, methodToFutureName, methodToErrorEnumName, methodToSyncReturnedName, uniqueMultioutMethods);
      final String interfaceName = this._namingUtil.joynrName(serviceInterface);
      final String asyncClassName = (interfaceName + "Async");
      final String packagePath = this._joynrJavaGeneratorExtensions.getPackagePathWithJoynrPrefix(serviceInterface, ".");
      final boolean hasReadAttribute = this._interfaceUtil.hasReadAttribute(serviceInterface);
      final boolean hasMethodWithArguments = this._interfaceUtil.hasMethodWithArguments(serviceInterface);
      final boolean hasWriteAttribute = this._interfaceUtil.hasWriteAttribute(serviceInterface);
      StringConcatenation _builder = new StringConcatenation();
      CharSequence _warning = this._templateBase.warning();
      _builder.append(_warning, "");
      _builder.newLineIfNotEmpty();
      _builder.append("package ");
      _builder.append(packagePath, "");
      _builder.append(";");
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _builder.append("import io.joynr.dispatcher.rpc.JoynrAsyncInterface;");
      _builder.newLine();
      {
        boolean _or = false;
        EList<FMethod> _methods = this._interfaceUtil.getMethods(serviceInterface);
        int _size = _methods.size();
        boolean _greaterThan = (_size > 0);
        if (_greaterThan) {
          _or = true;
        } else {
          _or = hasReadAttribute;
        }
        if (_or) {
          _builder.append("import io.joynr.proxy.Callback;");
          _builder.newLine();
          {
            boolean _hasMethodWithErrorEnum = this._interfaceUtil.hasMethodWithErrorEnum(serviceInterface);
            if (_hasMethodWithErrorEnum) {
              _builder.append("import io.joynr.proxy.ICallbackWithModeledError;");
              _builder.newLine();
              _builder.append("import io.joynr.proxy.CallbackWithModeledError;");
              _builder.newLine();
            }
          }
          _builder.append("import io.joynr.proxy.Future;");
          _builder.newLine();
          _builder.append("import io.joynr.dispatcher.rpc.annotation.JoynrRpcCallback;");
          _builder.newLine();
        }
      }
      {
        boolean _or_1 = false;
        if (hasWriteAttribute) {
          _or_1 = true;
        } else {
          _or_1 = hasMethodWithArguments;
        }
        if (_or_1) {
          _builder.append("import io.joynr.dispatcher.rpc.annotation.JoynrRpcParam;");
          _builder.newLine();
        }
      }
      {
        int _size_1 = uniqueMultioutMethods.size();
        boolean _greaterThan_1 = (_size_1 > 0);
        if (_greaterThan_1) {
          _builder.append("import io.joynr.proxy.ICallback;");
          _builder.newLine();
        }
      }
      {
        if (hasWriteAttribute) {
          _builder.append("import io.joynr.exceptions.DiscoveryException;");
          _builder.newLine();
        }
      }
      _builder.newLine();
      {
        Iterable<String> _requiredIncludesFor = this._joynrJavaGeneratorExtensions.getRequiredIncludesFor(serviceInterface, true, true, true, false, false);
        for(final String datatype : _requiredIncludesFor) {
          _builder.append("import ");
          _builder.append(datatype, "");
          _builder.append(";");
          _builder.newLineIfNotEmpty();
        }
      }
      _builder.newLine();
      {
        for(final FMethod method : uniqueMultioutMethods) {
          final String syncReturnedName = methodToSyncReturnedName.get(method);
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("import ");
          _builder.append(packagePath, "\t");
          _builder.append(".");
          _builder.append(interfaceName, "\t");
          _builder.append("Sync.");
          _builder.append(syncReturnedName, "\t");
          _builder.append(";");
          _builder.newLineIfNotEmpty();
        }
      }
      _builder.newLine();
      _builder.append("public interface ");
      _builder.append(asyncClassName, "");
      _builder.append(" extends ");
      _builder.append(interfaceName, "");
      _builder.append(", JoynrAsyncInterface {");
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      {
        EList<FAttribute> _attributes = this._interfaceUtil.getAttributes(serviceInterface);
        for(final FAttribute attribute : _attributes) {
          _builder.append("\t");
          String attributeName = this._namingUtil.joynrName(attribute);
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          String _typeName = this._javaTypeUtil.getTypeName(attribute);
          String attributeType = this._javaTypeUtil.getObjectDataTypeForPlainType(_typeName);
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          String _firstUpper = StringExtensions.toFirstUpper(attributeName);
          String getAttribute = ("get" + _firstUpper);
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          String _firstUpper_1 = StringExtensions.toFirstUpper(attributeName);
          String setAttribute = ("set" + _firstUpper_1);
          _builder.newLineIfNotEmpty();
          {
            boolean _isReadable = this._attributeUtil.isReadable(attribute);
            if (_isReadable) {
              _builder.append("\t");
              _builder.append("public Future<");
              _builder.append(attributeType, "\t");
              _builder.append("> ");
              _builder.append(getAttribute, "\t");
              _builder.append("(@JoynrRpcCallback(deserializationType = ");
              _builder.append(attributeType, "\t");
              {
                boolean _isArray = this._javaTypeUtil.isArray(attribute);
                if (_isArray) {
                  _builder.append("[]");
                }
              }
              _builder.append(".class) Callback<");
              _builder.append(attributeType, "\t");
              _builder.append("> callback);");
              _builder.newLineIfNotEmpty();
            }
          }
          {
            boolean _isWritable = this._attributeUtil.isWritable(attribute);
            if (_isWritable) {
              _builder.append("\t");
              _builder.append("Future<Void> ");
              _builder.append(setAttribute, "\t");
              _builder.append("(@JoynrRpcCallback(deserializationType = Void.class) Callback<Void> callback, @JoynrRpcParam(value=\"");
              _builder.append(attributeName, "\t");
              _builder.append("\", deserializationType = ");
              _builder.append(attributeType, "\t");
              _builder.append(".class) ");
              _builder.append(attributeType, "\t");
              _builder.append(" ");
              _builder.append(attributeName, "\t");
              _builder.append(") throws DiscoveryException;");
              _builder.newLineIfNotEmpty();
            }
          }
        }
      }
      _builder.newLine();
      {
        for(final FMethod method_1 : uniqueMultioutMethods) {
          _builder.append("\t");
          final String futureName = methodToFutureName.get(method_1);
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          final String syncReturnedName_1 = methodToSyncReturnedName.get(method_1);
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("public static class ");
          _builder.append(futureName, "\t");
          _builder.append(" extends Future<");
          _builder.append(syncReturnedName_1, "\t");
          _builder.append("> {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("\t");
          _builder.append("public void resolve(Object... outParameters) {");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("\t\t");
          _builder.append("if (outParameters.length == 0) {");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("\t\t\t");
          _builder.append("onSuccess(null);");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("\t\t");
          _builder.append("} else {");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("\t\t\t");
          _builder.append("onSuccess(new ");
          _builder.append(syncReturnedName_1, "\t\t\t\t");
          _builder.append("(outParameters));");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("\t\t");
          _builder.append("}");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
          _builder.newLine();
          _builder.append("\t");
          _builder.append("\t");
          _builder.append("public static Class<?>[] getDatatypes() {");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("\t\t");
          _builder.append("return ");
          _builder.append(syncReturnedName_1, "\t\t\t");
          _builder.append(".getDatatypes();");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
        }
      }
      _builder.newLine();
      {
        for(final FMethod method_2 : uniqueMultioutMethods) {
          _builder.append("\t");
          final String callbackName = methodToCallbackName.get(method_2);
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          Iterable<FArgument> _outputParameters = this._methodUtil.getOutputParameters(method_2);
          final int outputParametersLength = ((Object[])Conversions.unwrapArray(_outputParameters, Object.class)).length;
          _builder.newLineIfNotEmpty();
          {
            boolean _hasErrorEnum = this._methodUtil.hasErrorEnum(method_2);
            if (_hasErrorEnum) {
              {
                FEnumerationType _errors = method_2.getErrors();
                boolean _notEquals = (!Objects.equal(_errors, null));
                if (_notEquals) {
                  _builder.append("\t");
                  String _get = methodToErrorEnumName.get(method_2);
                  final String errorEnumType = ((((packagePath + ".") + interfaceName) + ".") + _get);
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t");
                  _builder.append("public abstract class ");
                  _builder.append(callbackName, "\t");
                  _builder.append(" implements ICallback, ICallbackWithModeledError<");
                  _builder.append(errorEnumType, "\t");
                  _builder.append("> {");
                  _builder.newLineIfNotEmpty();
                } else {
                  _builder.append("\t");
                  FEnumerationType _errorEnum = method_2.getErrorEnum();
                  String _buildPackagePath = this._joynrJavaGeneratorExtensions.buildPackagePath(_errorEnum, ".", true);
                  String _plus = (_buildPackagePath + ".");
                  FEnumerationType _errorEnum_1 = method_2.getErrorEnum();
                  String _joynrName = this._namingUtil.joynrName(_errorEnum_1);
                  final String errorEnumType_1 = (_plus + _joynrName);
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t");
                  _builder.append("public abstract class ");
                  _builder.append(callbackName, "\t");
                  _builder.append(" implements ICallback, ICallbackWithModeledError<");
                  _builder.append(errorEnumType_1, "\t");
                  _builder.append("> {");
                  _builder.newLineIfNotEmpty();
                }
              }
            } else {
              _builder.append("\t");
              _builder.append("public abstract class ");
              _builder.append(callbackName, "\t");
              _builder.append(" implements ICallback {");
              _builder.newLineIfNotEmpty();
            }
          }
          _builder.append("\t");
          _builder.append("\t");
          _builder.append("public abstract void onSuccess(");
          String _commaSeperatedTypedOutputParameterList = this._javaTypeUtil.getCommaSeperatedTypedOutputParameterList(method_2);
          _builder.append(_commaSeperatedTypedOutputParameterList, "\t\t");
          _builder.append(");");
          _builder.newLineIfNotEmpty();
          _builder.newLine();
          _builder.append("\t");
          _builder.append("\t");
          _builder.append("public void resolve(Object... outParameters) {");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("\t\t");
          _builder.append("if (outParameters.length < ");
          _builder.append(outputParametersLength, "\t\t\t");
          _builder.append(") {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("\t\t\t");
          _builder.append("onSuccess(");
          {
            ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, outputParametersLength, true);
            boolean _hasElements = false;
            for(final Integer i : _doubleDotLessThan) {
              if (!_hasElements) {
                _hasElements = true;
              } else {
                _builder.appendImmediate(", ", "\t\t\t\t");
              }
              _builder.append("null");
            }
          }
          _builder.append(");");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("\t\t");
          _builder.append("} else {");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("\t\t\t\t");
          int index = 0;
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("\t\t\t\t");
          _builder.append("onSuccess(");
          _builder.newLine();
          {
            Iterable<FArgument> _outputParameters_1 = this._methodUtil.getOutputParameters(method_2);
            for(final FArgument outParameter : _outputParameters_1) {
              _builder.append("\t");
              _builder.append("\t\t\t\t\t");
              _builder.append("(");
              String _typeName_1 = this._javaTypeUtil.getTypeName(outParameter);
              _builder.append(_typeName_1, "\t\t\t\t\t\t");
              _builder.append(") outParameters[");
              int _plusPlus = index++;
              _builder.append(_plusPlus, "\t\t\t\t\t\t");
              _builder.append("]");
              {
                Iterable<FArgument> _outputParameters_2 = this._methodUtil.getOutputParameters(method_2);
                int _length = ((Object[])Conversions.unwrapArray(_outputParameters_2, Object.class)).length;
                boolean _lessThan = (index < _length);
                if (_lessThan) {
                  _builder.append(",");
                }
              }
              _builder.newLineIfNotEmpty();
            }
          }
          _builder.append("\t");
          _builder.append("\t\t\t");
          _builder.append(");");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("\t\t");
          _builder.append("}");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
        }
      }
      _builder.newLine();
      {
        EList<FMethod> _methods_1 = this._interfaceUtil.getMethods(serviceInterface);
        for(final FMethod method_3 : _methods_1) {
          _builder.append("\t");
          String methodName = this._namingUtil.joynrName(method_3);
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          String params = this._javaTypeUtil.getTypedParameterListJavaRpc(method_3);
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          String callbackParameter = this.getCallbackParameter(method_3, methodToCallbackName);
          _builder.newLineIfNotEmpty();
          _builder.newLine();
          _builder.append("\t");
          _builder.append("/*");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("* ");
          _builder.append(methodName, "\t");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("*/");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("public ");
          String _get_1 = methodToFutureName.get(method_3);
          _builder.append(_get_1, "\t");
          _builder.append(" ");
          _builder.append(methodName, "\t");
          _builder.append("(");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("\t\t");
          _builder.append(callbackParameter, "\t\t\t");
          {
            boolean _equals = params.equals("");
            boolean _not = (!_equals);
            if (_not) {
              _builder.append(",");
            }
          }
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("\t\t");
          {
            boolean _equals_1 = params.equals("");
            boolean _not_1 = (!_equals_1);
            if (_not_1) {
              _builder.append(params, "\t\t\t");
            }
          }
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append(");");
          _builder.newLine();
        }
      }
      _builder.append("}");
      _builder.newLine();
      _xblockexpression = _builder;
    }
    return _xblockexpression;
  }
  
  public String getCallbackParameter(final FMethod method, final HashMap<FMethod, String> methodToCallbackName) {
    ArrayList<String> _typeNamesForOutputParameter = this._javaTypeUtil.getTypeNamesForOutputParameter(method);
    Iterator<String> _iterator = _typeNamesForOutputParameter.iterator();
    String outputParameterType = _iterator.next();
    String outputObjectType = this._javaTypeUtil.getObjectDataTypeForPlainType(outputParameterType);
    String callbackType = methodToCallbackName.get(method);
    Iterable<FArgument> _outputParameters = this._methodUtil.getOutputParameters(method);
    int _size = IterableExtensions.size(_outputParameters);
    boolean _lessThan = (_size < 2);
    if (_lessThan) {
      boolean _notEquals = (!Objects.equal(outputParameterType, "void"));
      if (_notEquals) {
        boolean _equals = Objects.equal(outputObjectType, "");
        if (_equals) {
          throw new IllegalArgumentException((("error in method: " + method) + ". outputObjectType is empty even though outputParameterType is not void"));
        } else {
          return (((("@JoynrRpcCallback(deserializationType = " + outputObjectType) + ".class) ") + callbackType) + " callback");
        }
      } else {
        return (("@JoynrRpcCallback(deserializationType = Void.class) " + callbackType) + " callback");
      }
    } else {
      return (("@JoynrRpcCallback " + callbackType) + " callback");
    }
  }
}
