package io.joynr.generator.filter;

import com.google.inject.Inject;
import io.joynr.generator.templates.BroadcastTemplate;
import io.joynr.generator.templates.util.NamingUtil;
import io.joynr.generator.util.JavaTypeUtil;
import io.joynr.generator.util.JoynrJavaGeneratorExtensions;
import io.joynr.generator.util.TemplateBase;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.franca.core.franca.FBroadcast;
import org.franca.core.franca.FInterface;

@SuppressWarnings("all")
public class FilterTemplate implements BroadcastTemplate {
  @Inject
  @Extension
  private JoynrJavaGeneratorExtensions _joynrJavaGeneratorExtensions;
  
  @Inject
  @Extension
  private JavaTypeUtil _javaTypeUtil;
  
  @Inject
  @Extension
  private NamingUtil _namingUtil;
  
  @Inject
  @Extension
  private TemplateBase _templateBase;
  
  @Override
  public CharSequence generate(final FInterface serviceInterface, final FBroadcast broadcast) {
    CharSequence _xblockexpression = null;
    {
      final String broadcastName = this._namingUtil.joynrName(broadcast);
      String _joynrName = this._namingUtil.joynrName(serviceInterface);
      String _firstUpper = StringExtensions.toFirstUpper(broadcastName);
      String _plus = (_joynrName + _firstUpper);
      final String className = (_plus + "BroadcastFilter");
      final String packagePath = this._joynrJavaGeneratorExtensions.getPackagePathWithJoynrPrefix(serviceInterface, ".");
      StringConcatenation _builder = new StringConcatenation();
      CharSequence _warning = this._templateBase.warning();
      _builder.append(_warning, "");
      _builder.newLineIfNotEmpty();
      _builder.append("package ");
      _builder.append(packagePath, "");
      _builder.append(";");
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _builder.append("import io.joynr.pubsub.publication.BroadcastFilterImpl;");
      _builder.newLine();
      {
        Iterable<String> _requiredIncludesFor = this._joynrJavaGeneratorExtensions.getRequiredIncludesFor(broadcast);
        for(final String datatype : _requiredIncludesFor) {
          _builder.append("import ");
          _builder.append(datatype, "");
          _builder.append(";");
          _builder.newLineIfNotEmpty();
        }
      }
      _builder.newLine();
      _builder.append("public abstract class ");
      _builder.append(className, "");
      _builder.append(" extends BroadcastFilterImpl {");
      _builder.newLineIfNotEmpty();
      _builder.append("\t");
      _builder.append("public ");
      _builder.append(className, "\t");
      _builder.append("(){");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t");
      _builder.append("super(\"");
      _builder.append(broadcastName, "\t\t");
      _builder.append("\");");
      _builder.newLineIfNotEmpty();
      _builder.append("\t");
      _builder.append("}");
      _builder.newLine();
      _builder.newLine();
      _builder.append("\t");
      _builder.append("/*");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("* Override this method to provide a filter logic implementation.");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("*/");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("public abstract boolean filter(");
      _builder.newLine();
      _builder.append("\t\t\t");
      String _commaSeperatedTypedOutputParameterListLinebreak = this._javaTypeUtil.getCommaSeperatedTypedOutputParameterListLinebreak(broadcast);
      _builder.append(_commaSeperatedTypedOutputParameterListLinebreak, "\t\t\t");
      _builder.append(",");
      _builder.newLineIfNotEmpty();
      _builder.append("\t\t\t");
      String _joynrName_1 = this._namingUtil.joynrName(serviceInterface);
      _builder.append(_joynrName_1, "\t\t\t");
      _builder.append("BroadcastInterface.");
      String _firstUpper_1 = StringExtensions.toFirstUpper(broadcastName);
      _builder.append(_firstUpper_1, "\t\t\t");
      _builder.append("BroadcastFilterParameters filterParameters);");
      _builder.newLineIfNotEmpty();
      _builder.append("};");
      _builder.newLine();
      _builder.newLine();
      _xblockexpression = _builder;
    }
    return _xblockexpression;
  }
}
