package io.joynr.generator.communicationmodel;

import com.google.inject.Inject;
import io.joynr.generator.templates.MapTemplate;
import io.joynr.generator.templates.util.NamingUtil;
import io.joynr.generator.util.JavaTypeUtil;
import io.joynr.generator.util.JoynrJavaGeneratorExtensions;
import io.joynr.generator.util.TemplateBase;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.franca.core.franca.FMapType;
import org.franca.core.franca.FType;
import org.franca.core.franca.FTypeRef;

@SuppressWarnings("all")
public class MapTypeTemplate implements MapTemplate {
  @Inject
  @Extension
  private JoynrJavaGeneratorExtensions _joynrJavaGeneratorExtensions;
  
  @Inject
  @Extension
  private JavaTypeUtil _javaTypeUtil;
  
  @Inject
  @Extension
  private TemplateBase _templateBase;
  
  @Inject
  @Extension
  private NamingUtil _namingUtil;
  
  @Override
  public CharSequence generate(final FMapType mapType) {
    CharSequence _xblockexpression = null;
    {
      final String typeName = this._namingUtil.joynrName(mapType);
      final String mapTypePackageName = this._joynrJavaGeneratorExtensions.buildPackagePath(mapType, ".", true);
      StringConcatenation _builder = new StringConcatenation();
      CharSequence _warning = this._templateBase.warning();
      _builder.append(_warning, "");
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _builder.append("package ");
      _builder.append(mapTypePackageName, "");
      _builder.append(";");
      _builder.newLineIfNotEmpty();
      _builder.append("import java.util.HashMap;");
      _builder.newLine();
      _builder.newLine();
      _builder.append("import io.joynr.subtypes.JoynrType;");
      _builder.newLine();
      _builder.newLine();
      FTypeRef _keyType = mapType.getKeyType();
      final Object keyType = this._javaTypeUtil.getDatatype(_keyType);
      _builder.newLineIfNotEmpty();
      FTypeRef _valueType = mapType.getValueType();
      final Object valueType = this._javaTypeUtil.getDatatype(_valueType);
      _builder.newLineIfNotEmpty();
      {
        if ((keyType instanceof FType)) {
          _builder.append("import ");
          String _includeOf = this._joynrJavaGeneratorExtensions.getIncludeOf(((FType)keyType));
          _builder.append(_includeOf, "");
          _builder.append(";");
          _builder.newLineIfNotEmpty();
        }
      }
      {
        if ((valueType instanceof FType)) {
          _builder.append("import ");
          String _includeOf_1 = this._joynrJavaGeneratorExtensions.getIncludeOf(((FType)valueType));
          _builder.append(_includeOf_1, "");
          _builder.append(";");
          _builder.newLineIfNotEmpty();
        }
      }
      _builder.newLine();
      _builder.append("// NOTE: serialVersionUID is not defined since we don\'t support Franca versions right now.");
      _builder.newLine();
      _builder.append("//       The compiler will generate a serialVersionUID based on the class and its members");
      _builder.newLine();
      _builder.append("//       (cf. http://docs.oracle.com/javase/6/docs/platform/serialization/spec/class.html#4100),");
      _builder.newLine();
      _builder.append("//       which is probably more restrictive than what we want.");
      _builder.newLine();
      _builder.newLine();
      _builder.append("/**");
      _builder.newLine();
      CharSequence _appendJavadocSummaryAndWriteSeeAndDescription = this._joynrJavaGeneratorExtensions.appendJavadocSummaryAndWriteSeeAndDescription(mapType, " *");
      _builder.append(_appendJavadocSummaryAndWriteSeeAndDescription, "");
      _builder.newLineIfNotEmpty();
      _builder.append(" ");
      _builder.append("*/");
      _builder.newLine();
      _builder.append("@SuppressWarnings(\"serial\")");
      _builder.newLine();
      _builder.append("public class ");
      _builder.append(typeName, "");
      _builder.append(" extends HashMap<");
      FTypeRef _keyType_1 = mapType.getKeyType();
      String _typeName = this._javaTypeUtil.getTypeName(_keyType_1);
      _builder.append(_typeName, "");
      _builder.append(", ");
      FTypeRef _valueType_1 = mapType.getValueType();
      String _typeName_1 = this._javaTypeUtil.getTypeName(_valueType_1);
      _builder.append(_typeName_1, "");
      _builder.append("> implements JoynrType {");
      _builder.newLineIfNotEmpty();
      _builder.append("    ");
      _builder.append("public ");
      _builder.append(typeName, "    ");
      _builder.append("() {");
      _builder.newLineIfNotEmpty();
      _builder.append("        ");
      _builder.append("super();");
      _builder.newLine();
      _builder.append("    ");
      _builder.append("}");
      _builder.newLine();
      _builder.newLine();
      _builder.append("    ");
      _builder.append("public ");
      _builder.append(typeName, "    ");
      _builder.append("(");
      _builder.append(typeName, "    ");
      _builder.append(" other) {");
      _builder.newLineIfNotEmpty();
      _builder.append("        ");
      _builder.append("super(other);");
      _builder.newLine();
      _builder.append("    ");
      _builder.append("}");
      _builder.newLine();
      _builder.append("}");
      _builder.newLine();
      _xblockexpression = _builder;
    }
    return _xblockexpression;
  }
}
