package io.joynr.generator.communicationmodel;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import io.joynr.generator.templates.EnumTemplate;
import io.joynr.generator.templates.util.NamingUtil;
import io.joynr.generator.util.JavaTypeUtil;
import io.joynr.generator.util.JoynrJavaGeneratorExtensions;
import io.joynr.generator.util.TemplateBase;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.franca.core.franca.FEnumerationType;
import org.franca.core.franca.FEnumerator;
import org.franca.core.franca.FExpression;

@SuppressWarnings("all")
public class EnumTypeTemplate implements EnumTemplate {
  @Inject
  @Extension
  private JoynrJavaGeneratorExtensions _joynrJavaGeneratorExtensions;
  
  @Inject
  @Extension
  private JavaTypeUtil _javaTypeUtil;
  
  @Inject
  @Extension
  private NamingUtil _namingUtil;
  
  @Inject
  @Extension
  private TemplateBase _templateBase;
  
  @Override
  public CharSequence generate(final FEnumerationType enumType) {
    StringConcatenation _builder = new StringConcatenation();
    final String packagePath = this._joynrJavaGeneratorExtensions.buildPackagePath(enumType, ".", true);
    _builder.newLineIfNotEmpty();
    CharSequence _warning = this._templateBase.warning();
    _builder.append(_warning, "");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("package ");
    _builder.append(packagePath, "");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("import java.util.HashMap;");
    _builder.newLine();
    _builder.append("import java.util.Map;");
    _builder.newLine();
    _builder.append("import java.util.Map.Entry;");
    _builder.newLine();
    _builder.newLine();
    CharSequence _generateEnumCode = this.generateEnumCode(enumType);
    _builder.append(_generateEnumCode, "");
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public CharSequence generateEnumCode(final FEnumerationType enumType) {
    StringConcatenation _builder = new StringConcatenation();
    final String typeName = this._namingUtil.joynrName(enumType);
    _builder.newLineIfNotEmpty();
    _builder.append("/**");
    _builder.newLine();
    CharSequence _appendJavadocSummaryAndWriteSeeAndDescription = this._joynrJavaGeneratorExtensions.appendJavadocSummaryAndWriteSeeAndDescription(enumType, " *");
    _builder.append(_appendJavadocSummaryAndWriteSeeAndDescription, "");
    _builder.newLineIfNotEmpty();
    _builder.append(" ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("public enum ");
    _builder.append(typeName, "");
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    {
      EList<FEnumerator> _enumElementsAndBaseEnumElements = this._javaTypeUtil.getEnumElementsAndBaseEnumElements(enumType);
      boolean _hasElements = false;
      for(final FEnumerator enumValue : _enumElementsAndBaseEnumElements) {
        if (!_hasElements) {
          _hasElements = true;
        } else {
          _builder.appendImmediate(",", "\t");
        }
        _builder.append("\t");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(" ");
        _builder.append("* ");
        CharSequence _appendJavadocComment = this._joynrJavaGeneratorExtensions.appendJavadocComment(enumValue, "* ");
        _builder.append(_appendJavadocComment, "\t ");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("\t");
        String _joynrName = this._namingUtil.joynrName(enumValue);
        _builder.append(_joynrName, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
      }
    }
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("static final Map<Integer, ");
    _builder.append(typeName, "\t");
    _builder.append("> ordinalToEnumValues = new HashMap<Integer, ");
    _builder.append(typeName, "\t");
    _builder.append(">();");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("static{");
    _builder.newLine();
    _builder.append("\t\t");
    int ordinal = (-1);
    _builder.newLineIfNotEmpty();
    {
      EList<FEnumerator> _enumElementsAndBaseEnumElements_1 = this._javaTypeUtil.getEnumElementsAndBaseEnumElements(enumType);
      for(final FEnumerator enumValue_1 : _enumElementsAndBaseEnumElements_1) {
        _builder.append("\t\t");
        String _xblockexpression = null;
        {
          Integer _xifexpression = null;
          FExpression _value = enumValue_1.getValue();
          String _enumeratorValue = this._javaTypeUtil.getEnumeratorValue(_value);
          boolean _equals = Objects.equal(_enumeratorValue, null);
          if (_equals) {
            _xifexpression = Integer.valueOf((ordinal + 1));
          } else {
            FExpression _value_1 = enumValue_1.getValue();
            String _enumeratorValue_1 = this._javaTypeUtil.getEnumeratorValue(_value_1);
            _xifexpression = Integer.valueOf(_enumeratorValue_1);
          }
          ordinal = (_xifexpression).intValue();
          _xblockexpression = "";
        }
        _builder.append(_xblockexpression, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("ordinalToEnumValues.put(");
        _builder.append(ordinal, "\t\t");
        _builder.append(", ");
        String _joynrName_1 = this._namingUtil.joynrName(enumValue_1);
        _builder.append(_joynrName_1, "\t\t");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/**");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("* Get the matching enum for an ordinal number");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("* @param ordinal The ordinal number");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("* @return The matching enum for the given ordinal number");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public static ");
    _builder.append(typeName, "\t");
    _builder.append(" getEnumValue(Integer ordinal) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("return ordinalToEnumValues.get(ordinal);");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("/**");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("* Get the matching ordinal number for this enum");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("* @return The ordinal number representing this enum");
    _builder.newLine();
    _builder.append("\t ");
    _builder.append("*/");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public Integer getOrdinal() {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("// TODO should we use a bidirectional map from a third-party library?");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("Integer ordinal = null;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("for(Entry<Integer, ");
    _builder.append(typeName, "\t\t");
    _builder.append("> entry : ordinalToEnumValues.entrySet()) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t");
    _builder.append("if(this == entry.getValue()) {");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("ordinal = entry.getKey();");
    _builder.newLine();
    _builder.append("\t\t\t\t");
    _builder.append("break;");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return ordinal;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
}
