package io.joynr.generator.communicationmodel;

import com.google.inject.Inject;
import io.joynr.generator.templates.CompoundTypeTemplate;
import io.joynr.generator.templates.util.NamingUtil;
import io.joynr.generator.util.JavaTypeUtil;
import io.joynr.generator.util.JoynrJavaGeneratorExtensions;
import io.joynr.generator.util.TemplateBase;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.franca.core.franca.FCompoundType;
import org.franca.core.franca.FField;
import org.franca.core.franca.FTypeDef;
import org.franca.core.franca.FTypeRef;

@SuppressWarnings("all")
public class ComplexTypeTemplate implements CompoundTypeTemplate {
  @Inject
  @Extension
  private JoynrJavaGeneratorExtensions _joynrJavaGeneratorExtensions;
  
  @Inject
  @Extension
  private JavaTypeUtil _javaTypeUtil;
  
  @Inject
  @Extension
  private TemplateBase _templateBase;
  
  @Inject
  @Extension
  private NamingUtil _namingUtil;
  
  @Override
  public CharSequence generate(final FCompoundType complexType) {
    CharSequence _xblockexpression = null;
    {
      final String typeName = this._namingUtil.joynrName(complexType);
      final String complexTypePackageName = this._joynrJavaGeneratorExtensions.buildPackagePath(complexType, ".", true);
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("\t\t");
      CharSequence _warning = this._templateBase.warning();
      _builder.append(_warning, "\t\t");
      _builder.newLineIfNotEmpty();
      _builder.newLine();
      _builder.append("package ");
      _builder.append(complexTypePackageName, "");
      _builder.append(";");
      _builder.newLineIfNotEmpty();
      _builder.append("import java.io.Serializable;");
      _builder.newLine();
      _builder.newLine();
      _builder.append("import io.joynr.subtypes.JoynrType;");
      _builder.newLine();
      _builder.newLine();
      {
        Iterable<String> _requiredIncludesFor = this._joynrJavaGeneratorExtensions.getRequiredIncludesFor(complexType);
        for(final String member : _requiredIncludesFor) {
          _builder.append("import ");
          _builder.append(member, "");
          _builder.append(";");
          _builder.newLineIfNotEmpty();
        }
      }
      {
        boolean _hasArrayMembers = this._joynrJavaGeneratorExtensions.hasArrayMembers(complexType);
        if (_hasArrayMembers) {
          _builder.append("import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;");
          _builder.newLine();
        }
      }
      _builder.append("import com.fasterxml.jackson.annotation.JsonProperty;");
      _builder.newLine();
      _builder.append("import com.fasterxml.jackson.annotation.JsonIgnore;");
      _builder.newLine();
      _builder.newLine();
      _builder.append("// NOTE: serialVersionUID is not defined since we don\'t support Franca versions right now.");
      _builder.newLine();
      _builder.append("//       The compiler will generate a serialVersionUID based on the class and its members");
      _builder.newLine();
      _builder.append("//       (cf. http://docs.oracle.com/javase/6/docs/platform/serialization/spec/class.html#4100),");
      _builder.newLine();
      _builder.append("//       which is probably more restrictive than what we want.");
      _builder.newLine();
      _builder.newLine();
      _builder.append("/**");
      _builder.newLine();
      CharSequence _appendJavadocSummaryAndWriteSeeAndDescription = this._joynrJavaGeneratorExtensions.appendJavadocSummaryAndWriteSeeAndDescription(complexType, " *");
      _builder.append(_appendJavadocSummaryAndWriteSeeAndDescription, "");
      _builder.newLineIfNotEmpty();
      _builder.append(" ");
      _builder.append("*/");
      _builder.newLine();
      _builder.append("@SuppressWarnings(\"serial\")");
      _builder.newLine();
      _builder.append("public class ");
      _builder.append(typeName, "");
      {
        boolean _hasExtendsDeclaration = this._javaTypeUtil.hasExtendsDeclaration(complexType);
        if (_hasExtendsDeclaration) {
          _builder.append(" extends ");
          FCompoundType _extendedType = this._javaTypeUtil.getExtendedType(complexType);
          String _typeName = this._javaTypeUtil.getTypeName(_extendedType);
          _builder.append(_typeName, "");
        }
      }
      _builder.append(" implements Serializable, JoynrType {");
      _builder.newLineIfNotEmpty();
      {
        EList<FField> _members = this._javaTypeUtil.getMembers(complexType);
        for(final FField member_1 : _members) {
          _builder.append("\t");
          String _typeName_1 = this._javaTypeUtil.getTypeName(member_1);
          final String memberType = _typeName_1.replace("::", "__");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("@JsonProperty(\"");
          String _joynrName = this._namingUtil.joynrName(member_1);
          _builder.append(_joynrName, "\t");
          _builder.append("\")");
          _builder.newLineIfNotEmpty();
          {
            boolean _isArray = this._javaTypeUtil.isArray(member_1);
            if (_isArray) {
              _builder.append("\t");
              _builder.append("private ");
              _builder.append(memberType, "\t");
              _builder.append(" ");
              String _joynrName_1 = this._namingUtil.joynrName(member_1);
              _builder.append(_joynrName_1, "\t");
              _builder.append(" = {};");
              _builder.newLineIfNotEmpty();
            } else {
              _builder.append("\t");
              _builder.append("private ");
              _builder.append(memberType, "\t");
              _builder.append(" ");
              String _joynrName_2 = this._namingUtil.joynrName(member_1);
              _builder.append(_joynrName_2, "\t");
              _builder.append(";");
              _builder.newLineIfNotEmpty();
            }
          }
        }
      }
      _builder.newLine();
      _builder.append("\t");
      _builder.append("/**");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* Default Constructor");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("*/");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("public ");
      _builder.append(typeName, "\t");
      _builder.append("() {");
      _builder.newLineIfNotEmpty();
      {
        EList<FField> _members_1 = this._javaTypeUtil.getMembers(complexType);
        for(final FField member_2 : _members_1) {
          {
            boolean _isArray_1 = this._javaTypeUtil.isArray(member_2);
            boolean _not = (!_isArray_1);
            if (_not) {
              _builder.append("\t\t");
              _builder.append("this.");
              String _joynrName_3 = this._namingUtil.joynrName(member_2);
              _builder.append(_joynrName_3, "\t\t");
              _builder.append(" = ");
              String _defaultValue = this._javaTypeUtil.getDefaultValue(member_2);
              _builder.append(_defaultValue, "\t\t");
              _builder.append(";");
              _builder.newLineIfNotEmpty();
            }
          }
        }
      }
      _builder.append("\t");
      _builder.append("}");
      _builder.newLine();
      _builder.newLine();
      _builder.append("\t");
      String _firstLower = StringExtensions.toFirstLower(typeName);
      final String copyObjName = (_firstLower + "Obj");
      _builder.newLineIfNotEmpty();
      _builder.append("\t");
      _builder.append("/**");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* Copy constructor");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("*");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* @param ");
      _builder.append(copyObjName, "\t ");
      _builder.append(" reference to the object to be copied");
      _builder.newLineIfNotEmpty();
      _builder.append("\t ");
      _builder.append("*/");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("public ");
      _builder.append(typeName, "\t");
      _builder.append("(");
      _builder.append(typeName, "\t");
      _builder.append(" ");
      _builder.append(copyObjName, "\t");
      _builder.append(") {");
      _builder.newLineIfNotEmpty();
      {
        boolean _hasExtendsDeclaration_1 = this._javaTypeUtil.hasExtendsDeclaration(complexType);
        if (_hasExtendsDeclaration_1) {
          _builder.append("\t\t");
          _builder.append("super(");
          _builder.append(copyObjName, "\t\t");
          _builder.append(");");
          _builder.newLineIfNotEmpty();
        }
      }
      {
        EList<FField> _members_2 = this._javaTypeUtil.getMembers(complexType);
        for(final FField member_3 : _members_2) {
          {
            boolean _isArray_2 = this._javaTypeUtil.isArray(member_3);
            if (_isArray_2) {
              _builder.append("\t\t");
              _builder.append("this.");
              String _joynrName_4 = this._namingUtil.joynrName(member_3);
              _builder.append(_joynrName_4, "\t\t");
              _builder.append(" = ");
              _builder.append(copyObjName, "\t\t");
              _builder.append(".");
              String _joynrName_5 = this._namingUtil.joynrName(member_3);
              _builder.append(_joynrName_5, "\t\t");
              _builder.append(";");
              _builder.newLineIfNotEmpty();
            } else {
              {
                boolean _or = false;
                FTypeRef _type = member_3.getType();
                boolean _isCompound = this._javaTypeUtil.isCompound(_type);
                if (_isCompound) {
                  _or = true;
                } else {
                  FTypeRef _type_1 = member_3.getType();
                  boolean _isMap = this._javaTypeUtil.isMap(_type_1);
                  _or = _isMap;
                }
                if (_or) {
                  _builder.append("\t\t");
                  FTypeRef _type_2 = member_3.getType();
                  final String memberType_1 = this._javaTypeUtil.getTypeName(_type_2);
                  _builder.newLineIfNotEmpty();
                  _builder.append("\t\t");
                  _builder.append("this.");
                  String _joynrName_6 = this._namingUtil.joynrName(member_3);
                  _builder.append(_joynrName_6, "\t\t");
                  _builder.append(" = new ");
                  _builder.append(memberType_1, "\t\t");
                  _builder.append("(");
                  _builder.append(copyObjName, "\t\t");
                  _builder.append(".");
                  String _joynrName_7 = this._namingUtil.joynrName(member_3);
                  _builder.append(_joynrName_7, "\t\t");
                  _builder.append(");");
                  _builder.newLineIfNotEmpty();
                } else {
                  _builder.append("\t\t");
                  _builder.append("this.");
                  String _joynrName_8 = this._namingUtil.joynrName(member_3);
                  _builder.append(_joynrName_8, "\t\t");
                  _builder.append(" = ");
                  _builder.append(copyObjName, "\t\t");
                  _builder.append(".");
                  String _joynrName_9 = this._namingUtil.joynrName(member_3);
                  _builder.append(_joynrName_9, "\t\t");
                  _builder.append(";");
                  _builder.newLineIfNotEmpty();
                }
              }
            }
          }
        }
      }
      _builder.append("\t");
      _builder.append("}");
      _builder.newLine();
      _builder.newLine();
      {
        Iterable<FField> _membersRecursive = this._javaTypeUtil.getMembersRecursive(complexType);
        boolean _isEmpty = IterableExtensions.isEmpty(_membersRecursive);
        boolean _not_1 = (!_isEmpty);
        if (_not_1) {
          _builder.append("\t");
          _builder.append("/**");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("* Parameterized constructor");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("*");
          _builder.newLine();
          {
            Iterable<FField> _membersRecursive_1 = this._javaTypeUtil.getMembersRecursive(complexType);
            for(final FField member_4 : _membersRecursive_1) {
              _builder.append("\t");
              _builder.append(" ");
              String _appendJavadocParameter = this._joynrJavaGeneratorExtensions.appendJavadocParameter(member_4, "*");
              _builder.append(_appendJavadocParameter, "\t ");
              _builder.newLineIfNotEmpty();
            }
          }
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("*/");
          _builder.newLine();
          _builder.append("\t");
          {
            boolean _hasArrayMembers_1 = this._joynrJavaGeneratorExtensions.hasArrayMembers(complexType);
            if (_hasArrayMembers_1) {
              _builder.append("@SuppressFBWarnings(value = \"EI_EXPOSE_REP2\", justification = \"joynr object not used for storing internal state\")");
            }
          }
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("public ");
          _builder.append(typeName, "\t");
          _builder.append("(");
          _builder.newLineIfNotEmpty();
          {
            Iterable<FField> _membersRecursive_2 = this._javaTypeUtil.getMembersRecursive(complexType);
            boolean _hasElements = false;
            for(final FField member_5 : _membersRecursive_2) {
              if (!_hasElements) {
                _hasElements = true;
              } else {
                _builder.appendImmediate(",", "\t\t");
              }
              _builder.append("\t");
              _builder.append("\t");
              String _typeName_2 = this._javaTypeUtil.getTypeName(member_5);
              String _replace = _typeName_2.replace("::", "__");
              _builder.append(_replace, "\t\t");
              _builder.append(" ");
              String _joynrName_10 = this._namingUtil.joynrName(member_5);
              _builder.append(_joynrName_10, "\t\t");
              _builder.newLineIfNotEmpty();
            }
          }
          _builder.append("\t");
          _builder.append("\t");
          _builder.append(") {");
          _builder.newLine();
          {
            boolean _hasExtendsDeclaration_2 = this._javaTypeUtil.hasExtendsDeclaration(complexType);
            if (_hasExtendsDeclaration_2) {
              _builder.append("\t");
              _builder.append("\t");
              _builder.append("super(");
              _builder.newLine();
              {
                FCompoundType _extendedType_1 = this._javaTypeUtil.getExtendedType(complexType);
                Iterable<FField> _membersRecursive_3 = this._javaTypeUtil.getMembersRecursive(_extendedType_1);
                boolean _hasElements_1 = false;
                for(final FField member_6 : _membersRecursive_3) {
                  if (!_hasElements_1) {
                    _hasElements_1 = true;
                  } else {
                    _builder.appendImmediate(",", "\t\t\t\t");
                  }
                  _builder.append("\t");
                  _builder.append("\t");
                  _builder.append("\t\t");
                  String _joynrName_11 = this._namingUtil.joynrName(member_6);
                  _builder.append(_joynrName_11, "\t\t\t\t");
                  _builder.newLineIfNotEmpty();
                }
              }
              _builder.append("\t");
              _builder.append("\t");
              _builder.append(");");
              _builder.newLine();
            }
          }
          {
            EList<FField> _members_3 = this._javaTypeUtil.getMembers(complexType);
            for(final FField member_7 : _members_3) {
              _builder.append("\t");
              _builder.append("\t");
              _builder.append("this.");
              String _joynrName_12 = this._namingUtil.joynrName(member_7);
              _builder.append(_joynrName_12, "\t\t");
              _builder.append(" = ");
              String _joynrName_13 = this._namingUtil.joynrName(member_7);
              _builder.append(_joynrName_13, "\t\t");
              _builder.append(";");
              _builder.newLineIfNotEmpty();
            }
          }
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
        }
      }
      _builder.newLine();
      {
        EList<FField> _members_4 = this._javaTypeUtil.getMembers(complexType);
        for(final FField member_8 : _members_4) {
          _builder.append("\t");
          String _typeName_3 = this._javaTypeUtil.getTypeName(member_8);
          final String memberType_2 = _typeName_3.replace("::", "__");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          final String memberName = this._namingUtil.joynrName(member_8);
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("/**");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("* Gets ");
          String _firstUpper = StringExtensions.toFirstUpper(memberName);
          _builder.append(_firstUpper, "\t ");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("*");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("* @return ");
          CharSequence _appendJavadocComment = this._joynrJavaGeneratorExtensions.appendJavadocComment(member_8, "* ");
          _builder.append(_appendJavadocComment, "\t ");
          {
            FTypeRef _type_3 = member_8.getType();
            boolean _isTypeDef = this._javaTypeUtil.isTypeDef(_type_3);
            if (_isTypeDef) {
              _builder.append(" (type resolved from modeled Franca typedef ");
              FTypeRef _type_4 = member_8.getType();
              String _joynrName_14 = this._namingUtil.joynrName(_type_4);
              _builder.append(_joynrName_14, "\t ");
              _builder.append(" as ");
              FTypeRef _type_5 = member_8.getType();
              FTypeDef _typeDefType = this._javaTypeUtil.getTypeDefType(_type_5);
              FTypeRef _actualType = _typeDefType.getActualType();
              String _typeName_4 = this._javaTypeUtil.getTypeName(_actualType);
              _builder.append(_typeName_4, "\t ");
              _builder.append(")");
            }
          }
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("*/");
          _builder.newLine();
          _builder.append("\t");
          {
            boolean _isArray_3 = this._javaTypeUtil.isArray(member_8);
            if (_isArray_3) {
              _builder.append("@SuppressFBWarnings(value = \"EI_EXPOSE_REP\", justification = \"joynr object not used for storing internal state\")");
            }
          }
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("@JsonIgnore");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("public ");
          _builder.append(memberType_2, "\t");
          _builder.append(" get");
          String _firstUpper_1 = StringExtensions.toFirstUpper(memberName);
          _builder.append(_firstUpper_1, "\t");
          _builder.append("() {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("\t");
          _builder.append("return this.");
          String _joynrName_15 = this._namingUtil.joynrName(member_8);
          _builder.append(_joynrName_15, "\t\t");
          _builder.append(";");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
          _builder.newLine();
          _builder.append("\t");
          _builder.append("/**");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("* Sets ");
          String _firstUpper_2 = StringExtensions.toFirstUpper(memberName);
          _builder.append(_firstUpper_2, "\t ");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("*");
          _builder.newLine();
          _builder.append("\t");
          _builder.append(" ");
          String _appendJavadocParameter_1 = this._joynrJavaGeneratorExtensions.appendJavadocParameter(member_8, "*");
          _builder.append(_appendJavadocParameter_1, "\t ");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append(" ");
          _builder.append("*/");
          _builder.newLine();
          _builder.append("\t");
          {
            boolean _isArray_4 = this._javaTypeUtil.isArray(member_8);
            if (_isArray_4) {
              _builder.append("@SuppressFBWarnings(value = \"EI_EXPOSE_REP2\", justification = \"joynr object not used for storing internal state\")");
            }
          }
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("@JsonIgnore");
          _builder.newLine();
          _builder.append("\t");
          _builder.append("public void set");
          String _firstUpper_3 = StringExtensions.toFirstUpper(memberName);
          _builder.append(_firstUpper_3, "\t");
          _builder.append("(");
          _builder.append(memberType_2, "\t");
          _builder.append(" ");
          String _joynrName_16 = this._namingUtil.joynrName(member_8);
          _builder.append(_joynrName_16, "\t");
          _builder.append(") {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("\t");
          _builder.append("this.");
          String _joynrName_17 = this._namingUtil.joynrName(member_8);
          _builder.append(_joynrName_17, "\t\t");
          _builder.append(" = ");
          String _joynrName_18 = this._namingUtil.joynrName(member_8);
          _builder.append(_joynrName_18, "\t\t");
          _builder.append(";");
          _builder.newLineIfNotEmpty();
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
          _builder.newLine();
        }
      }
      _builder.newLine();
      _builder.append("\t");
      _builder.append("/**");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* Stringifies the class");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("*");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* @return stringified class content");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("*/");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("@Override");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("public String toString() {");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("return \"");
      _builder.append(typeName, "\t\t");
      _builder.append(" [\"");
      _builder.newLineIfNotEmpty();
      {
        boolean _hasExtendsDeclaration_3 = this._javaTypeUtil.hasExtendsDeclaration(complexType);
        if (_hasExtendsDeclaration_3) {
          _builder.append("\t\t");
          _builder.append("+ super.toString() + \", \"");
          _builder.newLine();
        }
      }
      {
        EList<FField> _members_5 = this._javaTypeUtil.getMembers(complexType);
        boolean _hasElements_2 = false;
        for(final FField member_9 : _members_5) {
          if (!_hasElements_2) {
            _hasElements_2 = true;
          } else {
            _builder.appendImmediate(" + \", \"", "\t\t");
          }
          {
            boolean _isArray_5 = this._javaTypeUtil.isArray(member_9);
            if (_isArray_5) {
              _builder.append("\t\t");
              _builder.append("+ \"");
              String _joynrName_19 = this._namingUtil.joynrName(member_9);
              _builder.append(_joynrName_19, "\t\t");
              _builder.append("=\" + java.util.Arrays.toString(this.");
              String _joynrName_20 = this._namingUtil.joynrName(member_9);
              _builder.append(_joynrName_20, "\t\t");
              _builder.append(")");
              _builder.newLineIfNotEmpty();
            } else {
              _builder.append("\t\t");
              _builder.append("+ \"");
              String _joynrName_21 = this._namingUtil.joynrName(member_9);
              _builder.append(_joynrName_21, "\t\t");
              _builder.append("=\" + this.");
              String _joynrName_22 = this._namingUtil.joynrName(member_9);
              _builder.append(_joynrName_22, "\t\t");
              _builder.newLineIfNotEmpty();
            }
          }
        }
      }
      _builder.append("\t\t");
      _builder.append("+ \"]\";");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("}");
      _builder.newLine();
      _builder.newLine();
      _builder.append("\t");
      _builder.append("/**");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* Check for equality");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("*");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* @param obj Reference to the object to compare to");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* @return true, if objects are equal, false otherwise");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("*/");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("@Override");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("public boolean equals(Object obj) {");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("if (this == obj)");
      _builder.newLine();
      _builder.append("\t\t\t");
      _builder.append("return true;");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("if (obj == null)");
      _builder.newLine();
      _builder.append("\t\t\t");
      _builder.append("return false;");
      _builder.newLine();
      _builder.append("\t\t");
      _builder.append("if (getClass() != obj.getClass())");
      _builder.newLine();
      _builder.append("\t\t\t");
      _builder.append("return false;");
      _builder.newLine();
      {
        boolean _hasExtendsDeclaration_4 = this._javaTypeUtil.hasExtendsDeclaration(complexType);
        if (_hasExtendsDeclaration_4) {
          _builder.append("\t\t");
          _builder.append("if (!super.equals(obj))");
          _builder.newLine();
          _builder.append("\t\t");
          _builder.append("\t");
          _builder.append("return false;");
          _builder.newLine();
        }
      }
      {
        EList<FField> _members_6 = this._javaTypeUtil.getMembers(complexType);
        boolean _isEmpty_1 = _members_6.isEmpty();
        boolean _not_2 = (!_isEmpty_1);
        if (_not_2) {
          _builder.append("\t\t");
          _builder.append(typeName, "\t\t");
          _builder.append(" other = (");
          _builder.append(typeName, "\t\t");
          _builder.append(") obj;");
          _builder.newLineIfNotEmpty();
        }
      }
      {
        EList<FField> _members_7 = this._javaTypeUtil.getMembers(complexType);
        for(final FField member_10 : _members_7) {
          _builder.append("\t\t");
          _builder.append("if (this.");
          String _joynrName_23 = this._namingUtil.joynrName(member_10);
          _builder.append(_joynrName_23, "\t\t");
          _builder.append(" == null) {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t\t");
          _builder.append("\t");
          _builder.append("if (other.");
          String _joynrName_24 = this._namingUtil.joynrName(member_10);
          _builder.append(_joynrName_24, "\t\t\t");
          _builder.append(" != null) {");
          _builder.newLineIfNotEmpty();
          _builder.append("\t\t");
          _builder.append("\t\t");
          _builder.append("return false;");
          _builder.newLine();
          _builder.append("\t\t");
          _builder.append("\t");
          _builder.append("}");
          _builder.newLine();
          {
            FTypeRef _type_6 = member_10.getType();
            boolean _isByteBuffer = this._javaTypeUtil.isByteBuffer(_type_6);
            if (_isByteBuffer) {
              _builder.append("\t\t");
              _builder.append("} else if (!java.util.Arrays.equals(this.");
              String _joynrName_25 = this._namingUtil.joynrName(member_10);
              _builder.append(_joynrName_25, "\t\t");
              _builder.append(", other.");
              String _joynrName_26 = this._namingUtil.joynrName(member_10);
              _builder.append(_joynrName_26, "\t\t");
              _builder.append(")){");
              _builder.newLineIfNotEmpty();
              _builder.append("\t\t");
              _builder.append("\t");
              _builder.append("return false;");
              _builder.newLine();
              _builder.append("\t\t");
              _builder.append("}");
              _builder.newLine();
            } else {
              boolean _isArray_6 = this._javaTypeUtil.isArray(member_10);
              if (_isArray_6) {
                _builder.append("\t\t");
                _builder.append("} else if (!java.util.Arrays.deepEquals(this.");
                String _joynrName_27 = this._namingUtil.joynrName(member_10);
                _builder.append(_joynrName_27, "\t\t");
                _builder.append(", other.");
                String _joynrName_28 = this._namingUtil.joynrName(member_10);
                _builder.append(_joynrName_28, "\t\t");
                _builder.append(")){");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("\t");
                _builder.append("return false;");
                _builder.newLine();
                _builder.append("\t\t");
                _builder.append("}");
                _builder.newLine();
              } else {
                _builder.append("\t\t");
                _builder.append("} else if (!this.");
                String _joynrName_29 = this._namingUtil.joynrName(member_10);
                _builder.append(_joynrName_29, "\t\t");
                _builder.append(".equals(other.");
                String _joynrName_30 = this._namingUtil.joynrName(member_10);
                _builder.append(_joynrName_30, "\t\t");
                _builder.append(")){");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                _builder.append("\t");
                _builder.append("return false;");
                _builder.newLine();
                _builder.append("\t\t");
                _builder.append("}");
                _builder.newLine();
              }
            }
          }
        }
      }
      _builder.append("\t\t");
      _builder.append("return true;");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("}");
      _builder.newLine();
      _builder.newLine();
      _builder.append("\t");
      _builder.append("/**");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* Calculate code for hashing based on member contents");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("*");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("* @return The calculated hash code");
      _builder.newLine();
      _builder.append("\t ");
      _builder.append("*/");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("@Override");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("public int hashCode() {");
      _builder.newLine();
      {
        boolean _hasExtendsDeclaration_5 = this._javaTypeUtil.hasExtendsDeclaration(complexType);
        if (_hasExtendsDeclaration_5) {
          _builder.append("\t\t");
          _builder.append("int result = super.hashCode();");
          _builder.newLine();
        } else {
          _builder.append("\t\t");
          _builder.append("int result = 1;");
          _builder.newLine();
        }
      }
      {
        EList<FField> _members_8 = this._javaTypeUtil.getMembers(complexType);
        boolean _isEmpty_2 = _members_8.isEmpty();
        boolean _not_3 = (!_isEmpty_2);
        if (_not_3) {
          _builder.append("\t\t");
          _builder.append("final int prime = 31;");
          _builder.newLine();
        }
      }
      {
        EList<FField> _members_9 = this._javaTypeUtil.getMembers(complexType);
        for(final FField member_11 : _members_9) {
          {
            boolean _or_1 = false;
            FTypeRef _type_7 = member_11.getType();
            boolean _isByteBuffer_1 = this._javaTypeUtil.isByteBuffer(_type_7);
            if (_isByteBuffer_1) {
              _or_1 = true;
            } else {
              boolean _isArray_7 = this._javaTypeUtil.isArray(member_11);
              _or_1 = _isArray_7;
            }
            if (_or_1) {
              _builder.append("\t\t");
              _builder.append("result = prime * result + ((this.");
              String _joynrName_31 = this._namingUtil.joynrName(member_11);
              _builder.append(_joynrName_31, "\t\t");
              _builder.append(" == null) ? 0 : java.util.Arrays.hashCode(this.");
              String _joynrName_32 = this._namingUtil.joynrName(member_11);
              _builder.append(_joynrName_32, "\t\t");
              _builder.append("));");
              _builder.newLineIfNotEmpty();
            } else {
              _builder.append("\t\t");
              _builder.append("result = prime * result + ((this.");
              String _joynrName_33 = this._namingUtil.joynrName(member_11);
              _builder.append(_joynrName_33, "\t\t");
              _builder.append(" == null) ? 0 : this.");
              String _joynrName_34 = this._namingUtil.joynrName(member_11);
              _builder.append(_joynrName_34, "\t\t");
              _builder.append(".hashCode());");
              _builder.newLineIfNotEmpty();
            }
          }
        }
      }
      _builder.append("\t\t");
      _builder.append("return result;");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("}");
      _builder.newLine();
      _builder.append("}");
      _builder.newLine();
      _builder.newLine();
      _builder.append("\t");
      _builder.newLine();
      _xblockexpression = _builder;
    }
    return _xblockexpression;
  }
}
