package io.joynr.generator.communicationmodel;

import com.google.inject.Inject;
import io.joynr.generator.communicationmodel.ComplexTypeTemplate;
import io.joynr.generator.communicationmodel.EnumTypeTemplate;
import io.joynr.generator.communicationmodel.MapTypeTemplate;
import io.joynr.generator.templates.util.NamingUtil;
import io.joynr.generator.templates.util.TypeUtil;
import io.joynr.generator.util.JoynrJavaGeneratorExtensions;
import java.io.File;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.xbase.lib.Extension;
import org.franca.core.franca.FCompoundType;
import org.franca.core.franca.FEnumerationType;
import org.franca.core.franca.FMapType;
import org.franca.core.franca.FModel;

@SuppressWarnings("all")
public class CommunicationModelGenerator {
  @Inject
  @Extension
  private JoynrJavaGeneratorExtensions _joynrJavaGeneratorExtensions;
  
  @Inject
  @Extension
  private TypeUtil _typeUtil;
  
  @Inject
  @Extension
  private NamingUtil _namingUtil;
  
  @Inject
  private MapTypeTemplate mapTemplate;
  
  @Inject
  private EnumTypeTemplate enumTemplate;
  
  @Inject
  private ComplexTypeTemplate complexTypeTemplate;
  
  public void doGenerate(final FModel fModel, final IFileSystemAccess fsa) {
    Iterable<FCompoundType> _compoundDataTypes = this._joynrJavaGeneratorExtensions.getCompoundDataTypes(fModel);
    for (final FCompoundType type : _compoundDataTypes) {
      {
        String _packagePathWithJoynrPrefix = this._joynrJavaGeneratorExtensions.getPackagePathWithJoynrPrefix(type, File.separator);
        String path = (_packagePathWithJoynrPrefix + File.separator);
        boolean _isPartOfTypeCollection = this._typeUtil.isPartOfTypeCollection(type);
        if (_isPartOfTypeCollection) {
          String _path = path;
          String _typeCollectionName = this._typeUtil.getTypeCollectionName(type);
          String _plus = (_typeCollectionName + File.separator);
          path = (_path + _plus);
        }
        String _joynrName = this._namingUtil.joynrName(type);
        String _plus_1 = (path + _joynrName);
        String _plus_2 = (_plus_1 + ".java");
        this._joynrJavaGeneratorExtensions.generateFile(fsa, _plus_2, 
          this.complexTypeTemplate, type);
      }
    }
    Iterable<FEnumerationType> _enumDataTypes = this._joynrJavaGeneratorExtensions.getEnumDataTypes(fModel);
    for (final FEnumerationType type_1 : _enumDataTypes) {
      {
        String _packagePathWithJoynrPrefix = this._joynrJavaGeneratorExtensions.getPackagePathWithJoynrPrefix(type_1, File.separator);
        String path = (_packagePathWithJoynrPrefix + File.separator);
        boolean _isPartOfTypeCollection = this._typeUtil.isPartOfTypeCollection(type_1);
        if (_isPartOfTypeCollection) {
          String _path = path;
          String _typeCollectionName = this._typeUtil.getTypeCollectionName(type_1);
          String _plus = (_typeCollectionName + File.separator);
          path = (_path + _plus);
        }
        String _joynrName = this._namingUtil.joynrName(type_1);
        String _plus_1 = (path + _joynrName);
        String _plus_2 = (_plus_1 + ".java");
        this._joynrJavaGeneratorExtensions.generateFile(fsa, _plus_2, 
          this.enumTemplate, type_1);
      }
    }
    Iterable<FMapType> _mapDataTypes = this._joynrJavaGeneratorExtensions.getMapDataTypes(fModel);
    for (final FMapType type_2 : _mapDataTypes) {
      {
        String _packagePathWithJoynrPrefix = this._joynrJavaGeneratorExtensions.getPackagePathWithJoynrPrefix(type_2, File.separator);
        String path = (_packagePathWithJoynrPrefix + File.separator);
        boolean _isPartOfTypeCollection = this._typeUtil.isPartOfTypeCollection(type_2);
        if (_isPartOfTypeCollection) {
          String _path = path;
          String _typeCollectionName = this._typeUtil.getTypeCollectionName(type_2);
          String _plus = (_typeCollectionName + File.separator);
          path = (_path + _plus);
        }
        String _joynrName = this._namingUtil.joynrName(type_2);
        String _plus_1 = (path + _joynrName);
        String _plus_2 = (_plus_1 + ".java");
        this._joynrJavaGeneratorExtensions.generateFile(fsa, _plus_2, 
          this.mapTemplate, type_2);
      }
    }
  }
}
