package io.joynr.generator;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import io.joynr.generator.AbstractJoynrGenerator;
import io.joynr.generator.communicationmodel.CommunicationModelGenerator;
import io.joynr.generator.filter.FilterGenerator;
import io.joynr.generator.interfaces.InterfaceGenerator;
import io.joynr.generator.provider.ProviderGenerator;
import io.joynr.generator.proxy.ProxyGenerator;
import io.joynr.generator.util.IgnoreSVNFileFilter;
import io.joynr.generator.util.JoynrJavaGeneratorExtensions;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.util.Files;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.franca.core.dsl.FrancaPersistenceManager;
import org.franca.core.franca.FCompoundType;
import org.franca.core.franca.FInterface;
import org.franca.core.franca.FModel;

@SuppressWarnings("all")
public class JoynrJavaGenerator extends AbstractJoynrGenerator {
  @Inject
  private InterfaceGenerator interfacesGenerator;
  
  @Inject
  private CommunicationModelGenerator communicationModelGenerator;
  
  @Inject
  private ProxyGenerator proxyGenerator;
  
  @Inject
  private ProviderGenerator providerGenerator;
  
  @Inject
  private FilterGenerator filterGenerator;
  
  @Inject
  @Extension
  private JoynrJavaGeneratorExtensions _joynrJavaGeneratorExtensions;
  
  @Inject
  private FrancaPersistenceManager francaPersistenceManager;
  
  @Override
  public String getLanguageId() {
    return "java";
  }
  
  /**
   * Triggers the generation. In case the parameter "generate" is set to false, the generator is cleaning the generation folder
   */
  @Override
  public void doGenerate(final Resource input, final IFileSystemAccess fsa) {
    URI _uRI = input.getURI();
    String _fileExtension = _uRI.fileExtension();
    String _fileExtension_1 = this.francaPersistenceManager.getFileExtension();
    final boolean isFrancaIDLResource = _fileExtension.equals(_fileExtension_1);
    Preconditions.checkArgument(isFrancaIDLResource, ("Unknown input: " + input));
    EList<EObject> _contents = input.getContents();
    EObject _get = _contents.get(0);
    final FModel fModel = ((FModel) _get);
    EList<FInterface> _interfaces = fModel.getInterfaces();
    for (final FInterface fInterface : _interfaces) {
      {
        this.interfacesGenerator.doGenerate(fInterface, fsa);
        this.proxyGenerator.doGenerate(fInterface, fsa);
        this.providerGenerator.doGenerate(fInterface, fsa);
        this.filterGenerator.doGenerate(fInterface, fsa);
      }
    }
    this.communicationModelGenerator.doGenerate(fModel, fsa);
  }
  
  public void cleanDirectory(final String path) {
    final File directory = new File(path);
    boolean _exists = directory.exists();
    boolean _not = (!_exists);
    if (_not) {
      directory.mkdirs();
    } else {
      try {
        IgnoreSVNFileFilter _ignoreSVNFileFilter = new IgnoreSVNFileFilter();
        Files.cleanFolder(directory, _ignoreSVNFileFilter, true, false);
      } catch (final Throwable _t) {
        if (_t instanceof FileNotFoundException) {
          final FileNotFoundException e = (FileNotFoundException)_t;
          e.printStackTrace();
        } else {
          throw Exceptions.sneakyThrow(_t);
        }
      }
    }
  }
  
  public Iterable<FInterface> findAllFInterfaces(final Resource resource) {
    final HashSet<FInterface> result = new HashSet<FInterface>();
    final ResourceSet rs = resource.getResourceSet();
    EList<Resource> _resources = rs.getResources();
    for (final Resource r : _resources) {
      EList<EObject> _contents = r.getContents();
      for (final EObject c : _contents) {
        if ((c instanceof FModel)) {
          EList<FInterface> _interfaces = ((FModel)c).getInterfaces();
          result.addAll(_interfaces);
        }
      }
    }
    return result;
  }
  
  public Iterable<FCompoundType> findAllComplexTypes(final Resource resource) {
    final HashSet<FCompoundType> result = new HashSet<FCompoundType>();
    final ResourceSet rs = resource.getResourceSet();
    EList<Resource> _resources = rs.getResources();
    for (final Resource r : _resources) {
      EList<EObject> _contents = r.getContents();
      for (final EObject c : _contents) {
        if ((c instanceof FModel)) {
          Iterable<FCompoundType> _compoundDataTypes = this._joynrJavaGeneratorExtensions.getCompoundDataTypes(((FModel)c));
          Iterables.<FCompoundType>addAll(result, _compoundDataTypes);
        }
      }
    }
    return result;
  }
  
  @Override
  public void setParameters(final Map<String, String> parameter) {
  }
  
  @Override
  public Set<String> supportedParameters() {
    return Sets.<String>newHashSet();
  }
}
