/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.array.internal;

import io.hypersistence.utils.hibernate.type.array.internal.AbstractArrayTypeDescriptor;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcType;

public class ArraySqlTypeDescriptor
implements JdbcType {
    public static final ArraySqlTypeDescriptor INSTANCE = new ArraySqlTypeDescriptor();

    public int getJdbcTypeCode() {
        return 2003;
    }

    public <X> ValueBinder<X> getBinder(final JavaType<X> javaType) {
        return new BasicBinder<X>(javaType, this){

            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                AbstractArrayTypeDescriptor abstractArrayTypeDescriptor = (AbstractArrayTypeDescriptor)javaType;
                st.setArray(index, st.getConnection().createArrayOf(abstractArrayTypeDescriptor.getSqlArrayType(), abstractArrayTypeDescriptor.unwrap(value, Object[].class, options)));
            }

            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                throw new UnsupportedOperationException("Binding by name is not supported!");
            }
        };
    }

    public <X> ValueExtractor<X> getExtractor(final JavaType<X> javaType) {
        return new BasicExtractor<X>(javaType, this){

            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                return javaType.wrap((Object)rs.getArray(paramIndex), options);
            }

            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return javaType.wrap((Object)statement.getArray(index), options);
            }

            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return javaType.wrap((Object)statement.getArray(name), options);
            }
        };
    }
}

