/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security.webserver;

import io.helidon.common.CollectionsHelper;
import io.helidon.common.http.Http;
import io.helidon.config.Config;
import io.helidon.security.EndpointConfig;
import io.helidon.security.Security;
import io.helidon.security.SecurityContext;
import io.helidon.security.SecurityEnvironment;
import io.helidon.security.webserver.SecurityHandler;
import io.helidon.webserver.Handler;
import io.helidon.webserver.Routing;
import io.helidon.webserver.ServerRequest;
import io.helidon.webserver.ServerResponse;
import io.helidon.webserver.Service;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;

public final class WebSecurity
implements Service {
    public static final String CONTEXT_ADD_HEADERS = "security.addHeaders";
    private static final AtomicInteger SECURITY_COUNTER = new AtomicInteger();
    private final Security security;
    private final Config config;
    private final SecurityHandler defaultHandler;

    private WebSecurity(Security security, Config config) {
        this(security, config, SecurityHandler.newInstance());
    }

    private WebSecurity(Security security, Config config, SecurityHandler defaultHandler) {
        this.security = security;
        this.config = config;
        this.defaultHandler = defaultHandler;
    }

    public static WebSecurity from(Security security) {
        return new WebSecurity(security, null);
    }

    public static WebSecurity from(Config config) {
        Security security = Security.fromConfig((Config)config);
        return WebSecurity.from(security, config);
    }

    public static WebSecurity from(Security security, Config config) {
        return new WebSecurity(security, config);
    }

    public static SecurityHandler secure() {
        return SecurityHandler.newInstance().authenticate().authorize();
    }

    public static SecurityHandler authenticate() {
        return SecurityHandler.newInstance().authenticate();
    }

    public static SecurityHandler audit() {
        return SecurityHandler.newInstance().audit();
    }

    public static SecurityHandler authenticator(String explicitAuthenticator) {
        return SecurityHandler.newInstance().authenticate().authenticator(explicitAuthenticator);
    }

    public static SecurityHandler authorizer(String explicitAuthorizer) {
        return SecurityHandler.newInstance().authenticate().authorize().authorizer(explicitAuthorizer);
    }

    public static SecurityHandler rolesAllowed(String ... roles) {
        return SecurityHandler.newInstance().rolesAllowed(roles);
    }

    public static SecurityHandler allowAnonymous() {
        return SecurityHandler.newInstance().authenticate().authenticationOptional();
    }

    public static SecurityHandler authorize() {
        return SecurityHandler.newInstance().authorize();
    }

    public static SecurityHandler enforce() {
        return SecurityHandler.newInstance();
    }

    public WebSecurity securityDefaults(SecurityHandler defaultHandler) {
        Objects.requireNonNull(defaultHandler, "Default security handler must not be null");
        return new WebSecurity(this.security, this.config, defaultHandler);
    }

    public void update(Routing.Rules routing) {
        routing.any(new Handler[]{this::registerContext});
        if (null != this.config) {
            this.registerRouting(routing);
        }
    }

    private void registerContext(ServerRequest req, ServerResponse res) {
        HashMap allHeaders = new HashMap(req.headers().toMap());
        Optional newHeaders = req.context().get((Object)CONTEXT_ADD_HEADERS, Map.class);
        newHeaders.ifPresent(allHeaders::putAll);
        if (!req.context().get(SecurityContext.class).isPresent()) {
            SecurityEnvironment env = this.security.environmentBuilder().targetUri(req.uri()).path(req.path().toString()).method(req.method().name()).addAttribute("userIp", (Object)req.remoteAddress()).addAttribute("userPort", (Object)req.remotePort()).transport(req.isSecure() ? "https" : "http").headers(allHeaders).build();
            EndpointConfig ec = EndpointConfig.builder().build();
            SecurityContext context = this.security.contextBuilder(String.valueOf(SECURITY_COUNTER.incrementAndGet())).tracingSpan(req.spanContext()).env(env).endpointConfig(ec).build();
            req.context().register((Object)context);
            req.context().register((Object)this.defaultHandler);
        }
        req.next();
    }

    private void registerRouting(Routing.Rules routing) {
        Config wsConfig = this.config.get("security.web-server");
        SecurityHandler defaults = SecurityHandler.from(wsConfig.get("defaults"), this.defaultHandler);
        wsConfig.get("paths").nodeList().ifPresent(configs -> {
            for (Config pathConfig : configs) {
                List methods = pathConfig.get("methods").mapList(Http.RequestMethod::from, CollectionsHelper.listOf());
                String path = (String)pathConfig.get("path").value().orElseThrow(() -> new SecurityException(pathConfig.key() + " must contain path key with a path to register to web server"));
                if (methods.isEmpty()) {
                    routing.any(path, new Handler[]{SecurityHandler.from(pathConfig, defaults)});
                    continue;
                }
                routing.anyOf((Iterable)methods, path, new Handler[]{SecurityHandler.from(pathConfig, defaults)});
            }
        });
    }
}

