/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.mp;

import io.helidon.config.Config;
import io.helidon.config.ConfigException;
import io.helidon.config.MutabilitySupport;
import io.helidon.config.mp.MpEnvironmentVariablesSource;
import io.helidon.config.mp.MpHelidonConfigSource;
import io.helidon.config.mp.MpHelidonSource;
import io.helidon.config.mp.MpMapSource;
import io.helidon.config.mp.MpSystemPropertiesSource;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import org.eclipse.microprofile.config.spi.ConfigSource;

public final class MpConfigSources {
    private MpConfigSources() {
    }

    public static ConfigSource create(String name, Map<String, String> theMap) {
        return new MpMapSource(name, theMap);
    }

    public static ConfigSource create(Map<String, String> theMap) {
        return MpConfigSources.create("Map", theMap);
    }

    public static ConfigSource create(Path path) {
        return MpConfigSources.create(path.toString(), path);
    }

    public static ConfigSource create(URL url) {
        ConfigSource configSource;
        block8: {
            String name = url.toString();
            URLConnection urlConnection = url.openConnection();
            InputStream inputStream = urlConnection.getInputStream();
            try {
                Properties properties = new Properties();
                properties.load(inputStream);
                configSource = MpConfigSources.create(name, properties);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new ConfigException("Failed to load ", (Throwable)e);
                }
            }
            inputStream.close();
        }
        return configSource;
    }

    public static ConfigSource create(URL url, URL profileUrl) {
        ConfigSource defaultSource = MpConfigSources.create(url);
        ConfigSource profileSource = MpConfigSources.create(profileUrl);
        return MpConfigSources.composite(profileSource, defaultSource);
    }

    public static ConfigSource create(String name, Path path) {
        Properties props = new Properties();
        try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
            props.load(in);
        }
        catch (IOException e) {
            throw new ConfigException("Failed to read properties from " + path.toAbsolutePath());
        }
        if ("true".equals(props.getProperty("helidon.config.polling.enabled"))) {
            String durationString = props.getProperty("helidon.config.polling.duration");
            Duration duration = durationString == null ? Duration.ofSeconds(10L) : Duration.parse(durationString);
            MutabilitySupport.poll((Path)path, (Duration)duration, changed -> MpConfigSources.update(path, props), changed -> props.clear());
        } else if ("true".equals(props.getProperty("helidon.config.watcher.enabled"))) {
            MutabilitySupport.watch((Path)path, changed -> MpConfigSources.update(path, props), changed -> props.clear());
        }
        return MpConfigSources.create(name, props);
    }

    public static ConfigSource create(Properties properties) {
        return MpConfigSources.create("Properties", properties);
    }

    public static ConfigSource create(String name, Properties properties) {
        Properties map = properties;
        return new MpMapSource(name, map);
    }

    public static ConfigSource environmentVariables() {
        return new MpEnvironmentVariablesSource();
    }

    public static ConfigSource systemProperties() {
        return new MpSystemPropertiesSource();
    }

    public static List<ConfigSource> classPath(String resource) {
        return MpConfigSources.classPath(Thread.currentThread().getContextClassLoader(), resource);
    }

    public static List<ConfigSource> classPath(String resource, String profile) {
        return MpConfigSources.classPath(Thread.currentThread().getContextClassLoader(), resource, profile);
    }

    public static List<ConfigSource> classPath(ClassLoader classLoader, String resource) {
        LinkedList<ConfigSource> sources = new LinkedList<ConfigSource>();
        try {
            classLoader.getResources(resource).asIterator().forEachRemaining(it -> sources.add(MpConfigSources.create(it)));
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read \"" + resource + "\" from classpath", e);
        }
        return sources;
    }

    public static List<ConfigSource> classPath(ClassLoader classLoader, String resource, String profile) {
        Objects.requireNonNull(profile, "Profile must be defined");
        LinkedList<ConfigSource> sources = new LinkedList<ConfigSource>();
        try {
            Enumeration<URL> baseResources = classLoader.getResources(resource);
            Enumeration<URL> profileResources = classLoader.getResources(MpConfigSources.toProfileResource(resource, profile));
            if (profileResources.hasMoreElements()) {
                LinkedList profileResourceList = new LinkedList();
                profileResources.asIterator().forEachRemaining(profileResourceList::add);
                baseResources.asIterator().forEachRemaining(it -> {
                    String pathBase = MpConfigSources.pathBase(it.toString());
                    for (URL url : profileResourceList) {
                        String profilePathBase = MpConfigSources.pathBase(url.toString());
                        if (pathBase.equals(profilePathBase)) {
                            sources.add(MpConfigSources.create(it, url));
                            continue;
                        }
                        sources.add(MpConfigSources.create(it));
                    }
                });
            } else {
                baseResources.asIterator().forEachRemaining(it -> sources.add(MpConfigSources.create(it)));
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read \"" + resource + "\" from classpath", e);
        }
        return sources;
    }

    public static ConfigSource create(io.helidon.config.spi.ConfigSource helidonConfigSource) {
        return MpHelidonSource.create(helidonConfigSource);
    }

    public static ConfigSource create(Config config) {
        return new MpHelidonConfigSource(Objects.requireNonNull(config, "Config cannot be null"));
    }

    static ConfigSource composite(final ConfigSource main, final ConfigSource fallback) {
        final String name = main.getName() + " (" + fallback.getName() + ")";
        return new ConfigSource(){

            public Set<String> getPropertyNames() {
                HashSet<String> result = new HashSet<String>(fallback.getPropertyNames());
                result.addAll(main.getPropertyNames());
                return result;
            }

            public String getValue(String propertyName) {
                String value = main.getValue(propertyName);
                if (value == null) {
                    return fallback.getValue(propertyName);
                }
                return value;
            }

            public String getName() {
                return name;
            }

            public Map<String, String> getProperties() {
                HashMap<String, String> result = new HashMap<String, String>(fallback.getProperties());
                result.putAll(main.getProperties());
                return result;
            }
        };
    }

    private static String pathBase(String path) {
        int i = path.lastIndexOf(47);
        int y = path.lastIndexOf(33);
        int z = path.lastIndexOf(58);
        int b = path.lastIndexOf(92);
        int max = Math.max(i, y);
        max = Math.max(max, z);
        if ((max = Math.max(max, b)) > -1) {
            return path.substring(0, max);
        }
        return path;
    }

    private static String toProfileResource(String resource, String profile) {
        int i = resource.lastIndexOf(46);
        if (i > -1) {
            return resource.substring(0, i) + "-" + profile + resource.substring(i);
        }
        return resource + "-" + profile;
    }

    private static void update(Path path, Properties originalProperties) {
        Properties props = new Properties();
        try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
            props.load(in);
        }
        catch (IOException e) {
            throw new ConfigException("Failed to read properties from " + path.toAbsolutePath());
        }
        originalProperties.keySet().removeIf(it -> !props.containsKey(it));
        originalProperties.putAll((Map<?, ?>)props);
    }
}

