/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.mp;

import io.helidon.config.mp.ConfigValueImpl;
import io.helidon.config.mp.spi.MpConfigFilter;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigValue;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.Converter;

class MpConfigImpl
implements Config {
    private static final Logger LOGGER = Logger.getLogger(MpConfigImpl.class.getName());
    private static final String REGEX_REFERENCE = "(?<!\\\\)\\$\\{([^${}:]+)(:[^$}]*)?}";
    private static final Pattern PATTERN_REFERENCE = Pattern.compile("(?<!\\\\)\\$\\{([^${}:]+)(:[^$}]*)?}");
    private static final String REGEX_BACKSLASH = "\\\\(?=\\$\\{([^}]+)})";
    private static final Pattern PATTERN_BACKSLASH = Pattern.compile("\\\\(?=\\$\\{([^}]+)})");
    private static final ThreadLocal<Set<String>> UNRESOLVED_KEYS = ThreadLocal.withInitial(HashSet::new);
    private static final Pattern SPLIT_PATTERN = Pattern.compile("(?<!\\\\),");
    private static final Pattern ESCAPED_COMMA_PATTERN = Pattern.compile("\\,", 16);
    private static final Map<Class<?>, Class<?>> REPLACED_TYPES = new HashMap();
    private final List<ConfigSource> sources = new LinkedList<ConfigSource>();
    private final HashMap<Class<?>, Converter<?>> converters = new LinkedHashMap();
    private final boolean valueResolving;
    private final List<MpConfigFilter> filters = new ArrayList<MpConfigFilter>();
    private final String configProfile;

    MpConfigImpl(List<ConfigSource> sources, HashMap<Class<?>, Converter<?>> converters, List<MpConfigFilter> filters, String profile) {
        this.sources.addAll(sources);
        this.converters.putAll(converters);
        this.converters.putIfAbsent(String.class, (Converter & Serializable)value -> value);
        this.configProfile = profile;
        this.valueResolving = this.getOptionalValue("mp.config.property.expressions.enabled", Boolean.class).or(() -> this.getOptionalValue("helidon.config.value-resolving.enabled", Boolean.class)).orElse(true);
        filters.forEach(it -> {
            it.init(this);
            this.filters.add((MpConfigFilter)it);
        });
    }

    public ConfigValue getConfigValue(String key) {
        if (this.configProfile == null) {
            return this.findConfigValue(key).orElseGet(() -> new ConfigValueImpl(key, null, null, null, 0));
        }
        return this.findConfigValue("%" + this.configProfile + "." + key).or(() -> this.findConfigValue(key)).orElseGet(() -> new ConfigValueImpl(key, null, null, null, 0));
    }

    public <T> T getValue(String propertyName, Class<T> propertyType) {
        return this.getOptionalValue(propertyName, propertyType).orElseThrow(() -> new NoSuchElementException("Property \"" + propertyName + "\" is not available in configuration"));
    }

    public <T> Optional<T> getOptionalValue(String propertyName, Class<T> propertyType) {
        if (this.configProfile == null) {
            return this.optionalValue(propertyName, propertyType);
        }
        return this.optionalValue("%" + this.configProfile + "." + propertyName, propertyType).or(() -> this.optionalValue(propertyName, propertyType));
    }

    private <T> Optional<T> optionalValue(String propertyName, Class<T> propertyType) {
        if (propertyType.isArray()) {
            Class<?> componentType = propertyType.getComponentType();
            Optional<String> optionalValue = this.getOptionalValue(propertyName, String.class);
            if (optionalValue.isPresent()) {
                try {
                    return Optional.of(this.toArray(propertyName, optionalValue.get(), componentType));
                }
                catch (NoSuchElementException e) {
                    return Optional.empty();
                }
            }
            String indexedConfigKey = propertyName + ".0";
            optionalValue = this.getOptionalValue(indexedConfigKey, String.class);
            if (optionalValue.isPresent()) {
                LinkedList result = new LinkedList();
                result.add(this.convert(indexedConfigKey, componentType, optionalValue.get()));
                for (int i = 1; i < 1000 && (optionalValue = this.getOptionalValue(indexedConfigKey = propertyName + "." + i, String.class)).isPresent(); ++i) {
                    result.add(this.convert(indexedConfigKey, componentType, optionalValue.get()));
                }
                Object array = Array.newInstance(componentType, result.size());
                for (int i = 0; i < result.size(); ++i) {
                    Object component = result.get(i);
                    Array.set(array, i, component);
                }
                return Optional.of(array);
            }
            return Optional.empty();
        }
        return this.findConfigValue(propertyName).map(ConfigValue::getValue).map(it -> this.convert(propertyName, propertyType, (String)it));
    }

    public Iterable<String> getPropertyNames() {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        for (ConfigSource source : this.sources) {
            names.addAll(source.getPropertyNames());
        }
        return names;
    }

    public Iterable<ConfigSource> getConfigSources() {
        return Collections.unmodifiableList(this.sources);
    }

    public <T> T unwrap(Class<T> aClass) {
        if (this.getClass().equals(aClass)) {
            return aClass.cast(this);
        }
        if (aClass.equals(Config.class)) {
            return aClass.cast(this);
        }
        throw new UnsupportedOperationException("Cannot unwrap config into " + aClass.getName());
    }

    public <T> Optional<Converter<T>> getConverter(Class<T> forType) {
        if (forType.isArray()) {
            Class<?> componentType = forType.getComponentType();
            return this.findComponentConverter(componentType).map(it -> this.toArrayConverter(forType, componentType, (Converter<?>)it));
        }
        return this.findComponentConverter(forType);
    }

    private <T> Optional<Converter<T>> findComponentConverter(Class<T> type) {
        Class forType = this.mapType(type);
        return this.converters.entrySet().stream().filter(it -> forType.isAssignableFrom((Class)it.getKey())).findFirst().map(Map.Entry::getValue).map(it -> it).or(() -> this.findImplicit(forType));
    }

    private <T> Class<T> mapType(Class<T> original) {
        Class<?> aClass = REPLACED_TYPES.get(original);
        return aClass == null ? original : aClass;
    }

    private <T> Converter<T> toArrayConverter(Class<T> type, Class<?> componentType, Converter<?> elementConverter) {
        return (Converter & Serializable)configValue -> {
            if (configValue == null) {
                throw new NullPointerException("Null not allowed in MP converters. Converter for type " + type.getName());
            }
            String[] values = MpConfigImpl.toArray(configValue);
            Object array = Array.newInstance(componentType, values.length);
            for (int i = 0; i < values.length; ++i) {
                String value = values[i];
                Array.set(array, i, elementConverter.convert(value));
            }
            return type.cast(array);
        };
    }

    private <T> T convert(String propertyName, Class<T> type, String value) {
        try {
            return (T)this.obtainConverter(type).convert(value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to convert property \"" + propertyName + "\" from its value \"" + value + "\" to " + type.getName(), e);
        }
    }

    private Optional<ConfigValue> findConfigValue(String propertyName) {
        for (ConfigSource source : this.sources) {
            String value = source.getValue(propertyName);
            if (null == value) continue;
            if (value.isEmpty()) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("Found property " + propertyName + " in source " + source.getName() + " and it is empty (removed)");
                }
                return Optional.empty();
            }
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("Found property " + propertyName + " in source " + source.getName());
            }
            String rawValue = value;
            return this.applyFilters(propertyName, value).map(it -> this.resolveReferences(propertyName, (String)it)).map(it -> new ConfigValueImpl(propertyName, (String)it, rawValue, source.getName(), source.getOrdinal()));
        }
        return Optional.empty();
    }

    private Optional<String> applyFilters(String propertyName, String stringValue) {
        String result = stringValue;
        for (MpConfigFilter filter : this.filters) {
            result = filter.apply(propertyName, result);
        }
        return Optional.ofNullable(result);
    }

    private Object toArray(String propertyName, String stringValue, Class<?> componentType) {
        String[] values = MpConfigImpl.toArray(stringValue);
        Object array = Array.newInstance(componentType, values.length);
        for (int i = 0; i < values.length; ++i) {
            String value = values[i];
            Array.set(array, i, this.convert(propertyName, componentType, value));
        }
        return array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String resolveReferences(String key, String value) {
        if (!this.valueResolving) {
            return value;
        }
        if (!UNRESOLVED_KEYS.get().add(key)) {
            UNRESOLVED_KEYS.get().clear();
            throw new IllegalArgumentException("Recursive resolving of references for key " + key + ", value: " + value);
        }
        try {
            String string = value.contains("${") ? this.processExpressions(value) : value;
            return string;
        }
        finally {
            UNRESOLVED_KEYS.get().remove(key);
        }
    }

    private String processExpressions(String value) {
        String current;
        if (value.equals("${EMPTY}")) {
            return "";
        }
        int iteration = 0;
        String replaced = value;
        do {
            if (iteration > 4) {
                throw new IllegalArgumentException("Too many iterations on property expression. Original value: " + value + ", currentValue: " + replaced);
            }
            current = replaced;
            replaced = this.format(current);
            ++iteration;
        } while (!replaced.equals(current));
        Matcher m = PATTERN_BACKSLASH.matcher(replaced);
        return m.replaceAll("");
    }

    private String format(String value) {
        Matcher m = PATTERN_REFERENCE.matcher(value);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String propertyName = m.group(1);
            Optional<String> propertyValue = this.getOptionalValue(propertyName, String.class);
            String defaultValue = m.group(2);
            String finalValue = defaultValue == null ? propertyValue.orElseThrow(() -> new NoSuchElementException("Property " + propertyName + " used in expression " + value + " does not exist")) : propertyValue.orElse(defaultValue.substring(1));
            m.appendReplacement(sb, Matcher.quoteReplacement(finalValue));
        }
        m.appendTail(sb);
        return sb.toString();
    }

    <T> Converter<T> obtainConverter(Class<T> type) {
        return this.getConverter(type).orElseGet(() -> new FailingConverter(type));
    }

    private <T> Optional<Converter<T>> findImplicit(Class<T> type) {
        if (Enum.class.isAssignableFrom(type)) {
            return Optional.of((Converter & Serializable)value -> {
                Class enumClass = type;
                return Enum.valueOf(enumClass, value);
            });
        }
        Optional<Method> method = this.findMethod(type, "of", String.class).or(() -> this.findMethod(type, "valueOf", String.class)).or(() -> this.findMethod(type, "parse", CharSequence.class)).or(() -> this.findMethod(type, "parse", String.class));
        if (method.isPresent()) {
            Method m = method.get();
            return Optional.of((Converter & Serializable)value -> {
                try {
                    return m.invoke(null, value);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Failed to convert to " + type.getName() + " using a static method", e);
                }
            });
        }
        try {
            Constructor constructor = type.getConstructor(String.class);
            if (constructor.canAccess(null)) {
                return Optional.of((Converter & Serializable)value -> {
                    try {
                        return constructor.newInstance(value);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Failed to convert to " + type.getName() + " using a constructor", e);
                    }
                });
            }
            LOGGER.finest("Constructor with String parameter is not accessible on type " + type);
        }
        catch (NoSuchMethodException e) {
            LOGGER.log(Level.FINEST, "There is no public constructor with string parameter on class " + type.getName(), e);
        }
        return Optional.empty();
    }

    private Optional<Method> findMethod(Class<?> type, String name, Class<?> ... parameterTypes) {
        try {
            Method result = type.getDeclaredMethod(name, parameterTypes);
            if (!result.canAccess(null)) {
                LOGGER.finest(() -> "Method " + name + "(" + Arrays.toString(parameterTypes) + ") is not accessible on class " + type.getName());
                return Optional.empty();
            }
            if (!Modifier.isStatic(result.getModifiers())) {
                LOGGER.finest(() -> "Method " + name + "(" + Arrays.toString(parameterTypes) + ") is not static on class " + type.getName());
                return Optional.empty();
            }
            return Optional.of(result);
        }
        catch (NoSuchMethodException e) {
            LOGGER.log(Level.FINEST, "Method " + name + "(" + Arrays.toString(parameterTypes) + ") is not avilable on class " + type.getName(), e);
            return Optional.empty();
        }
    }

    HashMap<Class<?>, Converter<?>> converters() {
        return this.converters;
    }

    static String[] toArray(String stringValue) {
        String[] values = SPLIT_PATTERN.split(stringValue, -1);
        ArrayList<String> result = new ArrayList<String>(values.length);
        for (String s : values) {
            String value = ESCAPED_COMMA_PATTERN.matcher(s).replaceAll(Matcher.quoteReplacement(","));
            if (value.isEmpty()) continue;
            result.add(value);
        }
        if (result.isEmpty()) {
            throw new NoSuchElementException("Value " + stringValue + " resolved into an empty array");
        }
        return result.toArray(new String[0]);
    }

    static {
        REPLACED_TYPES.put(Byte.TYPE, Byte.class);
        REPLACED_TYPES.put(Short.TYPE, Short.class);
        REPLACED_TYPES.put(Integer.TYPE, Integer.class);
        REPLACED_TYPES.put(Long.TYPE, Long.class);
        REPLACED_TYPES.put(Float.TYPE, Float.class);
        REPLACED_TYPES.put(Double.TYPE, Double.class);
        REPLACED_TYPES.put(Boolean.TYPE, Boolean.class);
        REPLACED_TYPES.put(Character.TYPE, Character.class);
    }

    private static class FailingConverter<T>
    implements Converter<T> {
        private final Class<T> type;

        private FailingConverter(Class<T> type) {
            this.type = type;
        }

        public T convert(String value) {
            throw new IllegalArgumentException("Cannot convert \"" + value + "\" to type " + this.type.getName());
        }
    }
}

