/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.pki;

import io.helidon.common.pki.PkiException;
import java.io.IOException;
import java.math.BigInteger;
import java.security.spec.KeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;

final class DerUtils {
    private DerUtils() {
    }

    static void checkEnabled() {
        Module myModule;
        Module javaBase = String.class.getModule();
        if (!javaBase.isExported("sun.security.util", myModule = DerUtils.class.getModule())) {
            throw new PkiException("Cannot read PKCS#1 key specification, as package sun.security.util is not exported to this module. Please add --add-exports java.base/sun.security.util=io.helidon.common.pki to java command line options");
        }
    }

    static KeySpec pkcs1RsaKeySpec(byte[] bytes) {
        try {
            DerInputStream derReader = new DerInputStream(bytes);
            DerValue[] seq = derReader.getSequence(0);
            BigInteger modulus = seq[1].getBigInteger();
            BigInteger publicExp = seq[2].getBigInteger();
            BigInteger privateExp = seq[3].getBigInteger();
            BigInteger prime1 = seq[4].getBigInteger();
            BigInteger prime2 = seq[5].getBigInteger();
            BigInteger exp1 = seq[6].getBigInteger();
            BigInteger exp2 = seq[7].getBigInteger();
            BigInteger crtCoef = seq[8].getBigInteger();
            return new RSAPrivateCrtKeySpec(modulus, publicExp, privateExp, prime1, prime2, exp1, exp2, crtCoef);
        }
        catch (IOException e) {
            throw new PkiException("Failed to get PKCS#1 RSA key spec", e);
        }
    }
}

