/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web.auth;

import io.hawt.system.AuthHelpers;
import io.hawt.system.AuthenticateResult;
import io.hawt.system.Authenticator;
import io.hawt.web.ServletHelpers;
import io.hawt.web.auth.AuthSessionHelpers;
import io.hawt.web.auth.AuthenticationConfiguration;
import io.hawt.web.auth.Redirector;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jolokia.converter.Converters;
import org.jolokia.converter.json.JsonConvertOptions;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginServlet
extends HttpServlet {
    private static final long serialVersionUID = 187076436862364207L;
    private static final Logger LOG = LoggerFactory.getLogger(LoginServlet.class);
    private static final String LOGIN_PAGE_PATH = "/login";
    protected int timeout;
    protected AuthenticationConfiguration authConfiguration;
    private final Converters converters = new Converters();
    private final JsonConvertOptions options = JsonConvertOptions.DEFAULT;
    private Redirector redirector = new Redirector();

    public void init() {
        this.authConfiguration = AuthenticationConfiguration.getConfiguration(this.getServletContext());
        this.timeout = AuthSessionHelpers.getSessionTimeout(this.getServletContext());
        LOG.info("Hawtio login is using {} sec. HttpSession timeout", (Object)this.timeout);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.authConfiguration.isKeycloakEnabled()) {
            this.redirector.doRedirect(request, response, "/");
        } else {
            this.redirector.doRedirect(request, response, LOGIN_PAGE_PATH);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        AuthSessionHelpers.clear(request, this.authConfiguration, true);
        JSONObject json = ServletHelpers.readObject(request.getReader());
        String username = (String)json.get("username");
        String password = (String)json.get("password");
        AuthenticateResult result = new Authenticator(request, this.authConfiguration, username, password).authenticate(subject -> {
            LOG.info("Logging in user: {}", (Object)AuthHelpers.getUsername(subject));
            AuthSessionHelpers.setup(request.getSession(true), subject, username, this.timeout);
            this.sendResponse(response, (Subject)subject);
        });
        switch (result) {
            case AUTHORIZED: {
                break;
            }
            case NOT_AUTHORIZED: 
            case NO_CREDENTIALS: {
                ServletHelpers.doForbidden(response);
            }
        }
    }

    private void sendResponse(HttpServletResponse response, Subject subject) {
        response.setContentType("application/json");
        try (PrintWriter out = response.getWriter();){
            HashMap answer = new HashMap();
            ArrayList principals = new ArrayList();
            for (Principal principal : subject.getPrincipals()) {
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("type", principal.getClass().getName());
                data.put("name", principal.getName());
                principals.add(data);
            }
            ArrayList credentials = new ArrayList();
            for (Object credential : subject.getPublicCredentials()) {
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("type", credential.getClass().getName());
                data.put("credential", credential);
                credentials.add(data);
            }
            answer.put("principals", principals);
            answer.put("credentials", credentials);
            ServletHelpers.writeObject(this.converters, this.options, out, answer);
        }
        catch (IOException e) {
            LOG.error("Failed to send response", (Throwable)e);
        }
    }

    public void setRedirector(Redirector redirector) {
        this.redirector = redirector;
    }
}

