/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.util;

import io.hawt.util.Closeables;
import io.hawt.util.IOHelper;
import io.hawt.util.Strings;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Files {
    private static final Logger LOG = LoggerFactory.getLogger(Files.class);
    private static final int BUFFER_SIZE = 8192;

    public static void copy(File source, File target) throws IOException {
        if (!source.exists()) {
            throw new FileNotFoundException("Source file not found:" + source.getAbsolutePath());
        }
        if (!(target.exists() || target.getParentFile().exists() || target.getParentFile().mkdirs())) {
            throw new IOException("Can't create target directory:" + target.getParentFile().getAbsolutePath());
        }
        FileInputStream is = new FileInputStream(source);
        FileOutputStream os = new FileOutputStream(target);
        IOHelper.copy(is, os);
    }

    public static int recursiveDelete(File file) {
        File[] files;
        int answer = 0;
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File child : files) {
                answer += Files.recursiveDelete(child);
            }
        }
        if (file.delete()) {
            ++answer;
        }
        return answer;
    }

    public static String getRelativePath(File rootDir, File file) throws IOException {
        String rootPath = rootDir.getCanonicalPath();
        String fullPath = file.getCanonicalPath();
        if (fullPath.startsWith(rootPath)) {
            return fullPath.substring(rootPath.length());
        }
        return fullPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBytes(File file) throws IOException {
        byte[] byArray;
        FileInputStream fis = null;
        ByteArrayOutputStream bos = null;
        if (file == null) {
            throw new FileNotFoundException("No file specified");
        }
        try {
            int remaining;
            fis = new FileInputStream(file);
            bos = new ByteArrayOutputStream();
            byte[] buffer = new byte[8192];
            while ((remaining = fis.read(buffer)) > 0) {
                bos.write(buffer, 0, remaining);
            }
            byArray = bos.toByteArray();
        }
        catch (Throwable throwable) {
            Closeables.closeQuietly(fis);
            Closeables.closeQuietly(bos);
            throw throwable;
        }
        Closeables.closeQuietly(fis);
        Closeables.closeQuietly(bos);
        return byArray;
    }

    public static String getMimeType(File file) {
        try {
            String answer = java.nio.file.Files.probeContentType(file.toPath());
            if (Strings.isNotBlank(answer)) {
                return answer;
            }
        }
        catch (Throwable e) {
            LOG.warn("Could not find mime type of " + file + ". " + e, e);
        }
        if (file.isDirectory()) {
            return "application/zip";
        }
        String fileName = file.getName();
        if (fileName.endsWith(".xml")) {
            return "application/xml";
        }
        if (fileName.endsWith(".wadl")) {
            return "application/wadl+xml";
        }
        if (fileName.endsWith(".wsdl")) {
            return "application/wsdl+xml";
        }
        if (fileName.endsWith(".xsd")) {
            return "application/xsd+xml";
        }
        if (fileName.endsWith(".json")) {
            return "application/json";
        }
        if (fileName.endsWith(".html") || fileName.endsWith(".htm")) {
            return "application/html";
        }
        if (fileName.endsWith(".properties")) {
            return "text/x-java-properties";
        }
        if (fileName.endsWith(".jpg") || fileName.endsWith(".jpeg")) {
            return "image/jpeg";
        }
        if (fileName.endsWith(".png")) {
            return "image/png";
        }
        if (fileName.endsWith(".gif")) {
            return "image/gif";
        }
        if (fileName.endsWith(".svg")) {
            return "image/svg+xml";
        }
        return "text/plain";
    }

    public static void assertExists(File file) {
        if (!file.exists()) {
            throw new IllegalArgumentException(file + " does not exist");
        }
    }

    public static void assertFileExists(File file) {
        Files.assertExists(file);
        if (!file.isFile()) {
            throw new IllegalArgumentException(file + " is not a file!");
        }
    }

    public static void assertDirectoryExists(File file) {
        Files.assertExists(file);
        if (!file.isDirectory()) {
            throw new IllegalArgumentException(file + " is not a directory!");
        }
    }
}

