/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.system;

import io.hawt.system.AuthenticateResult;
import io.hawt.system.Authentication;
import io.hawt.system.Authenticator;
import io.hawt.util.Strings;
import io.hawt.web.auth.AuthenticationConfiguration;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.function.Consumer;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import org.apache.karaf.jaas.boot.principal.ClientPrincipal;
import org.slf4j.Logger;

public abstract class AbstractAuthenticator
implements Authenticator {
    private final Logger log;
    protected HttpServletRequest request;
    protected AuthenticationConfiguration authConfiguration;
    protected String username;
    protected String password;
    protected X509Certificate[] certificates;

    public AbstractAuthenticator(Logger log, HttpServletRequest request, AuthenticationConfiguration authConfiguration, String username, String password) {
        this.log = log;
        this.request = request;
        this.authConfiguration = authConfiguration;
        this.username = username;
        this.password = password;
    }

    public AbstractAuthenticator(Logger log, HttpServletRequest request, AuthenticationConfiguration authConfiguration) {
        this.log = log;
        this.request = request;
        this.authConfiguration = authConfiguration;
        Authentication.extractAuthHeader(request, (username, password) -> {
            this.username = username;
            this.password = password;
        });
        Object certificates = request.getAttribute("javax.servlet.request.X509Certificate");
        if (certificates != null) {
            this.certificates = (X509Certificate[])certificates;
        }
    }

    public boolean isUsernamePasswordSet() {
        return Strings.isNotBlank((String)this.username) && Strings.isNotBlank((String)this.password);
    }

    public boolean hasNoCredentials() {
        return (!this.isUsernamePasswordSet() || this.username.equals("public")) && this.certificates == null;
    }

    @Override
    public final AuthenticateResult authenticate(Consumer<Subject> callback) {
        if (this.hasNoCredentials()) {
            return AuthenticateResult.NO_CREDENTIALS;
        }
        Subject subject = this.doAuthenticate();
        if (subject == null) {
            return AuthenticateResult.NOT_AUTHORIZED;
        }
        if (callback != null) {
            try {
                callback.accept(subject);
            }
            catch (Exception e) {
                this.log.warn("Failed to execute privileged action:", (Throwable)e);
            }
        }
        return AuthenticateResult.AUTHORIZED;
    }

    public final Subject initSubject() {
        Subject subject = new Subject();
        try {
            String addr = this.request.getRemoteHost() + ":" + this.request.getRemotePort();
            subject.getPrincipals().add((Principal)new ClientPrincipal("hawtio", addr));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return subject;
    }

    protected abstract Subject doAuthenticate();
}

