/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.xds.ClientLoadCounter;
import io.grpc.xds.EnvoyProtoData;
import io.grpc.xds.LoadStatsStoreImpl;
import io.grpc.xds.ReferenceCounted;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.endpoint.ClusterStats;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

final class LoadStatsManager {
    private final LoadStatsStoreFactory loadStatsStoreFactory;
    private final Map<String, Map<String, ReferenceCounted<LoadStatsStore>>> loadStatsStores = new HashMap<String, Map<String, ReferenceCounted<LoadStatsStore>>>();

    LoadStatsManager() {
        this(LoadStatsStoreImpl.getDefaultFactory());
    }

    @VisibleForTesting
    LoadStatsManager(LoadStatsStoreFactory factory) {
        this.loadStatsStoreFactory = factory;
    }

    LoadStatsStore addLoadStats(String cluster, @Nullable String clusterService) {
        Map<String, ReferenceCounted<LoadStatsStore>> clusterLoadStatsStores;
        if (!this.loadStatsStores.containsKey(cluster)) {
            this.loadStatsStores.put(cluster, new HashMap());
        }
        if (!(clusterLoadStatsStores = this.loadStatsStores.get(cluster)).containsKey(clusterService)) {
            clusterLoadStatsStores.put(clusterService, ReferenceCounted.wrap(this.loadStatsStoreFactory.newLoadStatsStore(cluster, clusterService)));
        }
        ReferenceCounted<LoadStatsStore> ref = clusterLoadStatsStores.get(clusterService);
        ref.retain();
        return ref.get();
    }

    void removeLoadStats(String cluster, @Nullable String clusterService) {
        Preconditions.checkState((this.loadStatsStores.containsKey(cluster) && this.loadStatsStores.get(cluster).containsKey(clusterService) ? 1 : 0) != 0, (Object)"stats for cluster %s, cluster service %s not exits");
        Map<String, ReferenceCounted<LoadStatsStore>> clusterLoadStatsStores = this.loadStatsStores.get(cluster);
        ReferenceCounted<LoadStatsStore> ref = clusterLoadStatsStores.get(clusterService);
        ref.release();
        if (ref.getReferenceCount() == 0) {
            clusterLoadStatsStores.remove(clusterService);
        }
        if (clusterLoadStatsStores.isEmpty()) {
            this.loadStatsStores.remove(cluster);
        }
    }

    List<ClusterStats> getClusterLoadReports(String cluster) {
        ArrayList<ClusterStats> res = new ArrayList<ClusterStats>();
        Map<String, ReferenceCounted<LoadStatsStore>> clusterLoadStatsStores = this.loadStatsStores.get(cluster);
        if (clusterLoadStatsStores == null) {
            return res;
        }
        for (ReferenceCounted<LoadStatsStore> ref : clusterLoadStatsStores.values()) {
            res.add(ref.get().generateLoadReport());
        }
        return res;
    }

    List<ClusterStats> getAllLoadReports() {
        ArrayList<ClusterStats> res = new ArrayList<ClusterStats>();
        for (Map<String, ReferenceCounted<LoadStatsStore>> clusterLoadStatsStores : this.loadStatsStores.values()) {
            for (ReferenceCounted<LoadStatsStore> ref : clusterLoadStatsStores.values()) {
                res.add(ref.get().generateLoadReport());
            }
        }
        return res;
    }

    static interface LoadStatsStore {
        public ClusterStats generateLoadReport();

        public ClientLoadCounter addLocality(EnvoyProtoData.Locality var1);

        public void removeLocality(EnvoyProtoData.Locality var1);

        public void recordDroppedRequest(String var1);
    }

    @VisibleForTesting
    static interface LoadStatsStoreFactory {
        public LoadStatsStore newLoadStatsStore(String var1, String var2);
    }
}

