/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.protobuf.nano;

import com.google.common.io.ByteStreams;
import com.google.protobuf.nano.CodedOutputByteBufferNano;
import com.google.protobuf.nano.MessageNano;
import io.grpc.DeferredInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nullable;

public class DeferredNanoProtoInputStream
extends DeferredInputStream<MessageNano> {
    @Nullable
    private MessageNano message;
    @Nullable
    private ByteArrayInputStream partial;

    public DeferredNanoProtoInputStream(MessageNano message) {
        this.message = message;
    }

    private void toPartial() {
        if (this.message != null) {
            this.partial = new ByteArrayInputStream(MessageNano.toByteArray((MessageNano)this.message));
            this.message = null;
        }
    }

    public int flushTo(OutputStream target) throws IOException {
        int written = 0;
        this.toPartial();
        if (this.partial != null) {
            written = (int)ByteStreams.copy((InputStream)this.partial, (OutputStream)target);
            this.partial = null;
        }
        return written;
    }

    public int read() throws IOException {
        this.toPartial();
        if (this.partial != null) {
            return this.partial.read();
        }
        return -1;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.message != null) {
            int size = this.message.getSerializedSize();
            if (size == 0) {
                this.message = null;
                this.partial = null;
                return -1;
            }
            if (len >= size) {
                CodedOutputByteBufferNano output = CodedOutputByteBufferNano.newInstance((byte[])b, (int)off, (int)size);
                this.message.writeTo(output);
                output.checkNoSpaceLeft();
                this.message = null;
                this.partial = null;
                return size;
            }
            this.toPartial();
        }
        if (this.partial != null) {
            return this.partial.read(b, off, len);
        }
        return -1;
    }

    public int available() throws IOException {
        if (this.message != null) {
            return this.message.getSerializedSize();
        }
        if (this.partial != null) {
            return this.partial.available();
        }
        return 0;
    }

    @Nullable
    public MessageNano getDeferred() {
        return this.message;
    }
}

