/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.gcp.observability.interceptors;

import com.google.common.base.Preconditions;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.Internal;
import io.grpc.MethodDescriptor;
import java.util.function.BiPredicate;

@Internal
public final class ConditionalClientInterceptor
implements ClientInterceptor {
    private final ClientInterceptor delegate;
    private final BiPredicate<MethodDescriptor<?, ?>, CallOptions> predicate;

    public ConditionalClientInterceptor(ClientInterceptor delegate, BiPredicate<MethodDescriptor<?, ?>, CallOptions> predicate) {
        this.delegate = (ClientInterceptor)Preconditions.checkNotNull((Object)delegate, (Object)"delegate");
        this.predicate = (BiPredicate)Preconditions.checkNotNull(predicate, (Object)"predicate");
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        if (!this.predicate.test(method, callOptions)) {
            return next.newCall(method, callOptions);
        }
        return this.delegate.interceptCall(method, callOptions, next);
    }
}

