/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.inprocess;

import com.google.common.base.Preconditions;
import io.grpc.ServerStreamTracer;
import io.grpc.inprocess.InProcessServer;
import io.grpc.internal.AbstractServerImplBuilder;
import io.grpc.internal.GrpcUtil;
import java.io.File;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class InProcessServerBuilder
extends AbstractServerImplBuilder<InProcessServerBuilder> {
    private final String name;

    public static InProcessServerBuilder forName(String name) {
        return new InProcessServerBuilder(name);
    }

    public static InProcessServerBuilder forPort(int port) {
        throw new UnsupportedOperationException("call forName() instead");
    }

    private InProcessServerBuilder(String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.setStatsRecordStartedRpcs(false);
        this.setStatsRecordFinishedRpcs(false);
        this.handshakeTimeout(Long.MAX_VALUE, TimeUnit.SECONDS);
    }

    @Override
    protected InProcessServer buildTransportServer(List<ServerStreamTracer.Factory> streamTracerFactories) {
        return new InProcessServer(this.name, GrpcUtil.TIMER_SERVICE, streamTracerFactories);
    }

    @Override
    public InProcessServerBuilder useTransportSecurity(File certChain, File privateKey) {
        throw new UnsupportedOperationException("TLS not supported in InProcessServer");
    }
}

