/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.base.Preconditions;
import io.grpc.Status;
import io.grpc.internal.LongCounter;
import io.grpc.internal.LongCounterFactory;
import java.util.concurrent.TimeUnit;

public final class TransportTracer {
    private long streamsStarted;
    private long lastStreamCreatedTimeNanos;
    private long streamsSucceeded;
    private long streamsFailed;
    private long keepAlivesSent;
    private FlowControlReader flowControlWindowReader;
    private long messagesSent;
    private long lastMessageSentTimeNanos;
    private final LongCounter messagesReceived = LongCounterFactory.create();
    private volatile long lastMessageReceivedTimeNanos;

    public Stats getStats() {
        return new Stats(this.streamsStarted, this.lastStreamCreatedTimeNanos, this.streamsSucceeded, this.streamsFailed, this.messagesSent, this.messagesReceived.value(), this.keepAlivesSent, this.lastMessageSentTimeNanos, this.lastMessageReceivedTimeNanos, this.flowControlWindowReader);
    }

    public void reportStreamStarted() {
        ++this.streamsStarted;
        this.lastStreamCreatedTimeNanos = TransportTracer.currentTimeNanos();
    }

    public void reportStreamClosed(Status status) {
        if (status.isOk()) {
            ++this.streamsSucceeded;
        } else {
            ++this.streamsFailed;
        }
    }

    public void reportMessageSent() {
        ++this.messagesSent;
        this.lastMessageSentTimeNanos = TransportTracer.currentTimeNanos();
    }

    public void reportMessageReceived() {
        this.messagesReceived.add(1L);
        this.lastMessageReceivedTimeNanos = TransportTracer.currentTimeNanos();
    }

    public void reportKeepAliveSent() {
        ++this.keepAlivesSent;
    }

    public void setFlowControlWindowReader(FlowControlReader flowControlWindowReader) {
        this.flowControlWindowReader = (FlowControlReader)Preconditions.checkNotNull((Object)flowControlWindowReader);
    }

    private static long currentTimeNanos() {
        return TimeUnit.MILLISECONDS.toNanos(System.currentTimeMillis());
    }

    public static final class Stats {
        public final long streamsStarted;
        public final long lastStreamCreatedTimeNanos;
        public final long streamsSucceeded;
        public final long streamsFailed;
        public final long messagesSent;
        public final long messagesReceived;
        public final long keepAlivesSent;
        public final long lastMessageSentTimeNanos;
        public final long lastMessageReceivedTimeNanos;
        public final long localFlowControlWindow;
        public final long remoteFlowControlWindow;

        private Stats(long streamsStarted, long lastStreamCreatedTimeNanos, long streamsSucceeded, long streamsFailed, long messagesSent, long messagesReceived, long keepAlivesSent, long lastMessageSentTimeNanos, long lastMessageReceivedTimeNanos, FlowControlReader flowControlReader) {
            this.streamsStarted = streamsStarted;
            this.lastStreamCreatedTimeNanos = lastStreamCreatedTimeNanos;
            this.streamsSucceeded = streamsSucceeded;
            this.streamsFailed = streamsFailed;
            this.messagesSent = messagesSent;
            this.messagesReceived = messagesReceived;
            this.keepAlivesSent = keepAlivesSent;
            this.lastMessageSentTimeNanos = lastMessageSentTimeNanos;
            this.lastMessageReceivedTimeNanos = lastMessageReceivedTimeNanos;
            if (flowControlReader == null) {
                this.localFlowControlWindow = -1L;
                this.remoteFlowControlWindow = -1L;
            } else {
                FlowControlWindows windows = flowControlReader.read();
                this.localFlowControlWindow = windows.localBytes;
                this.remoteFlowControlWindow = windows.remoteBytes;
            }
        }
    }

    public static interface FlowControlReader {
        public FlowControlWindows read();
    }

    public static final class FlowControlWindows {
        public final long remoteBytes;
        public final long localBytes;

        public FlowControlWindows(long localBytes, long remoteBytes) {
            this.localBytes = localBytes;
            this.remoteBytes = remoteBytes;
        }
    }
}

