/*
 * Decompiled with CFR 0.152.
 */
package com.t4a.transform;

import com.t4a.JsonUtils;
import com.t4a.processor.AIProcessingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface PromptTransformer {
    public static final Logger LOGGER = LoggerFactory.getLogger(PromptTransformer.class);

    default public String transformIntoJson(String jsonString, String promptText) throws AIProcessingException {
        return this.transformIntoJson(jsonString, promptText, "get me values", "Get me the values in json");
    }

    public String transformIntoJson(String var1, String var2, String var3, String var4) throws AIProcessingException;

    default public Object transformIntoPojo(String prompt, String className) throws AIProcessingException {
        return this.transformIntoPojo(prompt, className, "funName", "description");
    }

    default public Object transformIntoPojo(String prompt, Class<?> clazz) throws AIProcessingException {
        return this.transformIntoPojo(prompt, clazz.getName(), "funName", "description");
    }

    default public Object transformIntoPojo(String prompt, String className, String funName, String description) throws AIProcessingException {
        try {
            JsonUtils util = new JsonUtils();
            Class<?> clazz = Class.forName(className);
            String jsonStr = clazz.getName().equalsIgnoreCase("java.util.Map") ? util.buildBlankMapJsonObject(null).toString(4) : (clazz.getName().equalsIgnoreCase("java.util.List") ? util.buildBlankListJsonObject(null).toString(4) : util.convertClassToJSONString(clazz));
            LOGGER.debug("Prompt: for JSON :  {},{}", (Object)prompt, (Object)jsonStr);
            jsonStr = this.getJSONResponseFromAI(prompt, jsonStr);
            LOGGER.debug("return JSON :  {}", (Object)jsonStr);
            jsonStr = jsonStr.trim();
            return util.populateClassFromJson(jsonStr);
        }
        catch (Exception e) {
            throw new AIProcessingException(e);
        }
    }

    public String getJSONResponseFromAI(String var1, String var2) throws AIProcessingException;
}

