/*
 * Decompiled with CFR 0.152.
 */
package com.t4a.processor.selenium;

import com.t4a.JsonUtils;
import com.t4a.processor.AIProcessingException;
import com.t4a.processor.AIProcessor;
import com.t4a.processor.OpenAiActionProcessor;
import com.t4a.processor.selenium.SeleniumProcessor;
import com.t4a.transform.OpenAIPromptTransformer;
import io.github.bonigarcia.wdm.WebDriverManager;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeleniumOpenAIProcessor
extends OpenAiActionProcessor
implements SeleniumProcessor {
    private static final Logger log = LoggerFactory.getLogger(SeleniumOpenAIProcessor.class);
    private WebDriver driver;
    private JsonUtils utils;
    private OpenAIPromptTransformer transformer;

    public SeleniumOpenAIProcessor(WebDriver driver) {
        this.driver = driver;
        this.utils = new JsonUtils();
        this.transformer = new OpenAIPromptTransformer();
    }

    public SeleniumOpenAIProcessor() {
        this.utils = new JsonUtils();
        this.transformer = new OpenAIPromptTransformer();
        WebDriverManager.chromedriver().setup();
        ChromeOptions options = new ChromeOptions();
        options.addArguments(new String[]{"--headless"});
        options.addArguments(new String[]{"--disable-gpu"});
        options.addArguments(new String[]{"--window-size=1920,1080"});
        this.driver = new ChromeDriver(options);
    }

    @Override
    public boolean trueFalseQuery(String question) throws AIProcessingException {
        String htmlSource = this.driver.getPageSource();
        String str = this.query(" this is your html { " + htmlSource + "} now answer this question in true or false only " + question);
        return Boolean.valueOf(str.trim());
    }

    @Override
    public AIProcessor getActionProcessor() {
        return this;
    }

    @Override
    public WebDriver getDriver() {
        return this.driver;
    }

    public void setDriver(WebDriver driver) {
        this.driver = driver;
    }

    @Override
    public JsonUtils getUtils() {
        return this.utils;
    }

    public void setUtils(JsonUtils utils) {
        this.utils = utils;
    }

    @Override
    public OpenAIPromptTransformer getTransformer() {
        return this.transformer;
    }

    public void setTransformer(OpenAIPromptTransformer transformer) {
        this.transformer = transformer;
    }
}

