/*
 * Decompiled with CFR 0.152.
 */
package com.t4a.processor;

import com.t4a.JsonUtils;
import com.t4a.api.AIAction;
import com.t4a.api.GenericJavaMethodAction;
import com.t4a.api.JavaMethodAction;
import com.t4a.detect.ActionCallback;
import com.t4a.detect.ExplainDecision;
import com.t4a.detect.HumanInLoop;
import com.t4a.processor.AIProcessingException;
import com.t4a.processor.LoggingHumanDecision;
import com.t4a.processor.LogginggExplainDecision;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;

public interface AIProcessor {
    public Object processSingleAction(String var1, AIAction var2, HumanInLoop var3, ExplainDecision var4) throws AIProcessingException;

    public Object processSingleAction(String var1, HumanInLoop var2, ExplainDecision var3) throws AIProcessingException;

    public Object processSingleAction(String var1) throws AIProcessingException;

    public Object processSingleAction(String var1, ActionCallback var2) throws AIProcessingException;

    public String query(String var1) throws AIProcessingException;

    default public String query(String question, String answer) throws AIProcessingException {
        return this.query(" this was my question { " + question + "} context - " + answer);
    }

    default public String query(String question, Object answerObj) throws AIProcessingException {
        String answer = JsonUtils.convertObjectToJson(answerObj);
        return this.query(" this was my question { " + question + "} context - " + answer);
    }

    default public String summarize(String prompt) throws AIProcessingException {
        return this.query(" Summarize this { " + prompt + "}");
    }

    default public Object processSingleAction(String promptText, Object actionInstance, String actionName) throws AIProcessingException {
        GenericJavaMethodAction action = new GenericJavaMethodAction(actionInstance, actionName);
        return this.processSingleAction(promptText, action, new LoggingHumanDecision(), new LogginggExplainDecision());
    }

    default public Object processSingleAction(String promptText, Object actionInstance) throws AIProcessingException {
        GenericJavaMethodAction action = new GenericJavaMethodAction(actionInstance);
        return this.processSingleAction(promptText, action, new LoggingHumanDecision(), new LogginggExplainDecision());
    }

    default public Object processSingleAction(String promptText, Object actionInstance, ActionCallback callback) throws AIProcessingException {
        GenericJavaMethodAction action = new GenericJavaMethodAction(actionInstance);
        return this.processSingleAction(promptText, action, new LoggingHumanDecision(), new LogginggExplainDecision(), callback);
    }

    public Object processSingleAction(String var1, AIAction var2, HumanInLoop var3, ExplainDecision var4, ActionCallback var5) throws AIProcessingException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public Object invokeReflection(Method method, JavaMethodAction javaMethodAction, List<Object> parameterValues) throws IllegalAccessException, InvocationTargetException {
        Object result = null;
        try {
            result = method.invoke(javaMethodAction.getActionInstance(), parameterValues.toArray());
        }
        finally {
            this.cleanUpThreadLocal(javaMethodAction);
        }
        return result;
    }

    default public void cleanUpThreadLocal(JavaMethodAction javaMethodAction) {
        if (javaMethodAction == null) {
            return;
        }
        Object obj = javaMethodAction.getActionInstance();
        if (obj == null) {
            return;
        }
        Class<?> clazz = obj.getClass();
        for (Field field : clazz.getDeclaredFields()) {
            field.setAccessible(true);
            try {
                ThreadLocal threadLocal;
                ParameterizedType genericType;
                if (!field.getType().equals(ThreadLocal.class) || !(field.getGenericType() instanceof ParameterizedType) || !(genericType = (ParameterizedType)field.getGenericType()).getActualTypeArguments()[0].getTypeName().equals(ActionCallback.class.getName()) || (threadLocal = (ThreadLocal)field.get(obj)) == null) continue;
                threadLocal.remove();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    default public void setCallBack(ActionCallback callback, JavaMethodAction javaMethodAction) {
        if (callback == null || javaMethodAction == null) {
            return;
        }
        Object obj = javaMethodAction.getActionInstance();
        if (obj == null) {
            return;
        }
        Class<?> clazz = this.resolveActualClass(obj);
        if (clazz == null) {
            return;
        }
        for (Field field : clazz.getDeclaredFields()) {
            field.setAccessible(true);
            try {
                ParameterizedType paramType;
                Type actualType;
                Type genericType;
                if (field.getType().equals(ActionCallback.class)) {
                    field.set(obj, callback);
                    break;
                }
                if (!ThreadLocal.class.isAssignableFrom(field.getType()) || !((genericType = field.getGenericType()) instanceof ParameterizedType) || !(actualType = (paramType = (ParameterizedType)genericType).getActualTypeArguments()[0]).getTypeName().equals(ActionCallback.class.getName())) continue;
                ThreadLocal<ActionCallback> threadLocal = (ThreadLocal<ActionCallback>)field.get(obj);
                if (threadLocal == null) {
                    threadLocal = new ThreadLocal<ActionCallback>();
                    field.set(obj, threadLocal);
                }
                threadLocal.set(callback);
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    default public Class<?> resolveActualClass(Object obj) {
        try {
            Class<?> aopUtils = Class.forName("org.springframework.aop.support.AopUtils");
            Method getTargetClass = aopUtils.getMethod("getTargetClass", Object.class);
            return (Class)getTargetClass.invoke(null, obj);
        }
        catch (ClassNotFoundException e) {
            return obj.getClass();
        }
        catch (Exception e) {
            e.printStackTrace();
            return obj.getClass();
        }
    }

    default public void setProcessor(JavaMethodAction javaMethodAction) {
        Object obj;
        if (javaMethodAction != null && (obj = javaMethodAction.getActionInstance()) != null) {
            Class<?> clazz = obj.getClass();
            for (Field field : clazz.getDeclaredFields()) {
                if (!field.getType().equals(AIProcessor.class)) continue;
                field.setAccessible(true);
                try {
                    field.set(obj, this);
                }
                catch (IllegalAccessException illegalAccessException) {}
                break;
            }
        }
    }
}

