/*
 * Decompiled with CFR 0.152.
 */
package com.t4a.predict;

import com.t4a.predict.PredictionLoader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigManager {
    private static final Logger log = LoggerFactory.getLogger(ConfigManager.class);
    private Properties properties;

    public ConfigManager() {
        this.loadProperties("prompt.properties");
    }

    private void loadProperties(String fileName) {
        this.properties = new Properties();
        try (InputStream inputStream = PredictionLoader.class.getClassLoader().getResourceAsStream(fileName);){
            if (inputStream != null) {
                this.properties.load(inputStream);
            } else {
                log.warn(fileName + " properties not found will use default values");
            }
        }
        catch (IOException e) {
            log.warn("Failed to load properties: " + e.getMessage());
        }
    }

    public String getProperty(String key, String defaultValue) {
        return this.properties.getProperty(key, defaultValue);
    }
}

