/*
 * Decompiled with CFR 0.152.
 */
package com.t4a.detect;

import java.util.regex.Pattern;

public class PromptInjectionValidator {
    private String[] threats = new String[]{"harm", "attack", "steal", "delete", "insert", "update", "drop", "create", "alter", "truncate", "grant", "revoke", "execute", "exec", "system", "shell", "cmd", "powershell", "bash", "sh", "csh", "ksh", "zsh", "tcsh", "rc", "shrc", "profile", "bashrc", "zshrc", "tcshrc", "cshrc", "kshrc", "sh_history", "bash_history", "zsh_history", "tcsh_history", "csh_history", "ksh_history", ".bash_history"};

    public boolean isValidPrompt(String prompt) {
        Pattern disallowedPattern = Pattern.compile("[^a-zA-Z0-9\\s.!?,]");
        if (disallowedPattern.matcher(prompt).find()) {
            return false;
        }
        for (String threat : this.threats) {
            if (!prompt.toLowerCase().contains(threat)) continue;
            return false;
        }
        return prompt.length() <= 1000;
    }
}

