/*
 * Decompiled with CFR 0.152.
 */
package io.github.satya64.powerbi.api.services;

import io.github.satya64.powerbi.api.model.CloneReportRequest;
import io.github.satya64.powerbi.api.model.Datasource;
import io.github.satya64.powerbi.api.model.Export;
import io.github.satya64.powerbi.api.model.ExportReportRequest;
import io.github.satya64.powerbi.api.model.ODataResponse;
import io.github.satya64.powerbi.api.model.Report;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.Path;

public interface ReportsService {
    @GET(value="reports")
    public Call<ODataResponse<List<Report>>> getReports();

    @GET(value="groups/{groupId}/reports")
    public Call<ODataResponse<List<Report>>> getReportsInGroup(@Path(value="groupId") String var1);

    @GET(value="reports/{reportId}")
    public Call<Report> getReport(@Path(value="reportId") String var1);

    @GET(value="groups/{groupId}/reports/{reportId}")
    public Call<Report> getReportInGroup(@Path(value="groupId") String var1, @Path(value="reportId") String var2);

    @POST(value="reports/{reportId}/Clone")
    public Call<Report> cloneReport(@Path(value="reportId") String var1, @Body CloneReportRequest var2);

    @POST(value="groups/{groupId}/reports/{reportId}/Clone")
    public Call<Report> cloneReportInGroup(@Path(value="groupId") String var1, @Path(value="reportId") String var2, @Body CloneReportRequest var3);

    @POST(value="reports/{reportId}/Export")
    public Call<ResponseBody> exportReport(@Path(value="reportId") String var1);

    @POST(value="groups/{groupId}/reports/{reportId}/Export")
    public Call<ResponseBody> exportReportInGroup(@Path(value="groupId") String var1, @Path(value="reportId") String var2);

    @GET(value="reports/{reportId}/datasources")
    public Call<ODataResponse<List<Datasource>>> getReportDatasources(@Path(value="reportId") String var1);

    @GET(value="groups/{groupId}/reports/{reportId}/datasources")
    public Call<ODataResponse<List<Datasource>>> getReportDatasourcesInGroup(@Path(value="groupId") String var1, @Path(value="reportId") String var2);

    @DELETE(value="reports/{reportId}")
    public Call<Void> deleteReport(@Path(value="reportId") String var1);

    @DELETE(value="groups/{groupId}/reports/{reportId}")
    public Call<Void> deleteReportInGroup(@Path(value="groupId") String var1, @Path(value="reportId") String var2);

    @POST(value="reports/{reportId}/ExportTo")
    public Call<Export> exportReportToFile(@Path(value="reportId") String var1, @Body ExportReportRequest var2);

    @POST(value="groups/{groupId}/reports/{reportId}/ExportTo")
    public Call<Export> exportReportInGroupToFile(@Path(value="groupId") String var1, @Path(value="reportId") String var2, @Body ExportReportRequest var3);

    @GET(value="reports/{reportId}/exports/{exportId}")
    public Call<Export> getExportToFileStatus(@Path(value="reportId") String var1, @Path(value="exportId") String var2);

    @GET(value="groups/{groupId}/reports/{reportId}/exports/{exportId}")
    public Call<Export> getExportToFileStatusInGroup(@Path(value="groupId") String var1, @Path(value="reportId") String var2, @Path(value="exportId") String var3);

    @GET(value="reports/{reportId}/exports/{exportId}/file")
    public Call<ResponseBody> getFileOfExportToFile(@Path(value="reportId") String var1, @Path(value="exportId") String var2);

    @GET(value="groups/{groupId}/reports/{reportId}/exports/{exportId}/file")
    public Call<ResponseBody> getFileOfExportToFileInGroup(@Path(value="groupId") String var1, @Path(value="reportId") String var2, @Path(value="exportId") String var3);
}

